<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Layout</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/spectrum-colorpicker2/dist/spectrum.min.css">

    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>
<style>
    form .dropify-wrapper .dropify-preview .dropify-render img {
        object-fit: cover;
    }

    form .dropify-wrapper {
        display: block;
        position: relative;
        cursor: pointer;
        border-radius: 10px;
        object-fit: cover;
        width: 300px;
        height: 300px;
        overflow: hidden;
        max-width: 100%;
        font-size: 14px;
        line-height: 22px;
        color: #777;
        background-color: #FFF;
        border: 2px solid #E5E5E5;
        -webkit-transition: border-color .15s linear;
        transition: border-color .15s linear
    }
</style>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Layout</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Configurações</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Aparência</a></li>
                            <li class="breadcrumb-item active">Layout</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-globe"></i></div>
                            <div class="card-body">
                                <!-- Layout -->
                                <form method="post" action="${baseUri}/configuracao/gravar_layout/">
                                    <input type="hidden" name="config_id" value="1">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-6 col-lg-6">
                                                <br>
                                                <h4 class="separator-line">Personalizar Layout</h4>
                                                <hr>
                                            </div>
                                            <div class="col-sm-12 col-md-6 col-lg-6">
                                                <br>
                                                <h4 class="separator-line">Personalizar Logo (Desktop)</h4>
                                                <hr>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-12 col-md-6 col-lg-6">
                                                <div class="form-check2">
                                                    <input class="form-check-input" type="radio" name="config_site_layout" id="config_site_layout1" value="1" checked>
                                                    <label class="form-check-label" for="config_site_layout1">
                                                        Layout Full
                                                    </label>
                                                </div>
                                                <br>
                                                <div class="form-check2">
                                                    <input class="form-check-input" type="radio" name="config_site_layout" id="config_site_layout2" value="2">
                                                    <label class="form-check-label" for="config_site_layout2">
                                                        Layout Boxed
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-6 col-lg-6">
                                                <div class="row">
                                                    <div class="col-sm-12 col-md-6 col-lg-6">
                                                        <div class="form-group">
                                                            <label for="">Altura da Logo <span id="label_altura"></span> </label>
                                                            <input type="range" min="50" max="110" value="${config_site_layout_altura_logo}" class="slider" name="config_site_layout_altura_logo" id="config_site_layout_altura_logo">
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 col-md-6 col-lg-6">
                                                        <div class="form-group">
                                                            <label for="">Largura da Logo <span id="label_largura"></span></label>
                                                            <input type="range" min="50" max="300" value="${config_site_layout_largura_logo}" class="slider" name="config_site_layout_largura_logo" id="config_site_layout_largura_logo">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="col-12 text-center">
                                                <div class="form-group">
                                                    <br>
                                                    <button type="submit" id="btn-send" class="btn btn-primary"><i class="fas fa-check-circle"></i> Atualizar Layout
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </form>
                                <!-- Fim Layout -->

                                <!-- Cores -->
                                <form method="post" action="${baseUri}/configuracao/gravar_cores/">
                                    <input type="hidden" name="config_cores_id" value="1">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <h4 class="separator-line">Personalizar Cores</h4>
                                                <hr>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-12 col-md-3">
                                                <input type="hidden" name="config_cores_id[]" value="1">
                                                <input type="hidden" name="config_cores_local[]" value="Topo">
                                                <h5>Topo</h5>
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][0]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][0]->config_cores_texto ?>">
                                                <label for="">Textos</label>
                                                <br>
                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">
                                                <input type="color" class="input_color" name="config_cores_hover_texto[]" value="<?= $data['cores'][0]->config_cores_hover_texto ?>">
                                                <label for="">Hover Textos</label>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <input type="hidden" name="config_cores_id[]" value="2">
                                                <input type="hidden" name="config_cores_local[]" value="Menu">
                                                <h5>Menu</h5>
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][1]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][1]->config_cores_texto ?>">
                                                <label for="">Textos</label>
                                                <br>
                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">

                                                <input type="color" class="input_color" name="config_cores_hover_texto[]" value="<?= $data['cores'][1]->config_cores_hover_texto ?>">
                                                <label for="">Hover Textos</label>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Loja</h5>
                                                <input type="hidden" name="config_cores_id[]" value="3">
                                                <input type="hidden" name="config_cores_local[]" value="Loja">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][2]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][2]->config_cores_texto ?>">
                                                <label for="">Textos</label>

                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">

                                                <input type="hidden" name="config_cores_hover_texto[]" value="#000">

                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Newsletter e redes sociais</h5>
                                                <input type="hidden" name="config_cores_id[]" value="4">
                                                <input type="hidden" name="config_cores_local[]" value="Redes Sociais">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][3]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][3]->config_cores_texto ?>">
                                                <label for="">Textos</label>

                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">

                                                <input type="hidden" name="config_cores_hover_texto[]" value="#000">

                                            </div>

                                            <div class="col-sm-12">
                                                <br>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Rodapé de Informações</h5>
                                                <input type="hidden" name="config_cores_id[]" value="5">
                                                <input type="hidden" name="config_cores_local[]" value="Rodapé Informações">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][4]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][4]->config_cores_texto ?>">
                                                <label for="">Textos</label>
                                                <br>
                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">
                                                <input type="color" class="input_color" name="config_cores_hover_texto[]" value="<?= $data['cores'][4]->config_cores_hover_texto ?>">
                                                <label for="">Hover Textos</label>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Rodapé</h5>
                                                <input type="hidden" name="config_cores_id[]" value="6">
                                                <input type="hidden" name="config_cores_local[]" value="Rodapé">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][5]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][5]->config_cores_texto ?>">
                                                <label for="">Textos</label>

                                                <input type="hidden" name="config_cores_hover_fundo[]" value="#000">

                                                <input type="hidden" name="config_cores_hover_texto[]" value="#000">

                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Botões Principais</h5>
                                                <input type="hidden" name="config_cores_id[]" value="7">
                                                <input type="hidden" name="config_cores_local[]" value="Botões Principais">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][6]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][6]->config_cores_texto ?>">
                                                <label for="">Textos</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_hover_fundo[]" value="<?= $data['cores'][6]->config_cores_hover_fundo ?>">
                                                <label for="">Hover Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_hover_texto[]" value="<?= $data['cores'][6]->config_cores_hover_texto ?>">
                                                <label for="">Hover Textos</label>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <h5>Botões Secundários</h5>
                                                <input type="hidden" name="config_cores_id[]" value="8">
                                                <input type="hidden" name="config_cores_local[]" value="Botões de Sucesso">
                                                <input type="color" class="input_color" name="config_cores_fundo[]" value="<?= $data['cores'][7]->config_cores_fundo ?>">
                                                <label for="">Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_texto[]" value="<?= $data['cores'][7]->config_cores_texto ?>">
                                                <label for="">Textos</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_hover_fundo[]" value="<?= $data['cores'][7]->config_cores_hover_fundo ?>">
                                                <label for="">Hover Fundo</label>
                                                <br>
                                                <input type="color" class="input_color" name="config_cores_hover_texto[]" value="<?= $data['cores'][7]->config_cores_hover_texto ?>">
                                                <label for="">Hover Textos</label>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12 text-center">
                                                <div class="form-group">
                                                    <br>
                                                    <button type="submit" id="btn-send" class="btn btn-primary"><i class="fas fa-check-circle"></i> Atualizar Cores
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                </form>
                                <!-- Fim Cores -->
                                
                                <!-- Footer -->
                                <form method="post" action="${baseUri}/configuracao/gravar_rodape/">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-sm-12">

                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12 col-sm-12 col-md-4 col-lg-4">
                                                <div class="row">
                                                    <div class="col-12 col-sm-12">
                                                        <h4 class="separator-line">Opções de Layout de rodapé</h4>
                                                        <hr>
                                                    </div>
                                                    <div class="col-sm-12">
                                                        <div class="form-check2">

                                                            <input class="form-check-input" type="radio" name="config_site_layout_footer" id="config_site_layout_footer1" value="1" checked>
                                                            <label class="form-check-label" for="config_site_layout_footer1">
                                                                Rodapé 3 colunas
                                                            </label>
                                                        </div>
                                                        <br>
                                                        <div class="form-check2">
                                                            <input class="form-check-input" type="radio" name="config_site_layout_footer" id="config_site_layout_footer2" value="2">
                                                            <label class="form-check-label" for="config_site_layout_footer2">
                                                                Rodapé Slim
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-12 text-center">
                                                <div class="form-group">
                                                    <br>
                                                    <button type="submit" id="btn-send" class="btn btn-primary"><i class="fas fa-check-circle"></i> Atualizar Rodapé
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                </form>
                                <!-- Footer -->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->
                <!-- Config Tema botão float import -->
                @(admin.layout.config-tema)
            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/spectrum-colorpicker2/dist/spectrum.min.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script type="text/javascript">
        $('.menu-aparencia').addClass('active');
        $('.menu-layout').addClass('active');

        $('.dropify').dropify({
            messages: {
                default: 'Clique aqui para selecionar uma imagem',
                replace: 'Clique em remover para selecionar uma nova imagem',
                remove: 'Remover',
                error: 'Ocorreu um erro ao alterar a imagem'
            },
            error: {
                'fileSize': 'O tamanho máximo permitido é de: ({{ value }}).',
                'minWidth': 'The image width is too small ({{ value }}}px min).',
                'maxWidth': 'The image width is too big ({{ value }}}px max).',
                'minHeight': 'The image height is too small ({{ value }}}px min).',
                'maxHeight': 'The image height is too big ({{ value }}px max).',
                'imageFormat': 'Os formatos de imagem permitidos são: ({{ value }}).',
                'fileExtension': 'As extensões permitidas são: ({{ value }}).'
            }
        });
        let sliderMapa = document.getElementById("config_site_layout_altura_mapa");
        let outputMapa = document.getElementById("label_mapa");
        let sliderFacebook = document.getElementById("config_site_layout_altura_facebook");
        let outputFacebook = document.getElementById("label_facebook");

        let sliderAlturaLogo = document.getElementById("config_site_layout_altura_logo");
        let outputAlturaLogo = document.getElementById("label_altura");
        let sliderLarguraLogo = document.getElementById("config_site_layout_largura_logo");
        let outputLarguraLogo = document.getElementById("label_largura");

        $(document).ready(function() {
            document.getElementById("config_site_layout${config_site_layout}").checked = true;
            console.log("${config_site_layout_footer}");
            document.getElementById("config_site_layout_footer${config_site_layout_footer}").checked = true;
            document.getElementById("config_site_mapa_rodape${config_site_mapa_rodape}").checked = true;


            outputFacebook.innerHTML = sliderFacebook.value + " Pixels";
            sliderFacebook.oninput = function() {
                outputFacebook.innerHTML = this.value + " Pixels";
            };


            outputMapa.innerHTML = sliderMapa.value + " Pixels";
            sliderMapa.oninput = function() {
                outputMapa.innerHTML = this.value + " Pixels";
            };

            outputAlturaLogo.innerHTML = sliderAlturaLogo.value + " Pixels";
            sliderAlturaLogo.oninput = function() {
                outputAlturaLogo.innerHTML = this.value + " Pixels";
            };

            outputLarguraLogo.innerHTML = sliderLarguraLogo.value + " Pixels";
            sliderLarguraLogo.oninput = function() {
                outputLarguraLogo.innerHTML = this.value + " Pixels";
            };

            /*
            $('.input_color').spectrum({
                type: "color",
                preferredFormat: "hex",
                allowEmpty: false,
                showAlpha: false,
            });
            */
        });
    </script>
</body>

</html>