<?php

namespace Frete;

class Kangu
{
    public function get_frete($conf, $produtos)
    {
        $conf = (object) $conf;
        $itens = [];
        $frete = [];
        $peso = $produtos[0]["peso"];
        $altura = $produtos[0]["altura"];
        $largura = $produtos[0]["largura"];
        $comprimento = $produtos[0]["comprimento"];
        foreach ($produtos as $k) {
            $k = (object) $k;

            if ($k->produto_calcula_frete > 0) {
                $itens[] = [
                    "altura" => str_replace(",", ".", $k->altura),
                    "comprimento" => str_replace(",", ".", $k->comprimento),
                    "quantidade" => $k->quantidade,
                    "peso" => str_replace(",", ".", $k->peso),
                    "largura" => str_replace(",", ".", $k->largura),
                    "valor" => $k->produto_preco,
                ];
            }
        }
        $postagem = [
            "cepOrigem" => $conf->cep_origem,
            "cepDestino" => $conf->cep_destino,
            "vlrMerc" => 1,
            "pesoMerc" => 1,
            "volumes" => [
                [
                    "peso" => $peso,
                    "altura" => $altura,
                    "largura" => $largura,
                    "comprimento" => $comprimento,
                    "tipo" => "padrao",
                    "valor" => 0,
                    "quantidade" => 1
                ]
            ],
            "produtos" => [],
            "servicos" => ["E", "X"],
            "ordernar" => "preco"
        ];
        $postagem['produtos'] = $itens;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://portal.kangu.com.br/tms/transporte/simular');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postagem));
        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = "Token: $conf->kangu_token";
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        //echo $result;        exit;
        curl_close($ch);
        if (!curl_errno($ch)) {
            $rs = json_decode($result);
            foreach ($rs as $serv) {
                $frete[] = [
                    "code" => $serv->idTranspResp,
                    "price" => $serv->tarifas[0]->valor,
                    "name" => $serv->transp_nome,
                    "deadline" => $serv->prazoEnt,
                    "rastreio" => 2
                ];
            }
        } else {
            echo 'Error:' . curl_error($ch);
        }

        return $frete;
    }
}
