<?php

namespace Frete;

class FreteFaixaCep
{
    public function get_frete($faixas, $destino, $peso)
    {
        $result = [];
        $destino = str_replace('-', '', $destino);
        if (isset($faixas[0])) {
            foreach ($faixas as $k) {
                if (
                    $destino >= $k->faixa_cep_inicio
                    && $destino <= $k->faixa_cep_final &&
                    $peso >= $k->faixa_cep_peso_de && $peso <= $k->faixa_cep_peso_ate
                ) {
                    $result[] = [
                        "code" => $k->faixa_cep_inicio,
                        "price" => $k->faixa_cep_valor,
                        "name" => $k->faixa_cep_desc,
                        "deadline" => $k->faixa_cep_prazo,
                        "rastreio" => 3
                    ];
                }
            }
        }
        return $result;
    }
}
