<?php

/**
 * Status das NF
 * 
 * 1: Aprovada
 * 2: Rejeitada
 * 3: Pendente(gerada mas não enviada pro SEFAZ)
 */

namespace Erp;

class BlingApi
{
    static function autorizacao_callback($integracao)
    {
        if (isset($_GET['code']) && !empty($_GET['code'])) {
            $api = [
                "grant_type" => "authorization_code",
                "code" => $_GET['code'],
            ];

            $base = base64_encode("$integracao->integracao_client_id:$integracao->integracao_secret");
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => "https://www.bling.com.br/Api/v3/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => http_build_query($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: 1.0",
                    "Content-Type: application/x-www-form-urlencoded",
                    "Authorization: Basic $base",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                return (object)['status' => -1, 'response' => $err];
            } else {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    return (object)['status' => 1, 'response' => $response];
                } else {
                    return (object)['status' => 0, 'response' => $response];
                }
            }
        }
    }

    static function atualizar_token($integracao)
    {
        $api = [
            "grant_type" => "refresh_token",
            "refresh_token" => $integracao->integracao_refresh_token,
        ];

        $base = base64_encode("$integracao->integracao_client_id:$integracao->integracao_secret");
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/oauth/token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Basic $base",
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        } else {
            $response = json_decode($response);
            if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                return (object)['status' => 1, 'response' => $response];
            } else {
                return (object)['status' => 0, 'response' => $response];
            }
        }
    }

    static function gerar_nfe($integracao, $data)
    {
        $api = self::get_fields(
            $data['pedido'],
            $data['cliente'],
            $data['produtos']
        );

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/nfe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Bearer $integracao->integracao_token",
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        } else {
            $response = json_decode($response);
            if (isset($response->data) && isset($response->data->id) && !empty($response->data->id)) {
                return (object)['status' => 1, 'response' => $response->data];
            } else {
                return (object)['status' => 0, 'response' => $response];
            }
        }
    }

    static function enviar_nfe($integracao, $nfe_id)
    {
        $api = [
            'idNotaFiscal' => $nfe_id
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/nfe/$nfe_id/enviar",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Bearer $integracao->integracao_token",
            ],
        ]);
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        $response = json_decode($response);

        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        }
        if (isset($response->data->xml) && !empty($response->data->xml)) {
            $xml = new SimpleXMLElement($response->data->xml);
            if (isset($xml->protNFe->infProt) && isset($xml->protNFe->infProt->chNFe) && !empty($xml->protNFe->infProt->chNFe)) {
                //APROVADA
                if (isset($xml->protNFe->infProt->nProt)) {
                    return (object)['status' => 1, 'response' => $xml->protNFe->infProt];
                }
                //REJEITADA
                else {
                    return (object)['status' => 2, 'response' => $xml->protNFe->infProt];
                }
            } else {
                return (object)['status' => -2, 'response' => $xml];
            }
        } else {
            return (object)['status' => 0, 'response' => $response];
        }
    }

    static function get_fields($pedido, $cliente, $produtos)
    {
        $data = [
            "tipo" => 1,
            //"numero" => "$pedido->pedido_id",
            "dataOperacao" => date('Y-m-d H:i:00'),
            "contato" => self::get_contato($cliente, $pedido),
            "finalidade" => 1,
            "observacoes" => "NF gerada pela loja virtual.",
            "itens" => self::get_itens($produtos),
            'desconto' => self::get_desconto($pedido)
        ];

        if ($pedido->pedido_entrega == 1) {
            $data['transporte'] = [
                "fretePorConta" => 0,
                "frete" => $pedido->pedido_total_frete,
            ];
        }
        return $data;
    }

    static function get_contato($cliente)
    {
        $contato = [
            "nome" => "$cliente->cliente_nome",
            "tipoPessoa" => ($cliente->cliente_tipo == 1) ? 'F' : 'J',
            "numeroDocumento" => ($cliente->cliente_tipo == 1) ? Filter::parse_numeric($cliente->cliente_cpf) : Filter::parse_numeric($cliente->cliente_cnpj),
            "rg" => "$cliente->cliente_rg",
            "telefone" => "$cliente->cliente_telefone",
            "email" => "$cliente->cliente_email",
        ];

        //Se dados de endereço da tabela do cliente tiver prenchido
        if (
            isset($cliente->cliente_cep) && !empty($cliente->cliente_cep) && isset($cliente->cliente_rua) && !empty($cliente->cliente_rua) &&
            isset($cliente->cliente_num) && !empty($cliente->cliente_num)
        ) {
            $contato['endereco'] = [
                "endereco" => "$cliente->cliente_rua",
                "numero" => "$cliente->cliente_num",
                "complemento" => "$cliente->cliente_complemento",
                "bairro" => "$cliente->cliente_bairro",
                "cep" => "$cliente->cliente_cep",
                "municipio" => $cliente->cliente_cidade,
                "uf" => $cliente->cliente_uf,
                "pais" => "",
            ];
        } //Caso contrario pega um endereço da tabela do cliente
        else if (isset($cliente->endereco_cliente_id) && !empty($cliente->endereco_cliente_id) && $cliente->endereco_cliente_id > 0) {
            $contato['endereco'] = [
                "endereco" => "$cliente->endereco_cliente_rua",
                "numero" => "$cliente->endereco_cliente_num",
                "complemento" => "$cliente->endereco_cliente_complemento",
                "bairro" => "$cliente->endereco_cliente_bairro",
                "cep" => "$cliente->endereco_cliente_cep",
                "municipio" => $cliente->endereco_cliente_cidade,
                "uf" => $cliente->endereco_cliente_uf,
                "pais" => "",
            ];
        }

        if ($cliente->cliente_tipo == 1) {
            $contato['contribuinte'] = 9;
        } else if ($cliente->cliente_tipo == 2) {
            $contato['contribuinte'] = 1;
            $contato['ie'] = $cliente->cliente_ie;
        }

        return $contato;
    }

    static function get_itens($produtos)
    {
        $itens = [];
        if (isset($produtos[0]) && !empty($produtos)) {
            foreach ($produtos as $produto) {
                $itens[] = [
                    "codigo" => ($produto->produto_ref) ? "$produto->produto_ref" : "$produto->produto_id",
                    "descricao" => $produto->produto_titulo,
                    "unidade" => $produto->produto_tipo_unidade,
                    "quantidade" => $produto->lista_pedido_qtde,
                    "valor" => $produto->lista_pedido_preco,
                    "tipo" => "P",
                    "pesoBruto" => $produto->produto_peso,
                    "pesoLiquido" => $produto->produto_peso,
                    "numeroPedidoCompra" => "$produto->lista_pedido_pedido",
                    "classificacaoFiscal" => "$produto->produto_class_fiscal", //NCM 
                    "origem" => 0,
                ];
            }
        }
        return $itens;
    }

    static function get_desconto($pedido)
    {
        //Calculando o desconto
        $total = floatval($pedido->pedido_total_produto) + floatval($pedido->pedido_total_frete);
        $desconto = $total - floatval($pedido->pedido_total_parcelado);
        $desconto = ($desconto > 0) ? $desconto : 0;
        return $desconto;
    }
}
