<section class="${config_site_layout_custom}">
    <?php if (is_array($data['produtosDestaque']) && sizeof($data['produtosDestaque']) > 0) : ?>
        <h2 class="text-center pt-4">Destaques</h2>
        <div class="add_div_carousel">
            <div id="produtosDestaque" class="row">
                <?php foreach ($data['produtosDestaque'] as $prod) : ?>
                    <div class="col-lg-3 col-md-4 col-sm-12 mt-4">
                        <div class="product-card">
                            <a href="${baseUri}/produto/<?= $prod->produto_url ?>">
                                <div class="product-thumb">
                                    <?php if ($prod->produto_oferta == 1) : ?>
                                        <span class="badge p-2 oferta rounded-0">OFERTA</span>
                                    <?php endif; ?>
                                    <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto ?>" alt="foto" class="img-fluid d-block">
                                    <?php if ($prod->produto_foto_hover != "") : ?>
                                        <span>
                                            <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto_hover ?>" class="foto-hover img-fluid d-block" />
                                        </span>
                                    <?php endif; ?>

                                    <?php if (1 == 2) : ?>
                                        hardcode para
                                        <img src="${baseUri}/media/produto/<?= $prod->produto_foto_hover ?>" class="foto-hover" />
                                    <?php endif; ?>

                                </div>
                                <div class="product-card-body">
                                    <span class="product-title"><?= (($prod->produto_titulo)) ?></span>
                                    <?php if ($prod->produto_estoque <= 0) : ?>
                                        <p class="hide-on-vitrine product-title-indisponivel">Indisponível</p>
                                    <?php else : ?>
                                        <?php if ($prod->produto_desconto > 0) : ?>
                                            <span class="hide-on-orcamento product-card-text-line">
                                                R$ <?= $prod->produto_preco_original ?>
                                            </span>
                                        <?php endif; ?>
                                        <span class="hide-on-orcamento product-card-text-price">
                                            R$ <?= $prod->produto_preco ?>
                                        </span>
                                        <?php if ($prod->qtd_parcelas_sem_juros > 1) : ?>
                                            <span class="hide-on-orcamento product-card-parc">
                                                <?= $prod->produto_text_parc ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php if ($prod->desc_boleto > 0) : ?>
                                            <span class="hide-on-orcamento product-card-disc">
                                                ${config_card_text_desconto} R$ <?= $prod->produto_preco_desc_boleto ?>
                                            </span>
                                            <small class="hide-on-orcamento product-card-percent">
                                                <?= $prod->desc_boleto ?>${config_card_text_percent}
                                            </small>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>

                                <?php if ($prod->produto_estoque <= 0): ?>
                                    <button class="btn btn-primary btn-block btn-sm hide-on-vitrine" type="button">
                                        <i class="fa fa-envelope"></i>
                                        AVISE-ME QUANDO CHEGAR
                                    </button>
                                <?php else: ?>
                                    <button class="btn btn-primary btn-block btn-sm hide-on-vitrine" type="button">
                                        <i class="fa fa-shopping-cart"></i>
                                        ${config_card_tooltip_text}
                                    </button>
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</section>