<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title} - <?= $data['pagina']->categoria_pagina_nome ?> - <?= $data['pagina']->pagina_titulo ?> </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    <!-- OG Tags exclusiva pras paginas -->
    <meta property="og:title" content="${config_site_title} - <?= $data['pagina']->categoria_pagina_nome ?> - <?= $data['pagina']->pagina_titulo ?>">
    <meta property="og:description" content="${pagina_desc}">
    <meta property="og:keywords" content="${pagina_keywords}">
    <meta property="og:site_name" content="${config_site_title}">
    <meta property="og:locale" content="pt_BR">
    <meta property="og:type" content="website">
    <meta property="og:url" content="${baseUri}/<?= $data['pagina']->categoria_pagina_nome ?>/<?= $data['pagina']->pagina_titulo ?>">
    <meta property="og:image" content="${baseUri}/media/pagina/${pagina_capa}">
    <!-- OG Tags exclusiva pras paginas -->
    <!-- SEO -->
    <link href="assets/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/plugins/no-ui-slider/nouislider.min.css" rel="stylesheet" />
    <link href="assets/plugins/owl-carousel/owl.carousel.min.css" rel="stylesheet" media="screen">
    <link href="assets/plugins/owl-carousel/owl.theme.default.min.css" rel="stylesheet" media="screen">
    <link href="assets/plugins/fancybox/jquery.fancybox.min.css" rel="stylesheet" />
    <link href="assets/plugins/isotope/isotope.min.css" rel="stylesheet" />
    <link href="assets/plugins/animate/animate.css" rel="stylesheet">
    <link href="assets/plugins/revolution/css/settings.css" rel="stylesheet">
    <link href="assets/plugins/revolution/css/layers.css" rel="stylesheet">
    <link href="assets/plugins/revolution/css/navigation.css" rel="stylesheet">
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    <link href="//fonts.googleapis.com/css?family=Dosis:300,400,600,700|Open+Sans:300,400,600,700" rel="stylesheet">
    @(tema.loja.partials.css-padrao)
</head>
<!-- Body-->

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)

    <!-- Produtos resultados da busca -->


    <div class="main-wrapper mt-mobile">
        <?php if (isset($data['pagina']) && !empty($data['pagina'])) : ?>
            <section class="py-2 py-md-2">
                <div class="${config_site_layout_custom}">
                    <div classs="card shadow-none bg-transparent mb-0">
                        <?php if (isset($data['pagina']->pagina_capa) && !empty($data['pagina']->pagina_capa) && $data['pagina']->pagina_capa != 'default.png') : ?>
                            <div class="position-center text-center">
                                <img class="card-img-top" src="${baseUri}/media/pagina/${pagina_capa}" alt="" style="border-radius: 5px; width: 50vw !important;">
                                <div class="card-img-overlay"></div>
                            </div>
                            <div class="card-body border-top-5 border-danger p-3 p-md-5">
                            <?php else : ?>
                                <div class="card-body p-3 p-md-5" style="margin-bottom: 50px;">
                                <?php endif; ?>
                                <br><br>
                                <div class="section-title justify-content-center mb-4 mb-md-8 wow fadeInUp text-center">
                                    <span class="shape shape-left bg-info"></span>
                                    <h2 class="text-primary custom_loja_texto font_smooth">${pagina_titulo}</h2>
                                    <span class="shape shape-right bg-info"></span>
                                </div>
                                ${pagina_texto}
                                </div>
                            </div>
                    </div>
            </section>
        <?php else : ?>
            <h2 class="text-primary text-center">Nenhuma página encontrada</h2>
        <?php endif; ?>
        <br><br><br>
    </div>

    <!-- Fim Produtos resultados da busca -->

    @(tema.loja.partials.blog-insta)

    @(tema.loja.partials.toasts)

    @(tema.loja.partials.footer)


    <!-- JavaScript (jQuery) libraries, plugins and custom scripts-->
    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script src="pagina/index.js"></script>
</body>

</html>