<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)

    <!-- Produtos resultados da busca -->

    <div class="hide-on-desk" style="position: relative; margin-top: 150px !important"></div>
    <section class="${config_site_layout_custom} pt-4 pb-4">
        <div class="row">
            <div class="col-sm-12 col-md-12 col-lg-12  mt-5">
                <h2 class="pb-2 text-center custom_loja_texto font_smooth">Lista de Desejos</h2>
            </div>
        </div>
        <div id="vue-favoritos" class="row">
            <div class="col-sm-12 col-md-9 col-lg-9">
                <div class="row">
                    <!-- Product-->
                    <?php if (is_array($data['produtos']) && sizeof($data['produtos']) > 0) : ?>
                        <?php foreach ($data['produtos'] as $prod) : ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 mt-5 text-center custom_loja_fundo">
                                <div class="product-card mb-4 custom_loja_fundo">
                                    <div class="product-thumb">
                                        <a class="product-thumb-link" href="${baseUri}/produto/<?= $prod->produto_url ?>"></a>
                                        <?php if ($prod->produto_oferta == 1) : ?>
                                            <span class="badge badge-danger rounded-0">Oferta</span>
                                        <?php endif; ?>
                                        <img src="${baseUri}/thumb/resize/?w=400&h=400&f=<?= $prod->produto_foto ?>" alt="produto">
                                    </div>
                                    <div class="product-card-body text-center custom_loja_fundo">
                                        <h2 class="product-card-title"><a class="custom_loja_texto" href="${baseUri}/produto/<?= $prod->produto_url ?>"><?= Filter::cut($prod->produto_titulo, 50, '...') ?></a></h2>
                                        <?php if ($prod->produto_estoque <= 0) : ?>
                                            <span class="text-primary hide-on-vitrine custom_loja_texto product-card-text">Indisponível</span>
                                        <?php else : ?>
                                            <?php if ($prod->produto_desconto > 0) : ?>
                                                <span class="text-primary hide-on-vitrine hide-on-orcamento custom_loja_texto product-card-text" style="text-decoration: line-through; color: red !important;">R$ <?= $prod->produto_preco_original ?></span>
                                            <?php endif; ?>
                                            <span class="text-primary hide-on-vitrine hide-on-orcamento custom_loja_texto product-card-text">R$ <?= $prod->produto_preco ?></span>

                                            <?php if ($prod->qtd_parcelas > 1) : ?>
                                                <br>
                                                <span class="hide-on-vitrine hide-on-orcamento custom_loja_texto product-card-text">
                                                    <b class="text-primary hide-on-vitrine text-success"><?= $prod->qtd_parcelas ?>X</b> de <b class="text-primary hide-on-vitrine text-success">R$ <?= $prod->produto_preco_parc ?></b> c/ juros
                                                </span>
                                            <?php endif; ?>

                                            <?php if ($prod->desc_boleto > 0) : ?>
                                                <br>
                                                <small class="text-muted hide-on-vitrine hide-on-orcamento custom_loja_texto product-card-text">À vista no boleto <b class="text-primary hide-on-vitrine text-success">R$ <?= $prod->produto_preco_desc_boleto ?></b></small>
                                                <br>
                                                <small class="text-muted hide-on-vitrine hide-on-orcamento custom_loja_texto">(<?= $prod->desc_boleto ?>% de desconto)</small>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="product-card-body body-hidden pb-1" style="background-color: transparent !important;">
                                        <?php if (isset($prod->produto_qtd_atributos) && !empty($prod->produto_qtd_atributos) && intval($prod->produto_qtd_atributos) > 0 && intval($prod->produto_estoque > 0)) : ?>
                                            <a class="btn btn-primary btn-sm pull-right  hide-on-vitrine" style="padding-left: 21px;" href="${baseUri}/produto/<?= $prod->produto_url ?>"><i class="fa fa-shopping-cart mr-2"></i></a>
                                        <?php elseif ($prod->produto_estoque > 0) : ?>
                                            <button class="btn btn-primary btn-sm pull-right  hide-on-vitrine" style="padding-left: 21px;" type="button" onclick='setProdutoInCarrinho(`<?= json_encode($prod) ?>`)'><i class="fa fa-shopping-cart mr-2"></i> </button>
                                        <?php endif; ?>
                                        <!--FAVORITAR-->
                                        <button id="btn_remove_favorite_<?= $prod->produto_id ?>" class="btn btn-primary btn-sm pull-left e-on-vitrine" style="padding-left: 21px;" type="button" v-on:click='favoritar(<?= $prod->produto_id ?>)'>
                                            <i class="fa fa-heart mr-2"></i>
                                        </button>
                                        <!--FAVORITAR-->
                                    </div>

                                    <div class="product-card-body d-lg-none custom_loja_fundo">
                                        <?php if (isset($prod->produto_qtd_atributos) && !empty($prod->produto_qtd_atributos) && intval($prod->produto_qtd_atributos) > 0  && intval($prod->produto_estoque > 0)) : ?>
                                            <button id="btn_remove_favorite_<?= $prod->produto_id ?>" class="btn btn-primary btn-sm  hide-on-vitrine btn-block" style="padding-left: 21px;" type="button" v-on:click='favoritar(<?= $prod->produto_id ?>)'>
                                                <i class="fa fa-heart mr-2"></i>
                                            </button>
                                            <a class="btn btn-primary btn-sm  hide-on-vitrine btn-block" href="${baseUri}/produto/<?= $prod->produto_url ?>"> Adicionar ao carrinho</a>
                                        <?php elseif ($prod->produto_estoque > 0) : ?>
                                            <button id="btn_remove_favorite_<?= $prod->produto_id ?>" class="btn btn-primary btn-sm  hide-on-vitrine btn-block" style="padding-left: 21px;" type="button" v-on:click='favoritar(<?= $prod->produto_id ?>)'>
                                                <i class="fa fa-heart mr-2"></i>
                                            </button>
                                            <button class="btn btn-primary btn-sm  hide-on-vitrine btn-block" type="button" onclick='setProdutoInCarrinho(`<?= json_encode($prod) ?>`)'>Adicionar ao carrinho</button>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <div class="col-sm-12 col-md-12">
                            <h3 class="text-center">Nenhum produto foi adicionado a lista</h3>
                        </div>
                    <?php endif; ?>
                    <!-- End produto -->
                </div>
            </div>
        </div>



    </section>

    <!-- Fim Produtos resultados da busca -->

    @(tema.loja.partials.blog-insta)

    @(tema.loja.partials.toasts)

    @(tema.loja.partials.footer)


    <!-- JavaScript (jQuery) libraries, plugins and custom scripts-->
    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script src="favorito/index.js"></script>

    <script>
        $('.money').mask("#.##0,00", {
            reverse: true
        });
    </script>
</body>

</html>