var vmFavoritos = new Vue({
    el: "#vue-favoritos",
    data: {},
    methods: {
        favoritar: function (id) {
            let produto_id = id;
            let url = baseUri + "/favorito/is_favoritado/";
            //Checando se o produto esta favoritado ou não
            $.post(url, { produto_id: produto_id }).then((res) => {
                if (res == 1) {
                    this.remover_favorito(produto_id);
                } else if (res == 0) {
                    this.gravar_favorito(produto_id);
                }
            });
        },

        gravar_favorito: function (id) {
            let produto_id = id;
            let url = baseUri + "/favorito/gravar/";
            $.post(url, { produto_id: produto_id }).then((res) => {
                //console.log('GRAVAR');
                //console.log(res);
                $("#btn_remove_favorite_" + id + " i").removeClass(
                    "fa-heart-o"
                );
                $("#btn_remove_favorite_" + id + " i").addClass("fa-heart");
                alert_success(
                    "Ação realizada com sucesso",
                    "Produto foi adicionado a lista de desejos"
                );
                //Função em assets/js/main.js
                listarCarrinho();
            });
        },

        remover_favorito: function (id) {
            let produto_id = id;

            let url = baseUri + "/favorito/remover/";
            $.post(url, { produto_id: produto_id }).then((res) => {
                //console.log('REMOVER');
                //console.log(res);
                //Esse 1 se trata que dos status da requisição e não do status botão
                if (res == 1) {
                    $("#btn_remove_favorite_" + id + " i").removeClass(
                        "fa-heart"
                    );
                    $("#btn_remove_favorite_" + id + " i").addClass(
                        "fa-heart-o"
                    );
                    alert_success(
                        "Ação realizada com sucesso",
                        "Produto foi removido da lista de desejos"
                    );
                    //Função em assets/js/main.js
                    listarCarrinho();
                }
            });
        },
    },
    created: function () {},
});

// Start functions
$(document).ready(function () {
    $(".carousel").carousel();

    $("#slideVertical").owlCarousel({
        nav: true,
        dots: true,
        loop: true,
        margin: 15,
        item: 1,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 1,
            },
            1000: {
                items: 1,
            },
        },
    });

    $("#slideTop").owlCarousel({
        nav: true,
        dots: true,
        loop: true,
        margin: 15,
        item: 1,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 1,
            },
            1000: {
                items: 1,
            },
        },
    });

    let width = window.innerWidth;

    if (width < 799) {
        $("#produtosOferta, #produtosDestaques, #produtosNovos")
            .attr("class", "owl-carousel")
            .owlCarousel({
                nav: true,
                dots: true,
                loop: true,
                margin: 15,
                item: 1,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 1,
                    },
                    1000: {
                        items: 1,
                    },
                },
            });
    }

    if (window.location.href.indexOf("success") != -1) {
        alert_success("Ação realizada com sucesso!");
    }
});

// Functions
function showSearch() {
    $("#offcanvas-search").toggle("slow");
}

function showQuickView(id) {
    vm.getProduto(id);
}

function setProdutoInCarrinho(prod = null) {
    if (prod != null) {
        let produto = JSON.parse(prod);
        produto.produto_imagens = [
            {
                foto_produto_id: 0,
                foto_produto_img: produto.produto_foto,
            },
        ];
        let url = baseUri + "/carrinho/insereProdutoCarrinho";
        produto.qtd = 1;
        $.post(url, { produto: produto }).then((res) => {
            vmCarrinho.listarCarrinho();
            if (res.trim() == "1") {
                alert_success("Produto adicionado no carrinho!");
            } else if (res.trim() == "0") {
                alert_error("Erro ao adicionar produto no carrinho!", "CÓD: 0");
            } else if (res.trim() == "-1") {
                alert_warning("Produto indisponível");
            }
        });
    }
}
