<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
@(tema.loja.partials.og_tags)
    <!-- SEO --> 
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}"> 
    @(tema.loja.partials.css-padrao)
</head>
<body>
    <!-- SEO -->    
    @(tema.loja.partials.google_analytics)    
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)
    
    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>

<!-- Page Content-->
<div class="${config_site_layout_custom} pb-5 mb-sm-4">
    <div class="row pt-5">
        <div class="col-md-12 pt-sm-3 " id="divLogin">
            <div class="card custom_loja_fundo">
                <div class="card-body">
                    <h2 class="mb-1 custom_loja_texto font_smooth"><i class="fa fa-user"></i>&nbsp;&nbsp; Informe seus dados de contato</h2>

                    <form class="needs-validation mt-4" method="post" action="${baseUri}/ClienteFront/auth_orcamento">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label for="cliente_nome" class="custom_loja_texto">Nome <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" required name="cliente_nome" id="cliente_nome" placeholder="Informe seu nome">
                                </div>
                            </div>                            
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label for="cliente_email" class="custom_loja_texto">E-mail <span class="text-danger">*</span></label>
                                    <input class="form-control" type="email" required name="cliente_email" id="cliente_email" placeholder="Informe seu email">
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label for="cliente_celular" class="custom_loja_texto">Whatsapp/Celular <span class="text-danger">*</span></label>
                                    <input class="form-control celular" type="text" required name="cliente_celular" placeholder="Informe seu celular">
                                </div>
                            </div>
                        </div>

                        <hr class="mt-4">
                        <div class="text-center pt-4">
                            <button class="btn btn-primary" type="submit">Solicitar Orçamento</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

    @(tema.loja.partials.blog-insta)

    @(tema.loja.partials.toasts)

    @(tema.loja.partials.footer)    
    
    <!-- JavaScript (jQuery) libraries, plugins and custom scripts-->
    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>
    
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/validacoes.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="cliente/login.js?v=2"></script>
    <script type="text/javascript">
        $(".celular").mask("(99) 99999-9999");
    </script>
    
</body>

</html>