var vm = new Vue({
    el: "#vm",
    data: {
        cupom: null,
        cupom_desconto: 0,
        desconto_total: 0,
        frete: null,
        totalProdutos: null,
        totalCompra: null,
        totalCompraSemFormatacao: null,
        cardIsValid: false,
        loadingPage: true, // pode ser usado para uma splash screen
        validandoCartao: false,
        descontoBoleto: false,
        valorDescontoBoleto: null,
        totalBoleto: null,
        // selects e opções adicionais
        anos: [],
        campos_extras: null,
        produtos_carrinho: null,
        carrinho: null,
        valorFrete: null,
        totalDescontoFrete: null,
        totalSemDescontoFrete: null,
        descontoReal: 0,
        parcelas: 0,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.carrinho = res;
                    vm.produtos_carrinho = res.carrinho;
                } else {
                    vm.produtos_carrinho = null;
                }
            });
        },
        get_campos_extras: () => {
            let url = baseUri + "/CamposExtras/get_campos_extras";
            $.post(url).then((res) => {
                res = JSON.parse(res);

                if (res.status != undefined && res.status == 200) {
                    vm.campos_extras = res.campos;
                } else {
                    // Redirect para tela de carrinho, pois não tem nenhum item no carrinho
                }
            });
        },
        get_respostas_campos_extras: () => {
            if (vm.campos_extras != null) {
                let respostas = [];
                $(".campos_checkout").each((i, el) => {
                    let id = $(el).data("id");
                    let pergunta = $(el).data("pergunta");
                    let resposta = $(el).val();
                    if (resposta.trim() == "") {
                        alert_error(
                            "Responda todas as perguntas para prosseguir"
                        );
                        $(el).focus();
                        return false;
                    }
                    respostas.push({
                        campo_checkout_id: id,
                        pergunta: pergunta,
                        resposta: resposta,
                    });
                });

                return respostas;
            }
        },

        // -- verifica se existe um cupom com os valores digitados pelo usuário
        verifyCupom: () => {
            var self = this;
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            let url = baseUri + "/CupomFront/getCupom";
            $.post(url, { cupom: cupom }).then((res) => {
                res = JSON.parse(res);
                if (res.error == null) {
                    vm.cupom = res.cupom;
                    if (vm.cupom.cupom_desconto > 0) {
                        window.location.reload();
                    }
                } else {
                    $("#cupomValue")
                        .attr("placeholder", res.error)
                        .val("")
                        .attr("style", "border: 1px solid red");
                    setTimeout(() => {
                        window.location.reload();
                    }, 700);
                }
            });
        },
        // Verifica se existe um cupom já setado para aplicar desconto
        getCupom: () => {
            let url = baseUri + "/FreteFront/getValorCupom";
            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.cupom != undefined) {
                        vm.cupom = res.cupom;
                        $("#cupomValue").val(vm.cupom.cupom_alfa);
                    }
                }
            });
        },

        // --frete
        getFrete: () => {
            let url = baseUri + "/FreteFront/getValorFrete";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.frete != undefined) {
                        vm.frete = res.frete;
                        $(".valorFrete").html(
                            `${Number(vm.frete.price).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            })}`
                        );
                    }
                }
            });
        },

        goToFrete: () => {
            let url = baseUri + "/FreteFront/clearFrete";
            $.post(url).then((res) => {
                if (res.trim() == "1") {
                    window.location.href = baseUri + "/checkout";
                }
            });
        },

        paymentDeposito: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();
                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "deposito",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "deposito",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        inicializa: (reload = false) => {
            if (vm.frete == null) {
                vm.goToFrete();
            }
            vm.totalCompra = vm.carrinho.info.total_pix;
            vm.totalCompraSemFormatacao = vm.carrinho.info.total_pix;
            vm.totalCompras = Number(vm.totalCompra).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });

            vm.valorFrete = Number(vm.carrinho.info.frete);
            vm.totalBoleto = vm.carrinho.info.subtotal_desconto;
            vm.totalDescontoFrete = vm.carrinho.info.total_desconto_frete;
            vm.totalSemDescontoFrete =
                vm.carrinho.info.total_sem_desconto_frete;

            vm.totalProdutos = Number(vm.carrinho.info.total).toLocaleString(
                "pt-BR",
                {
                    style: "currency",
                    currency: "BRL",
                }
            );
            vm.descontoReal =
                vm.carrinho.info.total.replace(".", "").replace(",", ".") -
                vm.carrinho.info.subtotal_desconto
                    .replace(".", "")
                    .replace(",", ".");

            let descontoPix = Number(vm.descontoReal);
            vm.descontoReal = Number(vm.descontoReal).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
            vm.parcelas = vm.carrinho.info.parcelas;
            vm.cupom_desconto = Number(vm.carrinho.info.cupom.desconto);
            vm.cupom = vm.carrinho.info.cupom;

            vm.valorDescontoBoleto = Number($("#desconto_boleto").val());
            $("#transactionAmount").val(vm.carrinho.info.total);

            vm.desconto_total = vm.carrinho.info.desconto_total;

            vm.desconto_total = Number(vm.desconto_total).toLocaleString(
                "pt-BR",
                {
                    style: "currency",
                    currency: "BRL",
                }
            );
            //$(".updateCardTotal").on("click", function () {
            console.clear();
            console.log(vm.carrinho.info);
            let produtos = $(this).data("produtos");
            let total = $(this).data("total");
            let frete = $(this).data("frete");
            let desconto = $(this).data("desconto");

            let desconto_pix = (vm.descontoReal = Number(
                vm.carrinho.info.desconto_total
            ).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            }));

            let totalValor = (vm.carrinho.info.total_pix = Number(
                vm.carrinho.info.total_pix
            ).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            }));

            $(".valorTotal").text(totalValor);
            $(".valorFrete").text(frete);
            $(".valorCupom").text(desconto_pix);
            //$(".valorProduto").text();

            console.log("Produtos: " + produtos);
            console.log("Total: " + total);
            console.log("Frete: " + frete);
            console.log("Cupom: " + vm.carrinho.info.cupom.desconto);
            console.log("Desconto Pix: " + desconto);
            console.log("Desconto Total: " + vm.carrinho.info.desconto_total);
            //});

            if (!reload) {
                vm.loadingPage = false;
            }
        },
    },
    created: function () {
        this.get_campos_extras();
        this.get_produtos_carrinho();
        setTimeout(() => {
            this.getFrete();
            this.getCupom();
        }, 800);

        setTimeout(() => {
            $("#cep").mask("99999-999");
            $(".two-numbers").mask("99");
            $(".numbers").mask("999999");
            this.totalProdutos = vmCarrinho.total;
            this.totalCompra = vmCarrinho.total_desconto;
            this.inicializa();
        }, 1200);
    },
});
