function busca(busca) {
    if (busca.trim() != "") {
        $("#mobile-div-resultado-pesquisa").show("fade");
        let url = baseUri + "/ProdutosFront/busca";
        $.post(url, { busca: busca }).then((res) => {
            if (res != null) {
                let result = JSON.parse(res);
                if (result != null) {
                    populaResultadosBusca(result);
                } else {
                    $("#resultadosBusca").html(
                        "<h5>Nenhum resultado encontrado</h5>"
                    );
                }
            } else {
                $("#resultadosBusca").html(
                    "<h5>Nenhum resultado encontrado</h5>"
                );
            }
        });
    } else {
        // limpa os results
        $("#resultadosBusca").html("");
    }
}

function isObject(obj) {
    return obj !== undefined && obj !== null && obj.constructor == Object;
}

function isArray(obj) {
    return obj !== undefined && obj !== null && obj.constructor == Array;
}

function isBoolean(obj) {
    return obj !== undefined && obj !== null && obj.constructor == Boolean;
}

function isFunction(obj) {
    return obj !== undefined && obj !== null && obj.constructor == Function;
}

function isNumber(obj) {
    return obj !== undefined && obj !== null && obj.constructor == Number;
}

function isString(obj) {
    return obj !== undefined && obj !== null && obj.constructor == String;
}

function buscaDesk(busca) {
    if (busca.trim() != "") {
        $("#div-resultado-pesquisa").show("fade");
        let url = baseUri + "/ProdutosFront/busca";
        $.post(url, { busca: busca }).then((res) => {
            if (res != null) {
                let result = JSON.parse(res);
                if (result != null) {
                    populaResultadosBuscaDesk(result);
                } else {
                    $("#resultadosBuscaDesk").html(
                        "<h5>Nenhum resultado encontrado</h5>"
                    );
                }
            } else {
                $("#resultadosBuscaDesk").html(
                    "<h5>Nenhum resultado encontrado</h5>"
                );
            }
        });
    } else {
        // limpa os results
        $("#resultadosBuscaDesk").html("");
        $("#div-resultado-pesquisa").hide("fade");
    }
}

function populaResultadosBusca(results) {
    $("#resultadosBusca").html("");

    results.map((res) => {
        let _precoText;
        if (res.produto_estoque <= 0) {
            _precoText = "Indisponível";
        } else {
            if (res.produto_desconto > 0) {
                _precoText = `<span class="hide-on-vitrine" style="color: red !important; text-decoration: line-through;">R$ ${res.produto_preco_original}</span> R$ ${res.produto_preco}`;
            } else {
                _precoText = `<span class="hide-on-vitrine">R$ ${res.produto_preco}</span>`;
            }
        }
        let html = `
            <div class="media"><a class="featured-entry-thumb" href="${baseUri}/produto/${res.produto_url}"><img src="${baseUri}/media/produto/${res.produto_foto}" width="64" alt="Thumb produto"></a>
                <div class="media-body">
                    <h6 class="featured-entry-title"><a href="${baseUri}/produto/${res.produto_url}">${res.produto_titulo}</a></h6>`;

        //Caso o site for uma Loja padrão renderiza o preço também
        if (site_modo == 1) {
            html += `<p class="featured-entry-meta hide-on-vitrine">${_precoText}</p>`;
        }

        html += `</div>
            </div>`;
        $("#resultadosBusca").append(html);
    });
}

function populaResultadosBuscaDesk(results) {
    $("#resultadosBuscaDesk").html("");

    results.map((res) => {
        let _precoText;
        if (res.produto_estoque <= 0) {
            _precoText = "Indisponível";
        } else {
            if (res.produto_desconto > 0) {
                _precoText = `<span class="hide-on-vitrine" style="color: red !important; text-decoration: line-through;">R$ ${res.produto_preco_original}</span> R$ ${res.produto_preco}`;
            } else {
                _precoText = `<span class="hide-on-vitrine">R$ ${res.produto_preco}</span>`;
            }
        }
        let html = `
            <div class="media"><a class="featured-entry-thumb" href="${baseUri}/produto/${res.produto_url}"><img src="${baseUri}/media/produto/${res.produto_foto}" width="64" alt="Thumb produto"></a>
                <div class="media-body">
                    <h6 class="featured-entry-title"><a href="${baseUri}/produto/${res.produto_url}">${res.produto_titulo}</a></h6>`;

        //Caso o site for uma Loja padrão renderiza o preço também
        if (site_modo == 1) {
            html += `<p class="featured-entry-meta hide-on-vitrine">${_precoText}</p>`;
        }

        html += `</div>
            </div>`;
        $("#resultadosBuscaDesk").append(html);
    });
}

$("#campoBusca").keydown(function (e) {
    setTimeout(() => {
        if ($("#campoBusca").val().length >= 3) {
            busca($("#campoBusca").val());
        }
    }, 50);
});
$("#campoBuscaDesk").keydown(function (e) {
    // 13 = Enter
    if (e.which == 13) {
        if ($("#campoBuscaDesk").val().length >= 3) {
            window.location.href =
                baseUri +
                "/busca-termo/?busca=" +
                $.trim($("#campoBuscaDesk").val());
        }
    }
    setTimeout(() => {
        if ($("#campoBuscaDesk").val().length >= 3) {
            buscaDesk($("#campoBuscaDesk").val());
        }
    }, 50);
});

const position = "bottom-right";
function alert_success(title, msg) {
    $.toast({
        heading: title,
        text: msg,
        position: position,
        //loaderBg: '#ff6849',
        icon: "success",
        hideAfter: 3500,
        stack: 1,
    });
}

function alert_error(title, msg) {
    $.toast({
        heading: title,
        text: msg,
        position: position,
        //loaderBg: '#ff6849',
        icon: "error",
        hideAfter: 5500,
        stack: 1,
    });
}

function alert_warning(title, msg) {
    $.toast({
        heading: title,
        text: msg,
        position: position,
        bgColor: "#f57f17",
        // loaderBg: '#3D69FA',
        icon: "warning",
        hideAfter: 5500,
        stack: 1,
    });
}

function setMasks() {
    $(".cpf").mask("999.999.999-99");
    $(".cnpj").mask("99.999.999/9999-99");
    $(".celular").mask("(99) 99999-9999");
    $(".telefone").mask("(99) 9999-9999");
}

function logout() {
    let url = baseUri + "/ClienteFront/logout";

    $.get(url).then((res) => {
        window.location.href = baseUri;
    });
}

// lgpd - cookies
$(document).ready(function () {
    $("#div-resultado-pesquisa").hide();
    showCookie();
    let width = window.innerWidth;
    let qtdItens = 3;
    if (width < 799) {
        qtdItens = 2;
    }
    setTimeout(() => {
        setModoLoja();
        $("#menuSubDestaques").owlCarousel({
            nav: true,
            dots: false,
            item: qtdItens,
            responsive: {
                0: {
                    items: qtdItens,
                },
                768: {
                    items: qtdItens,
                },
                1000: {
                    items: qtdItens,
                },
            },
        });
    }, 450);

    $(".tips-top").tooltip({
        placement: "top",
    });
    listarFavoritos();
});

function showCookie() {
    if (!localStorage.getItem("cookiesAceitos")) {
        $(".divModalCookie").attr("style", "display: block").fadeIn("slow");
    }
}
$("#btnCookie").click(() => {
    localStorage.setItem("cookiesAceitos", "true");
    $(".divModalCookie").hide();
});

function listarFavoritos() {
    let url = baseUri + "/favorito/getQtdFavoritos";
    $.post(url).then((res) => {
        $("#qtdFavoritos").html(res);
    });
}

// Newsletter
$("#btnNewsletter").click(() => {
    let email = $("#newsletter_email").val().trim();
    if (email != "") {
        if (email.indexOf("@") != -1) {
            let split = email.split("@");
            if (split[0].trim() == "" || split[1].trim() == "") {
                alert_warning("Email inválido!");
            } else {
                let url = baseUri + "/Newsletter/gravar";
                $.post(url, { email: email }).then((res) => {
                    console.log(res);
                    if (res.trim() == "1") {
                        alert_success("Email cadastrado com sucesso!");
                        $("#newsletter_email").val("");
                    } else {
                        alert_warning(
                            "Não foi possível cadastrar este email!",
                            res.trim()
                        );
                    }
                });
            }
        } else {
            alert_warning("Email inválido!");
        }
    } else {
        alert_warning("Preencha o e-mail para poder se inscrever!");
    }
});

// SHOW OU HIDE CONFORME O MODO DE LOJA (VITRINE, ORÇAMENTO OU PADRÃO)
function setModoLoja() {
    switch (site_modo) {
        case "1":
            // Loja padrão
            $(".hide-on-loja").attr("style", "display: none !important");
            break;
        case "2":
            // Loja Orçamento
            $(".hide-on-orcamento").attr("style", "display: none !important");
            break;
        case "3":
            // Loja Vitrine
            $(".hide-on-vitrine").attr("style", "display: none !important");
            break;
        default:
            // Loja padrão
            $(".hide-on-loja").attr("style", "display: none !important");
            break;
    }
}
