 <!DOCTYPE html>
 <meta charset="UTF-8">
 <!--[if gte mso 9]><style>sup { font-size: 100% !important; }</style><![endif]-->
 <!--[if !mso]> -->
 <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700,700i" rel="stylesheet">
 <!--<![endif]-->

 <style type="text/css">
   #outlook a {
     padding: 0;
   }

   .ExternalClass {
     width: 100%;
   }

   .ExternalClass,
   .ExternalClass p,
   .ExternalClass span,
   .ExternalClass font,
   .ExternalClass td,
   .ExternalClass div {
     line-height: 100%;
   }

   .es-button {
     mso-style-priority: 100 !important;
     text-decoration: none !important;
   }

   a[x-apple-data-detectors] {
     color: inherit !important;
     text-decoration: none !important;
     font-size: inherit !important;
     font-family: inherit !important;
     font-weight: inherit !important;
     line-height: inherit !important;
   }

   .es-desk-hidden {
     display: none;
     float: left;
     overflow: hidden;
     width: 0;
     max-height: 0;
     line-height: 0;
     mso-hide: all;
   }

   @media only screen and (max-width:600px) {

     p,
     ul li,
     ol li,
     a {
       font-size: 16px !important;
       line-height: 150% !important
     }

     h1 {
       font-size: 32px !important;
       text-align: center;
       line-height: 120% !important
     }

     h2 {
       font-size: 26px !important;
       text-align: center;
       line-height: 120% !important
     }

     h3 {
       font-size: 20px !important;
       text-align: center;
       line-height: 120% !important
     }

     h1 a {
       font-size: 32px !important
     }

     h2 a {
       font-size: 26px !important
     }

     h3 a {
       font-size: 20px !important
     }

     .es-menu td a {
       font-size: 16px !important
     }

     .es-header-body p,
     .es-header-body ul li,
     .es-header-body ol li,
     .es-header-body a {
       font-size: 16px !important
     }

     .es-footer-body p,
     .es-footer-body ul li,
     .es-footer-body ol li,
     .es-footer-body a {
       font-size: 16px !important
     }

     .es-infoblock p,
     .es-infoblock ul li,
     .es-infoblock ol li,
     .es-infoblock a {
       font-size: 12px !important
     }

     *[class="gmail-fix"] {
       display: none !important
     }

     .es-m-txt-c,
     .es-m-txt-c h1,
     .es-m-txt-c h2,
     .es-m-txt-c h3 {
       text-align: center !important
     }

     .es-m-txt-r,
     .es-m-txt-r h1,
     .es-m-txt-r h2,
     .es-m-txt-r h3 {
       text-align: right !important
     }

     .es-m-txt-l,
     .es-m-txt-l h1,
     .es-m-txt-l h2,
     .es-m-txt-l h3 {
       text-align: left !important
     }

     .es-m-txt-r img,
     .es-m-txt-c img,
     .es-m-txt-l img {
       display: inline !important
     }

     .es-button-border {
       display: inline-block !important
     }

     a.es-button {
       font-size: 16px !important;
       display: inline-block !important;
       border-width: 15px 30px 15px 30px !important
     }

     .es-btn-fw {
       border-width: 10px 0px !important;
       text-align: center !important
     }

     .es-adaptive table,
     .es-btn-fw,
     .es-btn-fw-brdr,
     .es-left,
     .es-right {
       width: 100% !important
     }

     .es-content table,
     .es-header table,
     .es-footer table,
     .es-content,
     .es-footer,
     .es-header {
       width: 100% !important;
       max-width: 600px !important
     }

     .es-adapt-td {
       display: block !important;
       width: 100% !important
     }

     .adapt-img {
       width: 100% !important;
       height: auto !important
     }

     .es-m-p0 {
       padding: 0px !important
     }

     .es-m-p0r {
       padding-right: 0px !important
     }

     .es-m-p0l {
       padding-left: 0px !important
     }

     .es-m-p0t {
       padding-top: 0px !important
     }

     .es-m-p0b {
       padding-bottom: 0 !important
     }

     .es-m-p20b {
       padding-bottom: 20px !important
     }

     .es-mobile-hidden,
     .es-hidden {
       display: none !important
     }

     tr.es-desk-hidden,
     td.es-desk-hidden,
     table.es-desk-hidden {
       width: auto !important;
       overflow: visible !important;
       float: none !important;
       max-height: inherit !important;
       line-height: inherit !important
     }

     tr.es-desk-hidden {
       display: table-row !important
     }

     table.es-desk-hidden {
       display: table !important
     }

     td.es-desk-menu-hidden {
       display: table-cell !important
     }

     .es-menu td {
       width: 1% !important
     }

     table.es-table-not-adapt,
     .esd-block-html table {
       width: auto !important
     }

     table.es-social {
       display: inline-block !important
     }

     table.es-social td {
       display: inline-block !important
     }
   }
 </style>
 </head>

 <body style="width:100%;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0">
   <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top">
     <tr style="border-collapse:collapse">
       <td valign="top" style="padding:0;Margin:0">
         <table cellpadding="0" cellspacing="0" class="es-content" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
           <tr style="border-collapse:collapse">
             <td align="center" style="padding:0;Margin:0">
               <table class="es-content-body" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;width:700px" cellspacing="0" cellpadding="0" align="center">
                 <tr style="border-collapse:collapse">
                   <td align="left" style="Margin:0;padding-left:10px;padding-right:10px;padding-top:15px;padding-bottom:15px">
                     <!--[if mso]><table style="width:580px" cellpadding="0" cellspacing="0"><tr><td style="width:282px" valign="top"><![endif]-->
                     <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                       <tr style="border-collapse:collapse">
                         <td align="left" style="padding:0;Margin:0;width:282px">
                           <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">

                           </table>
                         </td>
                       </tr>
                     </table>
                     <!--[if mso]></td><td style="width:20px"></td><td style="width:278px" valign="top"><![endif]-->
                     <table class="es-right" cellspacing="0" cellpadding="0" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                       <tr style="border-collapse:collapse">
                         <td align="left" style="padding:0;Margin:0;width:278px">
                           <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">

                           </table>
                         </td>
                       </tr>
                     </table>
                     <!--[if mso]></td></tr></table><![endif]-->
                   </td>
                 </tr>
               </table>
             </td>
           </tr>
         </table>
         <table class="es-content" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
           <tr style="border-collapse:collapse"></tr>
           <tr style="border-collapse:collapse">
             <td align="center" style="padding:0;Margin:0">
               <table class="es-header-body" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:'${tema_color_bg}';width:700px" cellspacing="0" cellpadding="0" bgcolor="${tema_color_bg}" align="center">
                 <tr style="border-collapse:collapse">
                   <td align="left" style="Margin:0;padding-top:35px;padding-bottom:35px;padding-left:35px;padding-right:35px">
                     <!--[if mso]><table style="width:530px" cellpadding="0" cellspacing="0"><tr><td style="width:340px" valign="top"><![endif]-->
                     <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                       <tr style="border-collapse:collapse">
                         <td class="es-m-p0r es-m-p20b" valign="top" align="center" style="padding:0;Margin:0;width:450px">
                           <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                             <tr style="border-collapse:collapse">
                               <td class="es-m-txt-c" align="left" style="padding:0;Margin:0">
                                 <h1 style="Margin:0;line-height:36px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:29px;font-style:normal;font-weight:bold;color:#FFFFFF">Recebemos seu pedido nº ${pedido_id}</h1>
                               </td>
                             </tr>
                           </table>
                         </td>
                       </tr>
                     </table>
                     <!--[if mso]></td><td style="width:20px"></td><td style="width:170px" valign="top"><![endif]-->
                     <table cellspacing="0" cellpadding="0" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                       <tr class="es-hidden" style="border-collapse:collapse">
                         <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:170px">
                           <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                             <tr style="border-collapse:collapse">
                               <td style="padding:0;Margin:0">
                                 <table cellspacing="0" cellpadding="0" align="right" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                   <tr style="border-collapse:collapse">
                                     <td align="left" style="padding:0;Margin:0">
                                       <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">

                                       </table>
                                     </td>

                                   </tr>
                                 </table>
                               </td>
                             </tr>
                           </table>
                         </td>
                       </tr>
                     </table>
                     <!--[if mso]></td></tr></table><![endif]-->
                   </td>
                 </tr>
               </table>
             </td>
           </tr>
         </table>
         <table class="es-content" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
           <tr style="border-collapse:collapse">
             <td align="center" style="padding:0;Margin:0">
               <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                 <tr style="border-collapse:collapse">
                   <td style="Margin:0;padding-bottom:35px;padding-left:35px;padding-right:35px;padding-top:40px;background-color:#F7F7F7" bgcolor="#f7f7f7" align="left">
                     <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                       <tr style="border-collapse:collapse">
                         <td valign="top" align="center" style="padding:0;Margin:0;width:530px">
                           <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                             <tr style="border-collapse:collapse">
                               <td align="center" style="Margin:0;padding-top:20px;padding-bottom:25px;padding-left:35px;padding-right:35px;font-size:0"><a target="_blank" href="${baseUri}" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:15px;text-decoration:none;color:tema_color_bg"><img src="${baseUri}/media/site/${config_site_logo}" alt="${config_site_title}" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" title="logo" width="150"></a></td>
                             </tr>
                             <tr style="border-collapse:collapse">
                               <td align="left" style="padding:0;Margin:0;">
                                 <h2 style="Margin:0;line-height:36px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:26px;font-style:normal;font-weight:bold;color:#333333">Olá,</h2>
                                 <p>
                                   Obrigado por comprar na ${config_site_title}. Seu pedido está sendo processado e você será avisado quando os itens forem enviados.

                                 </p>
                               </td>
                             </tr>
                             <tr style="border-collapse:collapse">
                               <td class="es-m-txt-l" align="left" style="padding:0;Margin:0;padding-top:3px">
                                 <h3 style="Margin:0;line-height:22px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:18px;font-style:normal;font-weight:bold;color:#333333"><br></h3>
                               </td>
                             </tr>

                             <tr style="border-collapse:collapse">
                               <td class="es-m-txt-l" align="left" style="padding:0;Margin:0;padding-top:2px">
                                 <h3 style="Margin:0;line-height:22px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:18px;font-style:normal;font-weight:bold;color:#333333">Detalhes do pedido:<br></h3>
                               </td>
                             </tr>

                             <tr style="border-collapse:collapse">
                               <td align="left" style="padding:0;Margin:0;padding-bottom:0px;padding-top:15px">
                                 <table>
                                   <tr>
                                     <th width="700px" style="text-align: left;">Produto</th>
                                     <th width="80px" style="text-align: left;">Qtde</th>
                                     <th width="110px" style="text-align: left;">Preço</th>
                                     <th width="100px" style="text-align: left;">Total</th>
                                   </tr>
                                   <?php foreach ($data['pedido']->lista as $produto) : ?>
                                     <tr>
                                       <td>
                                         <?= $produto->lista_pedido_produto_titulo ?>
                                         <?php
                                          if (isset($produto->atributos) && !empty($produto->atributos)) : ?>
                                           <?php foreach ($produto->atributos as $att) : ?>
                                             <small>(<?php echo ($att->lista_pedido_atributo_itemnome);
                                                      $atts =  ($att->lista_pedido_atributo_valor_adicional > 0 ?  ' ('
                                                        . Math::moeda(Math::decimal($produto->lista_pedido_preco) - ($att->lista_pedido_atributo_valor_adicional))
                                                        . ' + ' . number_format($att->lista_pedido_atributo_valor_adicional, 2, ',', '.') . ' adicionais)' : '');
                                                      ''
                                                      ?>)
                                             </small>
                                           <?php endforeach; ?>

                                         <?php endif;   ?>
                                       </td>
                                       <td>
                                         <?= $produto->lista_pedido_qtde ?>
                                       </td>
                                       <td>
                                         R$ <?= $produto->lista_pedido_preco ?>
                                       </td>
                                       <td>
                                         R$ <?= Math::moeda(Math::decimal($produto->lista_pedido_preco) * $produto->lista_pedido_qtde) ?>
                                       </td>

                                     </tr>
                                   <?php endforeach ?>
                             </tr>
                           </table>
                         </td>
                       </tr>
                       <tr style="border-collapse:collapse">
                         <td align="right" style="padding:0;Margin:0;padding-bottom:10px;padding-top:15px">
                           <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;line-height:24px;">
                             <strong>Total em Produtos:</strong> R$ ${pedido_total_produto}<br>
                             <?php if ((isset($data['pedido']->pedido_cupom_desconto) && !empty($data['pedido']->pedido_cupom_desconto)) || (isset($data['pedido']->pedido_cupom_info) && !empty($data['pedido']->pedido_cupom_info))) : ?>
                               <br><strong>Descontos aplicados:</strong> - R$ <?= number_format($data['pedido']->pedido_desconto, 2, ',', '.') ?>
                               <br><?= $data['pedido']->pedido_cupom_info ?><br>
                             <?php endif ?>

                             <br>

                             <strong>Subtotal:</strong> R$
                             <?= Math::moeda(Math::decimal($data['pedido']->pedido_total_produto) - $data['pedido']->pedido_desconto) ?> <br>
                             <strong>Frete:</strong> R$ <?= Math::moeda($data['pedido']->pedido_frete) ?> <br><br>
                             <strong>Total da compra:</strong> R$ ${pedido_total_frete} <br>
                             <strong>Pagamento via:</strong> <?= ucfirst($data['pedido']->pedido_info) ?>
                           </p>
                         </td>
                       </tr>

                       <?php if (isset($data['pedido']->pedido_endereco_cliente)) : ?>
                         <tr style="border-collapse:collapse">
                           <td class="es-m-txt-l" align="left" style="padding:0;Margin:0;padding-top:13px">

                           </td>
                         </tr>
                         <tr style="border-collapse:collapse">
                           <td align="left" style="padding:0;Margin:0;padding-bottom:10px;padding-top:15px">
                             <h3 style="Margin:0;line-height:22px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:18px;font-style:normal;font-weight:bold;">Seu pedido será enviado para: </h3>
                             <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;line-height:24px;">
                               <?= $data['pedido']->pedido_endereco_cliente->endereco_cliente_rua ?>,
                               <?= $data['pedido']->pedido_endereco_cliente->endereco_cliente_num ?>,
                               <?= $data['pedido']->pedido_endereco_cliente->endereco_cliente_cidade ?>

                               <?= $data['pedido']->pedido_endereco_cliente->endereco_cliente_complemento ?>
                             </p>


                             <?php if ($data['pedido']->pedido_prazo > 0) : ?>
                               <br>
                               <strong>Opção de entrega: </strong> <?= $data['pedido']->pedido_servico_frete ?>
                               <br>
                               <?php
                                $datar = date('d/m/Y', strtotime(' +' . intval($data['pedido']->pedido_prazo) . ' days'));
                                ?>
                               <strong>Previsão de entrega: </strong> <?= $datar ?>
                             <?php endif; ?>
                           </td>
                         </tr>
                       <?php endif ?>

                       <?php if (isset($data['pedido']->retirada)) : ?>
                         <tr style="border-collapse:collapse">
                           <td class="es-m-txt-l" align="left" style="padding:0;Margin:0;padding-top:13px">
                             <h3 style="Margin:0;line-height:22px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:18px;font-style:normal;font-weight:bold;color:#333333">Retirar seu pedido no seguinte endereço: </h3>
                           </td>
                         </tr>
                         <tr style="border-collapse:collapse">
                           <td align="left" style="padding:0;Margin:0;padding-bottom:10px;padding-top:15px">
                             <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;line-height:24px;">
                               <?= $data['pedido']->retirada->retirada_rua ?>,
                               <?= $data['pedido']->retirada->retirada_num ?>,
                               <?= $data['pedido']->retirada->retirada_cidade ?>-<?= $data['pedido']->retirada->retirada_uf ?>
                               <br>
                               Telefone: <?= $data['pedido']->retirada->retirada_telefone ?>
                             </p>
                           </td>
                         </tr>
                       <?php endif ?>
                       <?php if (isset($data['cliente']->cliente_telefone) && !empty($data['cliente']->cliente_telefone)) : ?>
                         <tr style="border-collapse:collapse">
                           <td class="es-m-txt-l" align="left" style="padding:0;Margin:0;padding-top:13px">

                           </td>
                         </tr>
                         <tr style="border-collapse:collapse">
                           <td align="left" style="padding:0;Margin:0;padding-bottom:10px;padding-top:15px">
                             <h3 style="Margin:0;line-height:22px;mso-line-height-rule:exactly;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;font-size:18px;font-style:normal;font-weight:bold;color:#333333">Nossos contatos:<br></h3>
                             <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;line-height:24px;">
                               ${config_site_email} <br>
                               ${config_site_tel1} <br>
                               ${config_site_tel2} <br>
                             </p>
                           </td>
                         </tr>
                       <?php endif ?>

                       <?php if (isset($data['cliente']->cliente_celular) && !empty($data['cliente']->cliente_celular)) : ?>

                       <?php endif ?>
                       <tr style="border-collapse:collapse">
                         <td align="left" style="padding:0;Margin:0;padding-bottom:10px;padding-top:15px">
                           <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:'open sans', 'helvetica neue', helvetica, arial, sans-serif;line-height:24px;">Para ver todos os detalhes do seu pedido <a href="${baseUri}/pedido-detalhes/${pedido_id}">clique aqui</a></p>
                         </td>
                       </tr>

                     </table>
                   </td>
                 </tr>
               </table>
             </td>
           </tr>
         </table>
       </td>
     </tr>
   </table>
   </td>
   </tr>
   </table>
 </body>

 </html>