$(function () {
    populaSelect();
    ("use strict");

    let url = baseUri + "/relatorios/totalVendasByYear";
    let vendas = [];
    $.post(url, { ano: new Date().getUTCFullYear() }).then((res) => {
        res = JSON.parse(res);
        vendas = res;
        let series = [];
        let total = [];
        vendas.map((venda) => {
            series[venda.pedido_mes - 1] = Math.log10(venda.pedido_qtd);
        });
        for (let i = 0; i < 12; i++) {
            if (series[i] == undefined) series[i] = 0;
        }

        vendas.map((venda) => {
            total[venda.pedido_mes - 1] = Math.log10(venda.total);
        });
        for (let i = 0; i < 12; i++) {
            if (total[i] == undefined) total[i] = 0;
        }
        let final = [];
        final = [series, total];
        populaGrafico(final);
    });
});

function getVendasByYear() {
    let url = baseUri + "/relatorios/totalVendasByYear";
    let vendas = [];
    $.post(url, { ano: $("#vendasAno").val() }).then((res) => {
        res = JSON.parse(res);
        vendas = res;
        let series = [];
        let total = [];
        if (vendas) {
            vendas.map((venda) => {
                series[venda.pedido_mes - 1] = Math.log10(venda.pedido_qtd);
            });
            for (let i = 0; i < 12; i++) {
                if (series[i] == undefined) series[i] = 0;
            }

            vendas.map((venda) => {
                total[venda.pedido_mes - 1] = Math.log10(venda.total);
            });
            for (let i = 0; i < 12; i++) {
                if (total[i] == undefined) total[i] = 0;
            }
            let final = [];
            final = [series, total];
            populaGrafico(final);
        } else {
            populaGrafico([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
        }
    });
}

function populaSelect() {
    let url = baseUri + "/relatorios/getYears";
    $.post(url).then((res) => {
        res = JSON.parse(res);
        let anos = res;

        anos.map((ano) => {
            $("#vendasAno").append(`
                    <option value="${ano.pedido_ano}">${ano.pedido_ano}</option>
                `);
        });
    });
}

$("#vendasAno").change(() => getVendasByYear());

function populaGrafico(arr) {
    var chart2 = new Chartist.Bar(
        ".amp-pxl",
        {
            labels: [
                "Jan",
                "Fev",
                "Mar",
                "Abr",
                "Mai",
                "Jun",
                "Jul",
                "Ago",
                "Set",
                "Out",
                "Nov",
                "Dez",
            ],
            series: arr,
        },
        {
            //seriesBarDistance: 10,
            axisX: {
                // On the x-axis start means top and end means bottom
                // position: 'end',
                showGrid: false,
            },
            axisY: {
                labelInterpolationFnc: function (value) {
                    return Math.pow(10, value).toFixed(0); // Reverte o log para exibição dos rótulos
                },
                //position: "start",
                //scaleMinSpace: 20,
            },
            //onlyInteger: true,
            //scaleMinSpace: 20,
            //high: "3000",
            low: "0",
            plugins: [
                Chartist.plugins.tooltip({
                    transformTooltipTextFnc: function (value) {
                        // Reverte o log para o valor original
                        const originalValue = Math.pow(10, value);

                        if (originalValue > 200) {
                            // Formata como moeda BRL se for maior que 200
                            return new Intl.NumberFormat("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            }).format(originalValue);
                        } else {
                            // Exibe como inteiro com "pedidos X" para valores menores ou iguais a 200
                            return `pedidos ${Math.round(originalValue)}`;
                        }
                    },
                }),
            ],
        }
    );
}
