<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Produtos</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
    <style>
        td {
            vertical-align: middle !important;
        }

        .dataTables_filter {
            display: none;
        }

        #search {
            font-size: 18px;
            padding: 6px;
        }
    </style>
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Gerenciar Produtos</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Produtos</a></li>
                            <li class="breadcrumb-item active">Gerenciar Produtos</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <a id="novo-slide" data-id="ProdutosAdmin:G" class="btn btn-primary waves-effect waves-light text-white menu-access" href="${baseUri}/produto-novo/">
                                <i class="fa fa-plus-circle"></i> Novo
                                <span class="d-none d-xl-inline-block">Produto</span>
                            </a>

                            <a id="novo-slide" data-id="ProdutosAdmin:G" class="btn btn-success waves-effect waves-light text-white menu-access" href="${baseUri}/produtosAdmin/exportar_csv">
                                <i class="fa fa-file-excel"></i> Exportar CSV
                            </a>

                            <a id="novo-slide" data-id="ProdutosAdmin:G" class="btn btn-warning waves-effect waves-light text-white menu-access" data-toggle="modal" data-target="#modal-importar-csv">
                                <i class="fa fa-file-excel"></i> Importar CSV
                            </a>

                        </h6>
                    </div>
                </div>
                <!-- Start Page Content -->
                <div class="row" id="vm">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i></div>
                            <div class="card-body">
                                <div id="tbl-splash" class="spinner-border" style="width: 5rem; height: 5rem; margin-top: 5%; margin-left: 50%" role="status"></div>
                                <div id="tbl-div" class="table-responsive m-ts-40">
                                    <input type="text" id="search" name="null" class="form-control mt-2 mb-4 " placeholder="Pesquisar">
                                    <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th width="100">ID <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th width="80">Foto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th>Produto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th>Preço <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th>Estoque Min <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th>Estoque Atual <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                <th class="d-print-none"><i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i>Status</th>
                                                <th class="d-print-none text-right">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="post in posts" :class="'produto-editar-' + post.slide_id" :id="'produto-id-' + post.produto_id">
                                                <td>{{post.produto_id}}</td>
                                                <td>
                                                    <img :src="'${baseUri}/media/produto/'+ post.foto_produto_img" class="img-responsive" style="width: 70px; max-height: 90px">
                                                </td>
                                                <td>{{post.produto_titulo}}</td>
                                                <td>{{post.produto_preco_original}}</td>
                                                <td>{{post.produto_min_estoque}}</td>
                                                <td class="text-center">
                                                    <span v-if="post.produto_estoque_rel > 0"
                                                        data-toggle="tooltip" :title="post.produto_dt_estoque">
                                                        {{post.produto_estoque_rel}}
                                                    </span>
                                                    <span v-else data-toggle="tooltip" :title="post.produto_dt_estoque">
                                                        {{post.produto_estoque}}
                                                    </span>

                                                    <br> <small
                                                        v-if="(post.produto_estoque_rel != null && post.produto_estoque_rel < post.produto_min_estoque) || (post.produto_estoque < post.produto_min_estoque)" class="badge badge-warning">
                                                        &nbsp; <small>baixo</small>
                                                    </small>

                                                </td>
                                                <td class=" d-print-none text-center" width="80" :data-order="post.produto_status">
                                                    <span class="d-none">{{post.produto_status}}></span>
                                                    <a v-on:click="prepare_muda_status(post)" style="cursor: pointer" data-id="Produtos:G" data-toggle="tooltip" :title="post.produto_status_nome">
                                                        <span v-if="post.produto_status == 1"><i class="fa fa-2x fa-toggle-on text-primary"></i></span>
                                                        <span v-else><i class="fa fa-toggle-off fa-2x text-primary"></i></span>
                                                    </a>
                                                </td>
                                                <td class="d-print-none text-right" width="140">

                                                    <a class="btn btn-sm text-white btn-success waves-effect waves-light menu-acces" title="ver no site" data-toggle="tooltip" data-id="ProdutosAdmin:R" target="_blank" :href="'${baseUri}/produto/' + post.produto_url">
                                                        <i class="fas fa-eye"></i>
                                                    </a>

                                                    <a class="btn btn-sm text-white btn-primary waves-effect waves-light  menu-acces" title="editar" :target="(isBlank) ? '_blank' : '_self'" data-toggle="tooltip" data-id="ProdutosAdmin:G" :href="'${baseUri}/produto-editar/id/' + post.produto_id">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <?php if (ucfirst(Session::node('ulevel')) == '1') : ?>
                                                        <button class="btn btn-sm btn-danger menu-access" data-id="ProdutosAdmin:G" data-toggle="tooltip" title="remover" v-on:click="remover(post)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row " id="mob-tbl">
                                    <div class="row" v-if="posts == null">
                                        <div class="col-12 text-center">
                                            <label>Nenhum registro encontrado</label>
                                        </div>
                                    </div>
                                    <div v-for="post in posts" :class="'produto-editar-' + post.slide_id" :id="'produto-id-' + post.produto_id" v-else>
                                        <div class="col-12">
                                            <div class="row">
                                                <div class="col-10 align-self-center">
                                                    <h3>{{post.produto_titulo}}</h3>
                                                    <label>{{post.categoria_produto_nome}} - {{post.subcategoria_produto_nome}} </label>
                                                </div>
                                                <div class="col-2 align-self-start pt-0 mt-0 text-right">
                                                    <div class="row align-items-start">
                                                        <div class="col-12 align-self-start pb-4">
                                                            <div class="dropdown">
                                                                <button class="btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                    <a class="dropdown-item" data-id="ProdutosAdmin:G" :href="'${baseUri}/produto-editar/id/' + post.produto_id">
                                                                        <i class="fas fa-edit"></i>
                                                                        Editar</a>
                                                                    <a class="dropdown-item" v-on:click="remover(post)" data-id="Depoimento:G">
                                                                        <i class="fas fa-trash"></i>
                                                                        Excluir</a>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12 align-self-end">
                                                            <a v-on:click="prepare_muda_status(post)" style="cursor: pointer" data-id="Produtos:G" data-toggle="tooltip" :title="post.produto_status_nome">
                                                                <span v-if="post.produto_status == 1"><i class="fa fa-2x fa-toggle-on text-primary"></i></span>
                                                                <span v-else><i class="fa fa-toggle-off fa-2x text-primary"></i></span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <hr>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    @(admin.produto.modal-status)
                </div>
                <!-- End Page Content -->
            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
        <!-- Modal Remove -->
        @(admin.layout.modal-remove)
        @(admin.produto.modal-importa-csv)


    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js?v=1"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="produto/index.js?v=1"></script>
    <script type="text/javascript">
        $('.menu-produtos-gerenciar').addClass('active');
        $('.menu-produtos').addClass('active');
        $('#search').keyup(function() {
            if ($("#search").val() != "") {
                vm.isBlank = true;
            } else {
                vm.isBlank = false;
            }
            //var table = $('.table-meetups').DataTable();
            dtable.search($(this).val()).draw();
        });
    </script>
</body>

</html>