<?php

namespace PHPImager;

/*  
* $file = 'caminho/para/imagem.jpg'; // Substitua pelo caminho real do arquivo
*    $compression_quality = 80; // Nível de qualidade da compressão (0-100)
*    $result = webpConvert2($file, $compression_quality);
* if ($result !== false) {
*    echo "Imagem convertida com sucesso: $result";
* } else {
* }
 */

class Convert
{

    public function webpConvert2(string $file, int $compression_quality = 80): string|false
    {
        // Verifica se o arquivo existe
        if (!file_exists($file)) {
            return false;
        }

        // Obtém o tipo de arquivo
        $file_type = exif_imagetype($file);
        $output_file = $file . '.webp';

        // Retorna o arquivo convertido se ele já existir
        if (file_exists($output_file)) {
            return $output_file;
        }

        // Verifica se a função imagewebp existe
        if (function_exists('imagewebp')) {
            $image = match ($file_type) {
                IMAGETYPE_GIF => imagecreatefromgif($file),
                IMAGETYPE_JPEG => imagecreatefromjpeg($file),
                IMAGETYPE_PNG => imagecreatefrompng($file),
                IMAGETYPE_BMP => imagecreatefrombmp($file),
                IMAGETYPE_XBM => imagecreatefromxbm($file),
                IMAGETYPE_WEBP => false, // Não converte WEBP para WEBP
                default => false
            };

            if ($image === false) {
                return false;
            }

            // Ajusta a paleta de cores para PNG
            if ($file_type === IMAGETYPE_PNG) {
                imagepalettetotruecolor($image);
                imagealphablending($image, true);
                imagesavealpha($image, true);
            }

            // Salva a imagem em formato WEBP
            if (imagewebp($image, $output_file, $compression_quality) === false) {
                return false;
            }

            // Libera a memória
            imagedestroy($image);
            return $output_file;
        }

        // Verifica se a classe Imagick existe
        if (class_exists('Imagick')) {
            $image = new \Imagick();
            $image->readImage($file);

            // Ajusta para PNG com compressão lossless
            if ($file_type === IMAGETYPE_PNG) {
                $image->setImageFormat('webp');
                $image->setImageCompressionQuality($compression_quality);
                $image->setOption('webp:lossless', 'true');
            } else {
                $image->setImageFormat('webp');
                $image->setImageCompressionQuality($compression_quality);
            }

            $image->writeImage($output_file);
            return $output_file;
        }

        return false;
    }
}
