<?php

/**
 * Status das NF
 * 
 * 1: Aprovada
 * 2: Rejeitada
 * 3: Pendente(gerada mas não enviada pro SEFAZ)
 */

namespace Erp;

class BlingApi
{
    static function autorizacao_callback($integracao)
    {
        if (isset($_GET['code']) && !empty($_GET['code'])) {
            $api = [
                "grant_type" => "authorization_code",
                "code" => $_GET['code'],
            ];

            $base = base64_encode("$integracao->integracao_client_id:$integracao->integracao_secret");
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => "https://www.bling.com.br/Api/v3/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => http_build_query($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: 1.0",
                    "Content-Type: application/x-www-form-urlencoded",
                    "Authorization: Basic $base",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                return (object)['status' => -1, 'response' => $err];
            } else {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    return (object)['status' => 1, 'response' => $response];
                } else {
                    return (object)['status' => 0, 'response' => $response];
                }
            }
        }
    }

    static function atualizar_token($integracao)
    {
        $api = [
            "grant_type" => "refresh_token",
            "refresh_token" => $integracao->integracao_refresh_token,
        ];

        $base = base64_encode("$integracao->integracao_client_id:$integracao->integracao_secret");
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/oauth/token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Basic $base",
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        } else {
            $response = json_decode($response);
            if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                return (object)['status' => 1, 'response' => $response];
            } else {
                return (object)['status' => 0, 'response' => $response];
            }
        }
    }

    static function gerar_nfe($integracao, $data)
    {
        $api = self::get_fields(
            $integracao,
            $data['pedido'],
            $data['cliente'],
            $data['produtos']
        );
        //\Filter::pre($api);        exit;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/nfe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Bearer $integracao->integracao_token",
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        } else {
            $response = json_decode($response);
            if (isset($response->data) && isset($response->data->id) && !empty($response->data->id)) {
                return (object)['status' => 1, 'response' => $response->data];
            } else {
                return (object)['status' => 0, 'response' => $response];
            }
        }
    }

    static function enviar_nfe($integracao, $nfe_id)
    {
        $api = [
            'idNotaFiscal' => $nfe_id
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.bling.com.br/Api/v3/nfe/$nfe_id/enviar",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($api),
            CURLOPT_HTTPHEADER => [
                "Accept: 1.0",
                "Content-Type: application/x-www-form-urlencoded",
                "Authorization: Bearer $integracao->integracao_token",
            ],
        ]);
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        $response = json_decode($response);
        if ($err) {
            return (object)['status' => -1, 'response' => $err];
        }
        if (isset($response->data->xml) && !empty($response->data->xml)) {
            $xml = new \SimpleXMLElement($response->data->xml);
            if (isset($xml->protNFe->infProt) && isset($xml->protNFe->infProt->chNFe) && !empty($xml->protNFe->infProt->chNFe)) {
                //APROVADA
                if (isset($xml->protNFe->infProt->nProt)) {
                    return (object)['status' => 1, 'response' => $xml->protNFe->infProt];
                }
                //REJEITADA
                else {
                    return (object)['status' => 2, 'response' => $xml->protNFe->infProt];
                }
            } else {
                return (object)['status' => -2, 'response' => $xml];
            }
        } else {
            return (object)['status' => 0, 'response' => $response];
        }
    }


    static function get_nfe($integracao, $nfe_id)
    {
        $url = "https://www.bling.com.br/Api/v3/nfe/$nfe_id";
        $token = $integracao->integracao_token;
        $headers = [
            'accept: application/json',
            'Authorization: Bearer ' . $token,
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);
        $nfe = json_decode($response);
        return $nfe->data;
    }

    static function get_fields($integracao, $pedido, $cliente, $produtos)
    {
        $contato = self::get_contato($cliente, $pedido);
        $itens = self::get_itens($produtos);
        $data = [
            "tipo" => 1,
            //"numero" => "$pedido->pedido_id",
            "dataOperacao" => date('Y-m-d H:i:00'),
            "contato" => $contato,
            "finalidade" => 1,
            "observacoes" => "NF gerada pela loja virtual.",
            "itens" => $itens,
            //'desconto' => self::get_desconto($pedido)
            'desconto' => ($pedido->pedido_desconto > 0) ? $pedido->pedido_desconto : 0
        ];
        if (isset($integracao->integracao_rec4) && !empty($integracao->integracao_rec4)) {
            //204994900
            $lojaBlingID = intval($integracao->integracao_rec4);
            if ($lojaBlingID > 0) {
                $lojaBling = [
                    "id" => $lojaBlingID,
                    "numero" => "{$pedido->pedido_id}",
                ];
                $data['loja'] = $lojaBling;
            }
        }

        $natOP  = self::determine_nat_op($contato, $integracao);
        if ($natOP) {
            $data['naturezaOperacao'] = [
                "id" => $natOP
            ];
        }

        if ($pedido->pedido_entrega == 1) {
            $data['transporte'] = [
                "fretePorConta" => 0,
                "frete" => $pedido->pedido_frete,
            ];
        }
        return $data;
    }

    static function get_contato($cliente)
    {
        $contato = [
            "nome" => "$cliente->cliente_nome",
            "tipoPessoa" => ($cliente->cliente_tipo == 1) ? 'F' : 'J',
            "numeroDocumento" => ($cliente->cliente_tipo == 1) ? \Filter::parse_numeric($cliente->cliente_cpf) : \Filter::parse_numeric($cliente->cliente_cnpj),
            "rg" => "$cliente->cliente_rg",
            "telefone" => "$cliente->cliente_telefone",
            "email" => "$cliente->cliente_email",
        ];

        //Se dados de endereço da tabela do cliente tiver prenchido
        if (
            isset($cliente->cliente_cep) && !empty($cliente->cliente_cep) && isset($cliente->cliente_rua) && !empty($cliente->cliente_rua) &&
            isset($cliente->cliente_num) && !empty($cliente->cliente_num)
        ) {
            $contato['endereco'] = [
                "endereco" => "$cliente->cliente_rua",
                "numero" => "$cliente->cliente_num",
                "complemento" => "$cliente->cliente_complemento",
                "bairro" => "$cliente->cliente_bairro",
                "cep" => "$cliente->cliente_cep",
                "municipio" => $cliente->cliente_cidade,
                "uf" => $cliente->cliente_uf,
                "pais" => "",
            ];
        } //Caso contrario pega um endereço da tabela do cliente
        else if (isset($cliente->endereco_cliente_id) && !empty($cliente->endereco_cliente_id) && $cliente->endereco_cliente_id > 0) {
            $contato['endereco'] =
                [
                    "endereco" => "$cliente->endereco_cliente_rua",
                    "numero" => "$cliente->endereco_cliente_num",
                    "complemento" => "$cliente->endereco_cliente_complemento",
                    "bairro" => "$cliente->endereco_cliente_bairro",
                    "cep" => "$cliente->endereco_cliente_cep",
                    "municipio" => $cliente->endereco_cliente_cidade,
                    "uf" => $cliente->endereco_cliente_uf,
                    "pais" => "",
                ];
        }

        if ($cliente->cliente_tipo == 1) {
            $contato['contribuinte'] = 9;
        } else if ($cliente->cliente_tipo == 2) {

            if ($cliente->cliente_ie != "") {
                $contato['contribuinte'] = 1; // ou 2 para isento
                $contato['ie'] = "$cliente->cliente_ie";
            } else {
                $contato['contribuinte'] = 9;
                //$contato['ie'] = "$cliente->cliente_ie";          
            }
        }

        return $contato;
    }

    static function get_itens($produtos)
    {
        $itens = [];
        if (isset($produtos[0]) && !empty($produtos)) {
            foreach ($produtos as $produto) {
                $itens[] = [
                    //"codigo" => ($produto->produto_ref) ? "$produto->produto_ref" : "$produto->produto_id",
                    "codigo" => "$produto->produto_id",
                    "descricao" => $produto->produto_titulo,
                    "unidade" => $produto->produto_tipo_unidade,
                    "quantidade" => $produto->lista_pedido_qtde,
                    "valor" => \Math::money2Decimal($produto->lista_pedido_preco),
                    "tipo" => "P",
                    "pesoBruto" => $produto->produto_peso,
                    "pesoLiquido" => $produto->produto_peso,
                    "numeroPedidoCompra" => "$produto->lista_pedido_pedido",
                    "classificacaoFiscal" => "$produto->produto_class_fiscal", //NCM 
                    "origem" => 0,
                ];
            }
        }

        return $itens;
    }

    static function get_desconto($pedido)
    {
        //Calculando o desconto
        $total = floatval($pedido->pedido_total_produto) + floatval($pedido->pedido_frete);
        $desconto = $total - floatval($pedido->pedido_total_parcelado);
        $desconto = ($desconto > 0) ? $desconto : 0;
        $desconto = 0;
        return $desconto;
    }

    static public function determine_nat_op($contato, $integracao)
    {
        if (intval($integracao->integracao_rec6) > 0 && intval($integracao->integracao_rec7) > 0) {
            $uf = (isset($contato['endereco']['uf'])) ? $contato['endereco']['uf'] : "SP";
            if (strtoupper($integracao->integracao_rec5) == strtoupper($uf)) {
                //dentro do estado 
                return intval($integracao->integracao_rec6);
            } else {
                //fora do estado
                return intval($integracao->integracao_rec7);
            }
        } else {
            return false;
        }
    }


    //Operacao: 'B'alanco  - 'E'ntrada  - 'S'aida
    /**
     *   
     *  $id_produto_loja = 100;
        $produto_bling = BlingApi::get_produto_by_cod($id_produto_loja, $token);
        $id_produto_bling = $produto_bling->id;
        $estoque = BlingApi::get_estoque_by_cod($id_produto_loja, $token);
        BlingApi::set_estoque_by_deposito_produto($estoque->deposito, $estoque->id_produto, 100, 'B', $token);
     */
    static public function set_estoque_by_deposito_produto($deposito, $produto, $qtde, $operacao, $token)
    {
        $data = [
            "produto" => [
                "id" => $produto
            ],
            "deposito" => [
                "id" => $deposito
            ],
            "operacao" => "$operacao",
            "preco" => 0,
            "custo" => 0,
            "quantidade" => $qtde,
            "observacoes" => ""
        ];
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://bling.com.br/Api/v3/estoques',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'accept: application/json',
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ],
        ]);

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    /**
     *   
     *  $id_produto_loja = 100;
        $produto_bling = BlingApi::get_produto_by_cod($id_produto_loja, $token);
        $id_produto_bling = $produto_bling->id;
        $estoque = BlingApi::get_estoque_by_cod($id_produto_loja, $token);
     */
    static public function get_estoque_by_cod($id_loja, $token)
    {
        $url = 'https://bling.com.br/Api/v3/estoques/saldos';
        $params = [
            'codigos' => [$id_loja],
            //'idsProdutos' => '',
        ];
        $headers = [
            'accept: application/json',
            'Authorization: Bearer ' . $token,
        ];
        $url = $url . '?' . http_build_query($params, "", "&", PHP_QUERY_RFC3986);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if ($response === false) {
            $data = (object) [
                'status' => 0,
                'msg' => curl_error($ch)
            ];
            return  $data;
        }
        curl_close($ch);
        $estoque = json_decode($response);
        if (isset($estoque->data[0])) {
            $estoque = $estoque->data[0];
            if (isset($estoque->produto)) {
                $id_produto_bling = $estoque->produto->id;
                $saldo  = $estoque->saldoFisicoTotal;
                $deposito = 0;
                if (isset($estoque->depositos[0])) {
                    $deposito = $estoque->depositos[0]->id;
                }
                $data = (object) [
                    'status' => 1,
                    'id_produto' => $id_produto_bling,
                    'deposito' => $deposito,
                    'estoque' => $saldo
                ];
            } else {
                $data = (object) [
                    'status' => 0,
                    'msg' => $response
                ];
            }
            return $data;
        } else {
            $data = (object) [
                'status' => 0,
                'msg' => $response
            ];
            return  $data;
        }
    }

    /**
     *   
     *  $id_produto_loja = 100;
        $produto_bling = BlingApi::get_produto_by_cod($id_produto_loja, $token);
        $id_produto_bling = $produto_bling->id;
        $produto_bling  = BlingApi::get_produto_by_id($id_produto_bling, $token);
     */
    static public function get_produto_by_id($id, $token)
    {
        $url = 'https://bling.com.br/Api/v3/produtos/' . $id;
        $headers = [
            'accept: application/json',
            'Authorization: Bearer ' . $token,
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);
        $produto = json_decode($response);
        if (isset($produto->data)) {
            return $produto->data;
        } else {
        }
    }


    /**
     *   
     *  $id_produto_loja = 100;
        $produto_bling = BlingApi::get_produto_by_cod($id_produto_loja, $token);
     */
    static public function get_produto_by_cod($id_loja, $token)
    {
        $url = 'https://bling.com.br/Api/v3/produtos';
        $params = [
            'pagina' => 1,
            'limite' => 100,
            'codigo' => "$id_loja",
            //'nome' => '',
        ];
        $headers = [
            'accept: application/json',
            'Authorization: Bearer ' . $token,
        ];

        $url = $url . '?' . http_build_query($params, "", "&", PHP_QUERY_RFC3986);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);
        $produto = json_decode($response);
        if (isset($produto->data[0])) {
            return $produto->data[0];
        } else {
        }
    }




    /**
     *   
     *  $id_produto_loja = 100;
     *  $produto = BlingApi::get_produto_by_cod($id_produto_loja, $token); 
     *  BlingApi::sync_produto($produto, $token);
     */

    static public function sync_produto($produto, $token)
    {
        $pid = $produto->id;
        $url = "https://bling.com.br/Api/v3/produtos/{$pid}";
        $ch = curl_init($url);
        $options = [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token
            ],
            CURLOPT_POSTFIELDS => json_encode($produto)
        ];
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Erro ao enviar requisição: ' . curl_error($ch);
        }
        curl_close($ch);
        return $response;
    }

    /**
     *   
     *  $id_produto_loja = 100;
     *  $produto = get_produto_loja($id_produto_loja); 
     *  BlingApi::add_produto($produto, $token);
     */

    static public function add_produto($produto, $token)
    {
        $url = "https://bling.com.br/Api/v3/produtos";
        $ch = curl_init($url);
        $options = [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token
            ],
            CURLOPT_POSTFIELDS => json_encode($produto)
        ];
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Erro ao enviar requisição: ' . curl_error($ch);
        }
        curl_close($ch);
        return $response;
    }


    static public function empresa($token)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://bling.com.br/Api/v3/empresas/me/dados-basicos');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ]);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);

        $data = [];
        $response = json_decode($response);
        if (isset($response->data)) {
            $data = ['data' => $response->data];
        }
        if (isset($response->error)) {
            $data = ['error' => $response->error];
        }
        return (object) $data;
    }

    static public function natop($token)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://bling.com.br/Api/v3/naturezas-operacoes');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ]);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);
        $data = [];
        $response = json_decode($response);
        if (isset($response->data)) {
            $data = ['data' => $response->data];
        }
        if (isset($response->error)) {
            $data = ['error' => $response->error];
        }
        return (object) $data;
    }


    static public function pedidos($token, $dataInicial = null, $dataFinal = null)
    {
        if ($dataInicial == null) {
            $dataInicial = date('Y-m-d');
        }
        if ($dataFinal == null) {
            $dataFinal = date('Y-m-d');
        }
        $params = [
            //'pagina' => 1,
            //'limite' => 2,
            'idsSituacoes' => [9],
            'dataInicial' => "$dataInicial",
            'dataFinal' => "$dataFinal",
            //'codigo' => "$id_loja",
        ];
        $url = 'https://bling.com.br/Api/v3/pedidos/vendas';
        $url = $url . '?' . http_build_query($params, "", "&", PHP_QUERY_RFC3986);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ]);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);

        $data = [];
        $response = json_decode($response);
        if (isset($response->data)) {
            $data = ['data' => $response->data];
        }
        if (isset($response->error)) {
            $data = ['error' => $response->error];
        }
        return (object) $data;
    }

    static public function pedido($token, $id)
    {
        $url = "https://bling.com.br/Api/v3/pedidos/vendas/{$id}";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ]);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'cURL Error: ' . curl_error($ch);
        }
        curl_close($ch);

        $data = [];
        $response = json_decode($response);
        if (isset($response->data)) {
            $data = ['data' => $response->data];
        }
        if (isset($response->error)) {
            $data = ['error' => $response->error];
        }
        return (object) $data;
    }
}
