<?php

// Controller usado para setar temas configurados pelo Painel Admin
class Tema
{
    public $styleLayout = "";

    public function __construct() {}

    public function indexAction()
    {
        (new Install)->card_product_create();
    }

    public function layout()
    {
        $config = (new Factory('config'))
            ->select("config_site_layout, config_slide_comum_config, config_slide_multiplo_config")
            ->find(1);
        if (isset($config->config_site_layout)) {
            $layout = intval($config->config_site_layout);
            switch ($layout) {
                case 1:
                    // Layout Full
                    $this->getLayoutFull();
                    break;
                case 2:
                    // Layout Boxed
                    $this->getLayoutBoxed();
                    break;
                default:
                    // Layout Full
                    $this->getLayoutFull();
                    break;
            }
            // Faltando setar as cores
            $this->getColors();
            // seta as configurações de slides
            $styleSlides = "
                @media screen and (min-width: 799px) {
                    .multiplos-config {
                        width: 100% !important;
                        $config->config_slide_multiplo_config
                    }
                    .slide-config {
                        width: 100% !important;
                        $config->config_slide_comum_config
                    }
                }
            ";
            $this->styleLayout .= $styleSlides;
            $this->render();
        }
    }

    public function getLayoutFull()
    {
        $style = "
            .menu-direito-nav {
                margin-right: 45px !important;
            }

            .force-height-400 {
                min-height: 45vh !important;
            }

        ";

        $this->styleLayout .= $style;
    }

    public function getLayoutBoxed() {}

    public function getColors()
    {
        $cores = (new Factory('config_cores'))->get();
        $card = (new Factory('config_card'))->find(1);
        $thumb_height = ($card->config_card_img_height > 0) ?  $card->config_card_img_height . 'px !important;' : 'auto; min-height:100px !important; max-height:295px !important;';
        $thumb_card_h = ($card->config_card_img_height > 100) ? $card->config_card_img_height : 300;
        $style = "
@import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Quattrocento+Sans:ital,wght@0,400;0,700;1,400;1,700&family=SUSE:wght@100..800&display=swap');

            body, .navbar { background-color: {$cores[3]->config_cores_fundo} !important;           
            font-family:'Montserrat', system-ui;
            font-weight: 400 !important;
            font-style: normal;
            }

            .custom_topo_fundo { background-color: {$cores[0]->config_cores_fundo} !important; }
            .custom_topo_texto { color: {$cores[0]->config_cores_texto} !important; }
            .custom_topo_texto:hover { color: {$cores[0]->config_cores_hover_texto} !important; }

            .custom_menu_fundo{min-width:180px}
            .custom_menu_fundo, .navbar-expand-lg.navbar-light .navbar-nav .dropdown:hover .nav-link { background-color: {$cores[1]->config_cores_fundo} !important; border: 1px solid transparent !important; }
            .custom_menu_texto { color: {$cores[1]->config_cores_texto} !important;
            font-size: {$cores[1]->config_cores_size}px !important; }
            .custom_menu_texto_no_hover { color: {$cores[1]->config_cores_texto} !important; }
            .custom_menu_texto_border {border-bottom: 1px solid {$cores[1]->config_cores_texto} !important;}
            .custom_menu_texto:hover { color: {$cores[1]->config_cores_hover_texto} !important; }

            .custom_color{ color: {$cores[1]->config_cores_texto} !important; }
            .custom_color_hover{color: {$cores[1]->config_cores_hover_texto} !important;}

            .custom_loja_fundo, body { background-color: {$cores[2]->config_cores_fundo} !important; }
            .custom_loja_texto { color: {$cores[2]->config_cores_texto} !important; font-weight: 400 !important; }

            .custom_redesSociais_fundo { background-color: {$cores[3]->config_cores_fundo} !important; border: 1px solid transparent !important;}
            .custom_redesSociais_texto { color: {$cores[3]->config_cores_texto} !important; }
            .custom_redesSociais_texto:hover { color: {$cores[3]->config_cores_texto} !important; }

            .custom_rodapeInformacoes_fundo { background-color: {$cores[4]->config_cores_fundo} !important; border: 1px solid transparent !important}
            .custom_rodapeInformacoes_texto { color: {$cores[4]->config_cores_texto} !important; }
            .custom_rodapeInformacoes_texto_no_hover { color: {$cores[4]->config_cores_texto} !important; }
            .custom_rodapeInformacoes_texto:hover { color: {$cores[4]->config_cores_hover_texto} !important; }

            .custom_rodape_fundo { background-color: {$cores[5]->config_cores_fundo} !important; }
            .custom_rodape_texto { color: {$cores[5]->config_cores_texto} !important; }

            .custom_botoesPrincipais_fundo { background-color: {$cores[6]->config_cores_fundo} !important; }
            .custom_botoesPrincipais_texto { color: {$cores[6]->config_cores_texto} !important; }

            .custom_botoesSucesso_fundo { background-color: {$cores[7]->config_cores_fundo} !important; }
            .custom_botoesSucesso_texto { color: {$cores[7]->config_cores_texto} !important; }

            .nav-tabs .nav-link.active { border-color: {$cores[6]->config_cores_texto} !important; }

            .btn-canvas {
                    color: {$cores[1]->config_cores_texto} !important;
            }
            .custom-control-label::before {
                border: 1px solid #555 !important;
            }

            .btn-primary, .bg-primary {
                background-color: {$cores[6]->config_cores_fundo} !important;
                border: 1px solid {$cores[6]->config_cores_fundo} !important;
                color: {$cores[6]->config_cores_texto} !important;
            }

            .btn-primary:hover {
                background-color: {$cores[6]->config_cores_hover_fundo} !important;
                border: 1px solid {$cores[6]->config_cores_hover_fundo} !important;
                color: {$cores[6]->config_cores_hover_texto} !important;
            }

            .btn-outline-primary {
                background-color: transparent !important;
                border: 1px solid {$cores[6]->config_cores_fundo} !important;
                color: {$cores[6]->config_cores_fundo} !important;
            }

            .btn-outline-primary:hover {
                background-color: {$cores[6]->config_cores_fundo} !important;
                border: 1px solid {$cores[6]->config_cores_fundo} !important;
                color: {$cores[6]->config_cores_texto} !important;
            }

            .btn-info {
                background-color: {$cores[7]->config_cores_fundo} !important;
                border: 1px solid {$cores[7]->config_cores_fundo} !important;
                color: {$cores[7]->config_cores_texto} !important;
            }

            .btn-info:hover {
                background-color: {$cores[7]->config_cores_hover_fundo} !important;
                border: 1px solid {$cores[7]->config_cores_hover_fundo} !important;
                color: {$cores[7]->config_cores_hover_texto} !important;
            }

            .owl-carousel .owl-dots .owl-dot {background-color: {$cores[6]->config_cores_fundo} !important;}

            .loader span {
                background-color: {$cores[2]->config_cores_texto} !important;
            }
            .loader-div {
                background-color: {$cores[2]->config_cores_fundo} !important;
            }

            .product-card {
				position: relative;
				padding: {$card->config_card_padding}px !important;
				background-color: {$card->config_card_bg_color} !important;
				border-width: {$card->config_card_border_size} !important;
				border-color: {$card->config_card_border_color} !important;
				border-style: solid;
				color: {$card->config_card_text_pri_color} !important;
				font-size: {$card->config_card_text_pri_size}px !important;
				/*text-align: {$card->config_card_text_pri_align} !important;*/
                line-height: normal !important;
                margin-bottom: 50px !important;
            }
            .product-card .product-card-body {
				height: {$card->config_card_desc_elm_height}px !important;
				padding: {$card->config_card_body_padding}px !important;
            }
                                
            .product-card:hover {
                border-width: {$card->config_card_border_size} !important;
                border-color: {$card->config_card_border_color_hover} !important;
                border-style: solid;
                -webkit-transition: all 0.4s ease-in-out;
                -moz-transition: all 0.4s ease-in-out;
                -o-transition: all 0.4s ease-in-out;
                -ms-transition: all 0.4s ease-in-out;
                transition: all 0.4s ease-in-out;
                /*box-shadow:0 0 0 0px {$card->config_card_border_color_hover} inset;*/
                
				-webkit-box-shadow: 0 0.35rem 0.75rem 0.0325rem #666 !important;
				box-shadow: 0 0.35rem 0.75rem 0.0325rem #666 !important;

            }



            .product-card .btn-primary{
                background-color: {$cores[6]->config_cores_hover_fundo} !important;
                border: 1px solid {$cores[6]->config_cores_hover_fundo} !important;
                color: {$cores[6]->config_cores_hover_texto} !important;
            }

            .product-card:hover .btn-primary {
                background-color: {$cores[6]->config_cores_fundo} !important;
                border: 1px solid {$cores[6]->config_cores_fundo} !important;
                color: {$cores[6]->config_cores_texto} !important;
            }   


            .product-title {
				color: {$card->config_card_text_pri_color} !important;
				font-size: {$card->config_card_text_pri_size}px !important;
				text-align: {$card->config_card_text_pri_align} !important;
				font-weight: {$card->config_card_text_pri_bold} !important;
				line-height: normal !important;
				display: block;
            }
            .product-title-indisponivel{
				color: {$card->config_card_text_sec_color} !important;
				font-size: {$card->config_card_text_pri_size} !important;
				text-align: {$card->config_card_text_pri_align} !important;
				line-height: normal !important;
            }

            .product-card .product-thumb badge{
                position:absolute;
            }
            .product-card .product-thumb {
            align-content: center;
         	   height: {$thumb_card_h}px !important;
               padding-top:0px;
               padding-bottom:0px;
            }
            .product-card .product-thumb img {
				width: $card->config_card_img_width !important;
				height:  $thumb_height !important;
				/*object-fit: cover;*/
				max-width: 100%;
				-moz-transition: all 0.3s;
				-webkit-transition: all 0.3s;
				transition: all 0.3s;
            }
			.product-card .product-thumb .foto-hover{
                  height:  $thumb_height !important;
				visibility: hidden;
				opacity: 0;
				position:absolute;
				top:0;
				left:0;
                background-color: white;
				width: 100%;
            }
            .product-card .product-thumb:hover .foto-hover{
				visibility: visible;
				opacity: 1;
            }
            .product-card .product-card-body {
				height: {$card->config_card_desc_elm_height}px !important;
				padding: {$card->config_card_body_padding}px !important;
            }
            .product-card .product-card-text-price {
				font-size: {$card->config_card_text_price_size}px !important;
				color: {$card->config_card_text_price_color} !important;
				text-align: {$card->config_card_text_price_align} !important;
				font-weight: {$card->config_card_text_price_bold} !important;
				display: block;
            }

            .product-card .product-card-disc {
				color: {$card->config_card_text_desconto_color} !important;
				font-size: {$card->config_card_text_desconto_size}px !important;
				text-align: {$card->config_card_text_desconto_align} !important;
				font-weight: {$card->config_card_text_desconto_bold} !important;
				display: block;
            }
            .product-card .product-card-percent {
				color: {$card->config_card_text_percent_color} !important;
				font-size: {$card->config_card_text_percent_size}px !important;
				text-align: {$card->config_card_text_percent_align} !important;
				font-weight: {$card->config_card_text_percent_bold} !important;
				display: block;
            }
            .product-card .product-card-parc {
				font-size: {$card->config_card_text_parc_size}px !important;
				color: {$card->config_card_text_parc_color} !important;
				text-align: {$card->config_card_text_parc_align} !important;
				font-weight: {$card->config_card_text_parc_bold} !important;
				display: block;
            }
            .product-card-parc-color{
				color: {$card->config_card_text_parc_color} !important;
            }

            /*
            .product-card button {
				color: {$card->config_card_btn_text_color} !important;
				background-color: {$card->config_card_btn_bg_color} !important;
            }
            .product-card button:hover {
				color: {$card->config_card_btn_text_color_hover} !important;
				background-color: {$card->config_card_btn_bg_color_hover} !important;
            }
            .product-card .btn-primary, .product-card .bg-primary {
                background-color: {$card->config_card_btn_bg_color} !important;
                border: 1px solid {$card->config_card_btn_text_color} !important;
                color: {$card->config_card_btn_text_color} !important;
            }
            .product-card .btn-primary:hover {
                color: {$card->config_card_btn_text_color_hover} !important;
                border: 1px solid {$card->config_card_btn_text_color_hover} !important;
                background-color: {$card->config_card_btn_bg_color_hover} !important;
            }
            */

            .product-card-text-line{
                display: block;
                text-decoration: line-through;
                color: {$card->config_card_text_line_color} !important;
                font-size: {$card->config_card_text_line_size}px !important;
                font-weight: {$card->config_card_text_line_bold} !important;
                text-align: $card->config_card_text_line_align !important;
            }
            .product-card-btns{
                position: relative;
                padding-bottom: 5px;
                text-align: right;
            }
            .product-card .product-card-btns a{
            /*padding:6px 12px;*/
            visibility: hidden;
            opacity: 0;
            right:0;
            text-align: center;
            }
            .product-card:hover .product-card-btns a{
            visibility: visible;
            opacity: 1;
            }
            .oferta{background-color: {$card->config_card_tooltip_bg_color}  !important; color:  {$card->config_card_tooltip_text_color} ;}
            .tooltip-inner {
                max-width: 200px;
                padding: 3px 8px;
                color:  {$card->config_card_tooltip_text_color} !important;
                text-align: center;
                text-decoration: none;
                background-color: {$card->config_card_tooltip_bg_color}  !important;
                -webkit-border-radius: 4px;
                -moz-border-radius: 4px;
                border-radius: 4px;
            }
            .tooltip .arrow {
                border-top-color: {$card->config_card_tooltip_bg_color}  !important;
                position: absolute;
                display: block;
                width: 0.8rem;
                height: 0.4rem;
            }
            .bs-tooltip-auto[x-placement^=bottom] .arrow::before, .bs-tooltip-bottom .arrow::before {
                border-bottom-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=top] .arrow::before, .bs-tooltip-top .arrow::before {
                border-top-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=left] .arrow::before, .bs-tooltip-left .arrow::before {
                border-left-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=right] .arrow::before, .bs-tooltip-right .arrow::before {
                border-right-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .tooltip .arrow::before {
                position: absolute;
                content: '';
                border-color: transparent;
                border-style: solid;
            }
            .shadow-custom {
                -webkit-box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                -moz-box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                margin-bottom: 0.36rem !important;
            }

            .menu-lateral-categoria > a{ color: {$cores[1]->config_cores_texto} !important; font-weight:500 !important; }
            .menu-lateral-categoria > a:hover{color: {$cores[1]->config_cores_hover_texto} !important; font-weight:500 !important;}	
            .navbar-btn {width: 95px !important;font-weight: 100 !important;font-size: 12px !important; }
            .btn-canvas {width: 40px !important;text-align: center !important;}
    	    .btn-canvas small {font-size: 8px !important;}
	    .nav-link-inline {font-weight: 400 !important;}
        ";
        $this->styleLayout .= $style;
    }

    public function render()
    {
        @header("Content-type: text/css");
        echo preg_replace('/\s+/', ' ', $this->styleLayout);
    }
}
