<?php

class Slide
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $config = (new Config)->get();
        $config_slide_comum_config = explode(";", $config->config_slide_comum_config);
        $config_slide_multiplo_config = explode(";", $config->config_slide_multiplo_config);

        $data = [
            'config' => $config,
            'slide_comum_config' => $config_slide_comum_config,
            'slide_multiplo_config' => $config_slide_multiplo_config,
            'mapper' => ['config']
        ];
        Tpl::view('admin.slide.index', $data, 1);
    }

    public function lista()
    {
        (new Factory('slide'))
            ->select("
                slide_id, slide_url, slide_img, 
                IF(slide_status = 1, 'Ativo', 'Inativo') AS slide_status_nome, 
                CASE slide_tipo 
                WHEN '1' THEN 'Slide 1' 
                WHEN '2' THEN 'Slide 2' 
                WHEN '3' THEN 'Slide Vertical' 
                WHEN '4' THEN 'Banner Full' 
                WHEN '5' THEN 'Banner Boxed' 
                WHEN '6' THEN 'Banner Fino Full' 
                WHEN '7' THEN 'Banner Fino Boxed' 
                WHEN '8' THEN 'Banner Múltiplo Full (Indicado 3 fotos)' 
                WHEN '9' THEN 'Banner Múltiplo Boxed (Indicado 3 fotos)' 
                END AS slide_tipo, 
                slide_status, slide_pos")
            ->order('slide_pos ASC')
            ->get(1);
    }
    public function gravar()
    {
        Sessao::perms('G');
        if (!intval($_POST['slide_id']) > 0 && intval($_FILES['slide_img']['error']) > 0) {
            Http::redirect_to("/slide/?error");
        }
        $media = Media::img_upload($_FILES['slide_img'], 'slides');
        if (isset($media->url)) {
            $ds = DIRECTORY_SEPARATOR;
            $path = Path::base() . $ds . 'media' . $ds . 'slides' . $ds . $_POST['slide_img'];
            if (is_file($path)) {
                //@system("chmod -R 777 $path");
                @unlink($path);
            }
            $_POST['slide_img'] = $media->url;
        } else {
            unset($_POST['slide_img']);
        }
        $slide = (new Factory('slide'))->with($_POST)->format(['slide_url' => 'text'])->save();
        $slide > 0 ? Http::redirect_to("/slide/?success") : Http::redirect_to("/slide/?error");
    }


    public function altera_status()
    {
        Sessao::perms('G', 1);
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $status = intval($_POST['slide_status']);
            $status == 1 ? $status = 0 : $status = 1;
            $data = [
                'id' => $id,
                'slide_status' => $status
            ];
            (new Factory('slide'))->with($data)->save();            
        }
    }

    public function novo()
    {
        $depoimento = (new Factory('slide'))->map();
        $data = [
            'slide' => $depoimento,
            
            'config' => (new Config)->get(),
            'mapper' => ['config', 'slide']
        ];
        Tpl::view('admin.slide.form', $data, 1);
    }
    public function editar()
    {
        $id = Http::get_in_params('id', 'int');        
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $escope = [
                'slide_url' => 'text',
                'slide_img' => 'text',
                'slide_status' => 'text',
            ];
            $slide = (new Factory('slide'))
                ->select("*")
                ->format($escope)->find($id);
            if (!empty($slide)) {
                $data = [
                    'slide' => $slide,
                    
                    'config' => (new Config)->get(),
                    'mapper' => ['config', 'slide']
                ];
                Tpl::view('admin.slide.form', $data, 1);
            } else {
                Http::redirect_to('/slide-lista/');
            }
        } else {
            Http::redirect_to('/slide-lista/');
        }
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        $img = Req::post('img');
        $ds = DIRECTORY_SEPARATOR;
        $path = Path::base() . $ds . 'media' . $ds . 'slides' . $ds . $img;
        if ($id > 0) {
            (new Factory('slide'))->drop($id);
            if (is_file($path)) {
                //@system("chmod -R 777 $path");
                @unlink($path);
            }
            echo 1;
        } else {
            echo -1;
        }
    }

    public function ordenar()
    {
        $slides = json_decode(Req::post('diff'));
        $db_slide = (new Factory('slide'));
        foreach ($slides as $slide) {
            $id = explode('-', $slide->node->_prevClass);
            if (intval($id[2]) > 0 && isset($id[2])) {
                $data = [
                    'id' => $id[2],
                    'pos' => $slide->newPosition,
                ];
                $db_slide->with($data)->save();
            }
        }
    }
}
