<?php

class Relatorios
{

    public function __construct()
    {
        Sessao::check();
    }

    // Captura os anos em que existem registros de vendas
    public function getYears()
    {
        (new Factory('pedido'))
            ->select('YEAR(pedido_created) AS pedido_ano')
            ->group_by('pedido_ano')
            ->order("pedido_ano DESC")
            ->get(1);
    }

    public function vendasByYear()
    {
        $ano = Req::post('ano', 'int');

        if ($ano > 0) (new Factory('pedido'))
            ->select('COUNT(*) AS pedido_qtd, MONTH(pedido_created) AS pedido_mes')
            ->group_by('pedido_mes')
            ->where('YEAR(pedido_created) = ' . $ano)
            ->get(1);
    }


    public function totalVendasByYear()
    {
        $ano = (Req::post('ano', 'int') > 0) ? Req::post('ano', 'int') : date('Y');
        //$mes = Req::post('mes');
        //$ano = 2024;
        //$mes = 11;
        if ($ano > 0) {
            $meses = (new Factory('pedido'))
                ->select('COUNT(*) AS pedido_qtd, MONTH(pedido_created) AS pedido_mes')
                ->group_by('pedido_mes')
                ->where('YEAR(pedido.pedido_created) = ' . $ano . ' AND pedido.pedido_status = 3')
                ->get();
            $aux = [];
            foreach ($meses as $mes) {
                $total = (new Factory('pedido'))
                    ->select('COUNT(*) AS pedido_qtd, MONTH(pedido_created) AS pedido_mes,SUM(pedido_total_frete) AS total')
                    ->group_by('pedido_mes')
                    ->where('YEAR(pedido_created) = ' . $ano . ' AND MONTH(pedido_created) = ' . $mes->pedido_mes . ' AND pedido_status = 3')
                    ->get();
                $aux[] = ['pedido_qtd' => $mes->pedido_qtd, 'pedido_mes' => $mes->pedido_mes, 'total' => Math::decimal($total[0]->total)];
            }
            echo json_encode($aux);
        }
    }

    public function totalVendasByYearUf()
    {
        $ano = (Http::get_param(1, 'int') > 0) ? Http::get_param(1, 'int') : date('Y');
        if ($ano > 0) {
            $meses = (new Factory('pedido'))
                ->select('MONTH(pedido_created) AS pedido_mes')
                ->group_by('pedido_mes')
                ->where('YEAR(pedido.pedido_created) = ' . $ano . ' AND pedido.pedido_status = 3')
                ->get();
            $aux = [];
            if (isset($meses[0])) {
                foreach ($meses as $mes) {
                    $ufs = (new Factory('pedido'))
                        ->select('COUNT(*) AS qtde, endereco_cliente_uf AS uf, SUM(pedido_total_frete) AS total')
                        ->join('endereco_cliente', 'endereco_cliente_id = pedido.pedido_endereco')
                        ->group_by('endereco_cliente_uf')
                        ->order('endereco_cliente_uf DESC')
                        ->where('YEAR(pedido.pedido_created) = ' . $ano . ' AND MONTH(pedido_created) = ' . $mes->pedido_mes . ' AND pedido_status = 3')
                        ->get();
                    $aux[self::getMesExtenso($mes->pedido_mes)] = $ufs;
                }
            }
            $data = [
                'config' => (new Config)->get(),
                'vendas' => $aux,
                'ano' => ['ano' => $ano],
                'mapper' => ['config', 'ano']
            ];
            Tpl::view('admin.relatorios.vendas.uf', $data);
        }
    }

    public function produtosMaisVisitados()
    {
        $produtos = (new Factory('produto'))->select('produto_acessos as views, produto_titulo as item')
            ->where('produto_acessos > 10')
            ->order('produto_acessos DESC')
            ->limit(7)
            ->get();

        $labels = [];
        $data = [];
        foreach ($produtos as $p) {
            $labels[] = $p->item;
            $data[] = $p->views;
        }
        echo json_encode(['labels' => $labels, 'views' => $data]);
    }

    public function produtosMaisVendidos()
    {
        $produtos = (new Factory('lista_pedido'))->select('COUNT(*) as qtd, lista_pedido_produto_titulo as item')
            ->group_by('item')
            ->order('qtd DESC')
            ->limit(7)
            ->get();

        $labels = [];
        $data = [];
        foreach ($produtos as $p) {
            $labels[] = $p->item;
            $data[] = $p->qtd;
        }
        echo json_encode(['labels' => $labels, 'views' => $data]);
    }

    public function pedidosCupom()
    {
        $lista_filtros = ['pedido_cliente'];
        $where = 'cliente_id > 0 AND pedido_cupom_alfa <> "" AND pedido_status = 3 ';
        if (Req::get('filtro')) {
            $filtro = Req::get('filtro');
            $perms = explode(' ', $filtro);
            $term = $perms[0];
            if (in_array($term, $lista_filtros)) {
                $where =  $filtro;
            }
        }
        (new Factory('pedido'))
            ->select("cliente_nome, pedido_id, pedido_total_parcelado,pedido_total_frete, pedido_info, pedido_total_produto,pedido_tipo, pedido_nf_num_id, pedido_nf_chave,pedido_status AS pedido_status_num, pedido_nf_status,pedido_cupom_alfa,pedido_cupom_info,pedido_cupom_desconto,cupom_alfa,cupom_tipo,cupom_real,cupom_desconto,
            CASE pedido_status
            WHEN 1 THEN 'Aguardando Pagamento'
            WHEN 2 THEN 'Em análise'
            WHEN 3 THEN 'Aprovado'
            WHEN 4 THEN 'Disponível'
            WHEN 5 THEN 'Em disputa'
            WHEN 6 THEN 'Devolvido'
            WHEN 7 THEN 'Cancelado'            
       END AS pedido_status,
            DATE_FORMAT(pedido_created, '%d/%m/%Y às %H:%i:%s') AS pedido_data
            ")
            ->join('cliente', 'cliente_id = pedido_cliente')
            ->join('cupom', 'cupom_alfa = pedido_cupom_alfa', 'left')
            ->where("$where")
            ->order('pedido_id DESC')
            ->get(1);
    }

    public function produtos()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.relatorios.produtos.index', $data);
    }

    public function cupom()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.relatorios.produtos.cupom', $data);
    }

    public function upgrade()
    {
        $columns = ['name' => 'produto_acessos', 'new' => 'produto_acessos', 'type' => 'int(11)', 'default' => '0'];
        (new DB)->alter_column('produto', $columns);
    }

    static public function getMesExtenso($mes)
    {
        $meses = [
            1 => 'Janeiro',
            2 => 'Fevereiro',
            3 => 'Março',
            4 => 'Abril',
            5 => 'Maio',
            6 => 'Junho',
            7 => 'Julho',
            8 => 'Agosto',
            9 => 'Setembro',
            10 => 'Outubro',
            11 => 'Novembro',
            12 => 'Dezembro'
        ];
        return $meses[$mes];
    }
}
