<?php
@session_start();

class ProdutosFront
{
	public $array_final = [];
	public $qtd_execucoes = 0;

	public function listarOfertas()
	{
		$prod = (new Factory('produto'))
			->select('
            produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos,
            produto_oferta, produto_url, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto,
            (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->where('produto_status = 1 AND produto_oferta = 1')
			->group_by('produto.produto_id')
			->order('produto_id DESC LIMIT 8')
			->get();

		if (isset($prod[0])) {
			$gw = PagamentoFront::gw();
			foreach ($prod as $k => $v) {
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
				$prod[$k]->qtd_parcelas_sem_juros = intval($gw->pay_c8);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod[$k]->produto_text_parc = $parcs['texto_sem_juros'];
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		} else {
			return null;
		}
		return $prod;
	}

	public function listarNovos()
	{
		$prod = (new Factory('produto'))
			->select('
                produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos, produto_oferta, produto_url, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->where('produto_status = 1')
			->group_by('produto.produto_id')
			->order('produto_id DESC LIMIT 8')
			->get();

		if (isset($prod[0])) {
			$gw = PagamentoFront::gw();
			foreach ($prod as $k => $v) {
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
				$prod[$k]->qtd_parcelas_sem_juros = intval($gw->pay_c8);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod[$k]->produto_text_parc = $parcs['texto_sem_juros'];
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		} else {
			return null;
		}
		return $prod;
	}

	public function listarDestaques()
	{
		//ifnull(nullif(foto2.foto_produto_img, ""), foto1.foto_produto_img) AS produto_foto_hover
		$prod = (new Factory('produto'))
			->select('
                produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos, produto_oferta, produto_url, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto,
				 produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->where('produto_status = 1 AND produto_destaque = 1')
			->group_by('produto.produto_id')
			->order('produto_id DESC LIMIT 8')
			->get();

		if (isset($prod[0])) {
			$gw = PagamentoFront::gw();
			foreach ($prod as $k => $v) {
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
				$prod[$k]->qtd_parcelas_sem_juros = intval($gw->pay_c8);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod[$k]->produto_text_parc = $parcs['texto_sem_juros'];
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		} else {
			return null;
		}
		//Filter::pre($prod);exit;
		return $prod;
	}

	public function listarMaisAcessados()
	{
		$prod = (new Factory('produto'))
			->select('
                produto_id, produto_estoque, produto_oferta, produto_url, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque
            ')
			->where('produto_status = 1')
			->group_by('produto.produto_id')
			->order('produto_acessos DESC LIMIT 7')
			->get();
		if (isset($prod[0])) {
			$gw = PagamentoFront::gw();
			foreach ($prod as $k => $v) {
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
				$prod[$k]->qtd_parcelas_sem_juros = intval($gw->pay_c8);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod[$k]->produto_text_parc = $parcs['texto_sem_juros'];
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		} else {
			return null;
		}
		return $prod;
	}

	public function listarMaisVendidos()
	{
		$prod = (new Factory('produto'))
			->select('
                produto_id, produto_oferta, produto_estoque, produto_url, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, SUM(lista_pedido_qtde) AS produto_qtd_vendas,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->join('lista_pedido', 'lista_pedido_produto = produto_id', 'INNER')
			->where('produto_status = 1')
			->group_by('lista_pedido_produto')
			->order('produto_qtd_vendas DESC LIMIT 7')
			->get();

		if (isset($prod[0])) {

			$gw = PagamentoFront::gw();
			foreach ($prod as $k => $v) {
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
				$prod[$k]->qtd_parcelas_sem_juros = intval($gw->pay_c8);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod[$k]->produto_text_parc = $parcs['texto_sem_juros'];
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		} else {
			return null;
		}
		return $prod;
	}

	static public function getProdutoById($id)
	{
		$prod = (new Factory('produto'))
			->select('produto.*,marca_nome,
                produto_id, produto_estoque,produto_tipo_unidade, produto_url, produto_titulo, produto_preco, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, 
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('marca', 'marca_id = produto_marca', 'left')
			->where('produto_id = ' . $id)
			->get();

		return $prod[0];
	}
	// Captura os dados de 1 produto pra mostrar na pagina do mesmo
	public function getProdutoInfo()
	{
		$id = Req::post('id', 'int');
		$id = $_REQUEST['id'] ? $_REQUEST['id'] : $id;
		if ($id > 0) {
			$prod = (new Factory('produto'))
				->select('
                    produto_id, produto_ref, produto_oferta, produto_url, produto_estoque, produto_min_estoque, produto_titulo, produto_desc,  produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, produto_status, produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,produto_tipo_unidade,(SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS qtd_atributos_atrelados
                ')
				->where('produto_id = ' . $id)
				->get();

			if (isset($prod[0]->produto_id)) {
				$gw = PagamentoFront::gw();
				$prod = $prod[0];
				$preco = $prod->produto_preco;
				if (Req::post('np') && Req::post('np') > 0) {
					$np = Req::post('np');
					$preco = $np; // Math::moedaUS(Math::decimal($np));
					$prod->produto_preco = $preco;
				}
				$prod->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod->desc_boleto = intval($gw->pay_fator_juros);
				$prod->qtd_parcelas = intval($gw->pay_c6);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod->produto_preco_parc = $parcs['texto_sem_juros'];
				$prod->qtd_parcelas_sem_juros = $gw->pay_c8;

				$fotos = (new Factory('foto_produto'))
					->select('foto_produto_id, foto_produto_img')
					->where('foto_produto_produto = ' . $id)
					->order('foto_produto_pos ASC')
					->get();

				if ($fotos) {
					$prod->produto_imagens = $fotos;
				} else {
					$prod->produto_imagens = [(object) ['foto_produto_id' => 0, 'foto_produto_img' => 'nopic.png']];
				}

				// Captura todos os atributos pais do produto
				$atributo = (new Factory('atributo'))
					->join('relacao_atributo', 'relacao_atributo_atributo = atributo_id')
					->where('relacao_atributo_produto = ' . $id)
					->group_by('atributo_id')
					->order('atributo_nome asc')
					->get();
				if (is_array($atributo) && sizeof($atributo) > 0) {
					foreach ($atributo as $k => $v) {
						// Captura todos os itens do atributo
						$iattr = (new Factory('item_atributo'))
							->where('item_atributo_atributo = ' . $atributo[$k]->atributo_id)
							->order('item_atributo_nome asc')
							->get();

						if (is_array($iattr) && sizeof($iattr) > 0) {
							foreach ($iattr as $k2 => $v2) {
								$relatrr = (new Factory('relacao_atributo'))
									->where('relacao_atributo_item_atributo = ' . $iattr[$k2]->item_atributo_id . ' AND relacao_atributo_produto = ' . $id)
									->get();
								if ($relatrr) {
									$iattr[$k2]->item_atributo_preco = $relatrr[0]->relacao_atributo_preco;
									$iattr[$k2]->item_atributo_qtd = $relatrr[0]->relacao_atributo_qtd;
									$iattr[$k2]->item_atributo_valor = $relatrr[0]->relacao_atributo_valor;
								} else {
									$iattr[$k2]->item_atributo_qtd = '';
									$iattr[$k2]->item_atributo_preco = '';
									$iattr[$k2]->item_atributo_valor = '';
								}
							}
						}
						$atributo[$k]->item = $iattr;
					}
				}
				$prod->atributos = $atributo;

				echo json_encode($prod);
			} else {
				echo json_encode(['error' => 'Nenhum produto encontrado']);
			}
		} else {
			echo json_encode(['error' => 'Id de produto inválido']);
		}
	}

	// Lista informações dos atributos que o item tem vinculo, apenas visualização no front
	public function lista_atributos_e_itens_produto()
	{
		$id = Req::post('id', 'int');
		if ($id > 0) {
			$atributos_com_vinculo = (new Factory('atributo'))
				->select("atributo_nome, atributo_id")
				->join("relacao_atributo", "relacao_atributo_atributo = atributo_id")
				->where("relacao_atributo_produto = $id")
				->group_by('atributo_id')
				->order("relacao_atributo_id")
				->get();
			if (isset($atributos_com_vinculo[0])) {
				foreach ($atributos_com_vinculo as $k) {
					$itens = (new Factory('item_atributo'))
						->select("item_atributo_id, item_atributo_nome")
						->where("item_atributo_atributo = $k->atributo_id")
						->get();
					if (isset($itens[0])) {

						$k->itens = $itens;
					}
				}
			}
			echo json_encode(['status' => 200, 'atributos' => $atributos_com_vinculo]);
		}
	}

	// Lista os atributos e os itens de um determinado produto
	public function lista_atributos_inicialmente()
	{
		$id = Req::post('id', 'int');
		if ($id > 0) {
			$res = (new Factory('relacao_item'))
				->select("
                    relacao_item_id, relacao_item_relacao_pai, relacao_item_item, relacao_item_atributo,
                    item_atributo_nome
                ")
				->join('item_atributo', 'item_atributo_id = relacao_item_item')
				->where("relacao_item_produto = $id AND  relacao_item_qtd > 0")
				->get();
			if (isset($res[0])) {
				// verifica se tem estoque
				$itens_para_pesquisar = [];
				// Verifica se ele tem atributos pais ou apenas um atributo
				if (empty($res[0]->relacao_item_relacao_pai)) {
					// Apenas um atributo
					foreach ($res as $k) {
						$itens_para_pesquisar[] = $k->relacao_item_item;
					}
					$itens_para_pesquisar = implode(',', $itens_para_pesquisar);
					$res = (new Factory('relacao_item'))
						->select("
                        relacao_item_id, relacao_item_relacao_pai, relacao_item_atributo, relacao_item_qtd, relacao_item_preco,
                        item_atributo_nome, item_atributo_id
                        ")
						->join('item_atributo', 'item_atributo_id = relacao_item_item')
						->where("relacao_item_qtd > 0 AND relacao_item_produto = {$id} AND item_atributo_id IN ($itens_para_pesquisar)")
						->get();
					if (isset($res[0])) {
						foreach ($res as $k => $v) {
							//$res[$k]->relacao_item_preco =  Math::moedaUS(Math::decimal($v->relacao_item_preco));
						}
						echo json_encode(['status' => 200, 'atributos' => $res]);
					} else {
						// sem atributos
						echo json_encode(['status' => 404, 'atributos' => null]);
					}
					exit;
				} else {
					// multiplos atributos
					foreach ($res as $k) {
						$itens_pais = explode(">", $k->relacao_item_relacao_pai);

						if (isset($itens_pais[0])) {
							// multiplos atributos
							$pai_id = $itens_pais[0];
							if (!in_array($pai_id, $itens_para_pesquisar)) {
								$itens_para_pesquisar[] = $pai_id;
							}
						} else {
							$itens_para_pesquisar[] = $k->relacao_item_item;
						}
					}
				}

				$resposta = [];
				if (is_array($itens_para_pesquisar) && sizeof($itens_para_pesquisar) > 0) {
					foreach ($itens_para_pesquisar as $k) {
						$res = (new Factory('item_atributo'))
							->select("item_atributo_nome, item_atributo_id")
							->find($k);
						$resposta[] = $res;
					}
				}
				echo json_encode(['status' => 200, 'atributos' => $resposta]);
			} else {
				// sem atributos
				echo json_encode(['status' => 404, 'atributos' => null]);
			}
		}
	}

	// Lista os próximos itens de atributo a partir de um selecionado (seleciona uma opção e só traz os atributos filhos dela)
	public function lista_atributos_por_id()
	{
		$produto_id = Req::post('produto_id', 'int');
		$atributo_atual_indice = Req::post('indice', 'int');
		$itens = Req::post('itens');
		//$produto_id = $_REQUEST['produto_id'];
		//$atributo_atual_indice = $_REQUEST['indice'];
		//$itens = [1 =>  $_REQUEST['itens']];
		if ($produto_id > 0 && is_array($itens) && sizeof($itens) > 0 && $atributo_atual_indice > 0) {
			$itens = implode('>', $itens);
			$res = (new Factory('relacao_item'))
				->select("
            relacao_item_id, relacao_item_preco,relacao_item_relacao_pai, relacao_item_item, relacao_item_atributo,
            item_atributo_nome
            ")
				->join('item_atributo', 'item_atributo_id = relacao_item_item')
				->where("relacao_item_qtd > 0 AND relacao_item_produto = {$produto_id} AND relacao_item_relacao_pai LIKE '$itens%'")
				->get();
			if (isset($res[0])) {
				$itens_para_pesquisar = [];

				/* 					foreach ($res as $j => $v) {
										if ($v->relacao_item_preco > 0) {
											//	Math::moedaUS($v->relacao_item_preco);
											//$res[$j]->relacao_item_preco = number_format($v->relacao_item_preco, 2, ',', '.');
										}
				} */
				foreach ($res as $k) {
					// $k->relacao_item_relacao_pai = str_replace($itens, '', $k->relacao_item_relacao_pai);
					$itens_pais = explode(">", "{$k->relacao_item_relacao_pai}");
					if (is_array($itens_pais) && sizeof($itens_pais) > 0 && isset($itens_pais[$atributo_atual_indice])) {
						// multiplos atributos
						$pai_id = $itens_pais[$atributo_atual_indice];
						// Primeiro in_array para não repetir ids iguais na busca
						if (!in_array($pai_id, $itens_para_pesquisar)) {
							$itens_para_pesquisar[] = $pai_id;
						}
					} else {
						// Significa que a ligação nao tem itens pai, ou seja, é atributo unico
						$itens_para_pesquisar[] = $k->relacao_item_item;
						//$k->relacao_item_preco = number_format($k->relacao_item_preco, 2, ',', '.');
					}
				}
				$resposta = [];
				if (is_array($itens_para_pesquisar) && sizeof($itens_para_pesquisar) > 0) {
					foreach ($itens_para_pesquisar as $k) {
						$res = (new Factory('item_atributo'))
							//->select("item_atributo_nome, item_atributo_id")
							->find($k);
						$resposta[] = $res;
					}
				}
				echo json_encode(['status' => 200, 'atributos' => $resposta]);
			} else {
				// sem atributos
				echo json_encode(['status' => 404, 'atributos' => null]);
			}
		}
	}

	public function lista_atributos_por_id_last()
	{
		$produto_id = Req::post('produto_id', 'int');
		$atributo_atual_indice = Req::post('indice', 'int');
		$itens = Req::post('itens');
		if ($produto_id > 0 && is_array($itens) && sizeof($itens) > 0 && $atributo_atual_indice > 0) {
			$itens = implode('>', $itens);

			$res = (new Factory('relacao_item'))
				->select("
                    relacao_item_id, relacao_item_relacao_pai, relacao_item_atributo, relacao_item_qtd, relacao_item_preco,
                    item_atributo_nome, item_atributo_id
                ")
				->join('item_atributo', 'item_atributo_id = relacao_item_item')
				->where("relacao_item_qtd > 0 AND relacao_item_produto = {$produto_id} AND relacao_item_relacao_pai LIKE '$itens%'")
				->get();
			if (isset($res[0])) {
				foreach ($res as $k => $v) {
					//$res[$k]->relacao_item_preco = number_format($v->relacao_item_preco, 2, ',', '.');
				}
				echo json_encode(['status' => 200, 'atributos' => $res]);
			} else {
				// sem atributos
				echo json_encode(['status' => 404, 'atributos' => null]);
			}
		}
	}

	public function get_nome_atributos_vinculados()
	{
		$id = Req::post('id', 'int');

		if ($id > 0) {
			$res = (new Factory('relacao_atributo'))
				->select("atributo_nome, 'text-danger' AS text_color")
				->join("atributo", "atributo_id = relacao_atributo_atributo")
				->where("relacao_atributo_produto = $id")
				->group_by("atributo_id")
				->order('relacao_atributo_id')
				->get();
			if (isset($res[0])) {
				echo json_encode(['status' => 200, 'atributos_nome' => $res]);
			}
		} else {
			echo json_encode(['status' => 401]);
		}
	}

	public function getAtributoMandanteValores()
	{
		$itens_pai = Req::post('itens_pai');
		$atributo_atual = Req::post('atributo_atual');
		$produto_id = Req::post('produto_id', 'int');

		if (isset($atributo_atual) && !empty($atributo_atual) && $produto_id > 0) {
			$cadeia_de_itens = isset($itens_pai) && !empty($itens_pai) ? implode('>', $itens_pai) : ''; // variavel usada para trazer o ramo certo dos atributos (avô > pai)

			foreach ($atributo_atual['item'] as $k => $v) {
				$res = (new Factory('relacao_item'))
					->where("relacao_item_item = " . $atributo_atual['item'][$k]['item_atributo_id'] . " AND relacao_item_produto = $produto_id AND relacao_item_relacao_pai = '$cadeia_de_itens'")
					->get();

				if ($res) {
					$atributo_atual['item'][$k]['item_atributo_id_relacao'] = $res[0]->relacao_item_id; // salva o id da relacao
					$atributo_atual['item'][$k]['item_atributo_preco'] = $res[0]->relacao_item_preco;
					$atributo_atual['item'][$k]['item_atributo_qtd'] = $res[0]->relacao_item_qtd;
					$atributo_atual['item'][$k]['item_atributo_valor'] = $res[0]->relacao_item_valor;
				} else {
					$atributo_atual['item'][$k]['item_atributo_id_relacao'] = 0;
					$atributo_atual['item'][$k]['item_atributo_preco'] = "";
					$atributo_atual['item'][$k]['item_atributo_qtd'] = "";
					$atributo_atual['item'][$k]['item_atributo_valor'] = "";
				}
			}
			echo json_encode(['status' => 200, 'atributo_atual' => $atributo_atual]);
		} else {
			echo json_encode(['status' => 401]);
		}
	}

	// EXTRA ATRIBUTOS FRONT
	public function listaProdutosRelacionados($id = null)
	{
		//$id = intval(Http::get_in_params('id')->value);
		if ($id > 0) {
			$prod = (new Factory('produto'))
				->select('
		produto_id, produto_oferta, produto_estoque, produto_url, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto,
		IF(
		(SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
		(SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
		produto_estoque
		) AS produto_estoque,
		foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
		ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
		')
				->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
				->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
				->where('produto.produto_id IN (SELECT produtos_relacionados_produto2 FROM produtos_relacionados WHERE produtos_relacionados_produto1 = ' . $id . ') AND produto.produto_id <> ' . $id)
				->group_by('produto_id')
				->get();
			if (isset($prod[0])) {
				$gw = PagamentoFront::gw();
				foreach ($prod as $k => $v) {
					$preco = $prod[$k]->produto_preco;
					$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
					$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
					$prod[$k]->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
					$prod[$k]->desc_boleto = intval($gw->pay_fator_juros);

					$prod[$k]->qtd_parcelas = intval($gw->pay_c6);
					$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
					//$prod->qtd_parcelas_sem_juros = intval($gw->pay_c8);
					$prod[$k]->produto_preco_parc = $parcs['texto_sem_juros'];
					$prod[$k]->texto_parcs = $parcs['texto_sem_com'];
					$prod[$k]->qtd_parcelas_sem_juros = $gw->pay_c8;
					//$prod[$k]->produto_preco_parc = Filter::moeda($preco / $prod[$k]->qtd_parcelas);
				}
			} else {
				return null;
			}
			return $prod;
		}
	}

	public function recalculaAtributo()
	{
		$pid = Req::post('pid');
		$np = Req::post('np');
		$prod = (new Factory('produto'))->find($pid);
		$preco = Math::moedaUS(Math::decimal($np));
		if (isset($prod->produto_id)) {
			$prod->produto_preco = $preco;
			$gw = PagamentoFront::gw();
			$prod->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) *
				($gw->pay_fator_juros))) : '0,00';
			$prod->desc_boleto = intval($gw->pay_fator_juros);
			$prod->qtd_parcelas = intval($gw->pay_c6);
			$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
			$prod->qtd_parcelas_sem_juros = $gw->pay_c8;
			$prod->produto_text_parc = $parcs['texto_sem_juros'];
			echo json_encode($prod);
		}
	}
	public function getProdutoInfoByUrl()
	{
		$url = Req::post('produto_url', 'string');
		if (isset($url) && !empty($url)) {
			$prod = (new Factory('produto'))
				->select('produto_id, produto_oferta, produto_url, produto_estoque, produto_min_estoque, produto_titulo, produto_desc,  produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, produto_status, produto_largura, produto_altura, produto_comprimento, produto_ref, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo')
				->where('produto_url = ' . $url)
				->get()[0];

			if (isset($prod[0]->produto_id)) {
				$prod = $prod[0];
				$id = $prod->produto_id;
				$gw = PagamentoFront::gw();
				$preco = $prod->produto_preco;

				$prod->produto_preco_desc_boleto = intval($gw->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($gw->pay_fator_juros))) : '0,00';
				$prod->desc_boleto = intval($gw->pay_fator_juros);
				$prod->qtd_parcelas = intval($gw->pay_c6);
				$parcs = PagamentoFront::installments($preco, $gw->pay_c6, $gw->pay_c8);
				$prod->produto_text_parc = $parcs['texto_sem_juros'];
				$prod->qtd_parcelas_sem_juros = $gw->pay_c8;

				$fotos = (new Factory('foto_produto'))
					->select('foto_produto_id, foto_produto_img')
					->where('foto_produto_produto = ' . $id)
					->get();

				if ($fotos) {
					$prod->produto_imagens = $fotos;
				} else {
					$prod->produto_imagens = [(object) ['foto_produto_id' => 0, 'foto_produto_img' => 'nopic.png']];
				}

				// Captura todos os atributos pais do produto
				$atributo = (new Factory('atributo'))
					->join('relacao_atributo', 'relacao_atributo_atributo = atributo_id')
					->where('relacao_atributo_produto = ' . $id)
					->group_by('atributo_id')
					->order('atributo_nome asc')
					->get();
				if (is_array($atributo) && sizeof($atributo) > 0) {
					foreach ($atributo as $k => $v) {
						// Captura todos os itens do atributo
						$iattr = (new Factory('item_atributo'))
							->where('item_atributo_atributo = ' . $atributo[$k]->atributo_id)
							->order('item_atributo_nome asc')
							->get();

						if (is_array($iattr) && sizeof($iattr) > 0) {
							foreach ($iattr as $k2 => $v2) {
								$relatrr = (new Factory('relacao_atributo'))
									->where('relacao_atributo_item_atributo = ' . $iattr[$k2]->item_atributo_id . ' AND relacao_atributo_produto = ' . $id)
									->get();
								if ($relatrr) {
									$iattr[$k2]->item_atributo_preco = $relatrr[0]->relacao_atributo_preco;
									$iattr[$k2]->item_atributo_qtd = $relatrr[0]->relacao_atributo_qtd;
									$iattr[$k2]->item_atributo_valor = $relatrr[0]->relacao_atributo_valor;
								} else {
									$iattr[$k2]->item_atributo_qtd = '';
									$iattr[$k2]->item_atributo_preco = '';
									$iattr[$k2]->item_atributo_valor = '';
								}
							}
						}
						$atributo[$k]->item = $iattr;
					}
				}
				$prod->atributos = $atributo;
				echo json_encode($prod);
			} else {
				echo json_encode(['error' => 'Nenhum produto encontrado']);
			}
		} else {
			echo json_encode(['error' => 'Id de produto inválido']);
		}
	}

	public function busca()
	{
		$busca = Req::post('busca', 'string');
		$prod = (new Factory('produto'))
			->select('produto_id, produto_oferta, produto_url, produto_ref, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto, produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
			foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
			ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->where('(produto_titulo LIKE "%' . $busca . '%" AND produto_status = 1) OR (produto_keywords LIKE "%' . $busca . '%" OR produto_ref = "' . $busca . '" AND produto_status = 1) ')
			->group_by('produto.produto_id')
			->order('produto_acessos DESC')
			->get();
		if (isset($prod[0])) {
			foreach ($prod as $k => $v) {
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
		}
		echo json_encode($prod);
	}

	static public function  get_categorias_produto($produto_id)
	{
		$categorias = (new Factory('vinculo_categoria_produto'))
			->select("vinculo_categoria_produto_categoria AS id, categoria_produto_nome AS nome")
			->join('categoria_produto', 'categoria_produto_id = vinculo_categoria_produto_categoria')
			->where("vinculo_categoria_produto_produto = $produto_id")
			->group_by("vinculo_categoria_produto_categoria")
			->get();
		if (isset($categorias[0])) {
			$arr = [];
			foreach ($categorias as $k) {
				array_push($arr, $k->nome);
			}
			$categorias = $arr;
		}
		return $categorias;
	}
	// Renderiza a view de um produto acessado
	public function viewProduto()
	{
		$url = trim(Http::get_in_params('produto', 'string')->value);
		if ($url == "") {
			Http::redirect(Http::base());
		}
		$produtoData = (new Factory('produto'))
			->select('produto_id, produto_titulo,produto_preco,produto_ref, produto_keywords, produto_acessos,produto_url,marca_nome,produto_sku')
			->join('marca', 'marca_id = produto_marca', 'left')
			->where('produto_url = "' . $url . '" AND produto_status = 1')
			->get();
		if (!isset($produtoData[0])) {
			Http::redirect_to('/');
		}
		$produto = $produtoData[0];
		$id = $produto->produto_id;
		$keywords = $produto->produto_keywords;
		$data = [
			'id' => $id,
			'acessos' => intval($produto->produto_acessos) + 1,
		];
		$cep = '';
		if (isset($_SESSION['CEP'])) {
			$cep = $_SESSION['CEP'];
		}
		(new Factory('produto'))->with($data)->save();

		$cats_prod = self::get_categorias_produto($id);
		$card = (new Factory('config_card'))->get()[0];
		$gw = PagamentoFront::gw();
		$produto->produto_parcelas =  PagamentoFront::installments($produto->produto_preco, $gw->pay_c6, $gw->pay_c8);
		$produto->qtd_parcelas_sem_juros = intval($gw->pay_c8);
		$data = [
			'categorias' => (new CategoriasProdutosFront())->listar(),
			'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
			'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
			'paginasTopo' => (new Pagina())->listarPaginasTopo(),
			'paginasFooter' => (new Pagina())->listarPaginasFooter(),
			'faq' => (new Faq())->listaFooter(),
			'config' => (new Config)->get(),
			'produto' =>  $produto,
			'produto_id' => ['produto_id' => $id],
			'produto_categorias' => $cats_prod,
			'produto_parcelas' => $produto->produto_parcelas,
			'produtosRelacionados' => $this->listaProdutosRelacionados($id),
			'card' => $card,
			'cep' => ['cep' => $cep],
			'frete' => (new Factory('frete'))->find(1),
			'produto_keywords' => ['produto_keywords' => $keywords],
			'social' => (new Config)->getRedesSociais(),
			'mapper' => ['config', 'produto_id', 'produto', 'card', 'produto_parcelas', 'produto_keywords', 'social', 'cep', 'frete'],
		];
		Tpl::view("tema.loja.produto.index", $data, 1);
	}


	public function calcularPrecoProdutoDimensoes()
	{
		$produto_id = Req::post('produto_id', 'int');
		$produto = (new Factory('produto'))->find($produto_id);

		$preco_base = $produto->produto_preco;

		$largura = Req::post('largura', 'int') / 100;
		$altura = Req::post('altura', 'int') / 100;
		//$comprimento = $produto->produto_comprimento;

		$area = $altura * $largura;
		$preco_final = $area * $preco_base;

		$gw = PagamentoFront::gw();
		$parcs = PagamentoFront::installments($preco_final, $gw->pay_c6, $gw->pay_c8);

		$preco_desc = intval($gw->pay_fator_juros) > 0 ? ($preco_final - (($preco_final / 100) * ($gw->pay_fator_juros))) : '0,00';

		$produto = [
			'preco' => $preco_final,
			'preco_parc' => $parcs['texto_sem_juros'],
			'preco_desc' => $preco_desc,
			'qtd_parcelas_sem_juros' => $gw->pay_c8
		];
		echo json_encode($produto);
	}
}
