<?php

class PaginaAdmin
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),

            'mapper' => ['config', 'modulos']
        ];
        Tpl::view('admin.pagina.index', $data, 1);
    }
    public function categoria()
    {
        $data = [
            'config' => (new Config)->get(),

            'mapper' => ['config', 'modulos']
        ];
        Tpl::view('admin.pagina.categoria', $data, 1);
    }
    public function subcategoria()
    {
        $data = [
            'config' => (new Config)->get(),

            'mapper' => ['config', 'modulos']
        ];
        Tpl::view('admin.pagina.subcategoria', $data, 1);
    }

    public function lista()
    {
        (new Factory('pagina'))
            ->select("pagina_id, pagina_titulo, IF(pagina_status = 1, 'Ativa', 'Inativa') AS pagina_status_nome, pagina_status, pagina_categoria, categoria_pagina_nome, pagina_capa")
            ->join('categoria_pagina', 'categoria_pagina_id = pagina_categoria', 'LEFT')
            ->join('subcategoria_pagina', 'subcategoria_pagina_id = pagina_subcategoria', 'LEFT')
            ->order('pagina_id DESC')
            ->get(1);
    }

    public function lista_categoria()
    {
        (new Factory('categoria_pagina'))
            ->select("categoria_pagina_id, categoria_pagina_nome, categoria_pagina_cor, categoria_pagina_icone, categoria_pagina_topo, categoria_pagina_rodape")
            ->order('categoria_pagina_pos ASC')
            ->get(1);
    }
    public function gravar_categoria()
    {
        Sessao::perms('G');
        if (isset($_POST['categoria_pagina_nome']) && !empty($_POST['categoria_pagina_nome'])) {
            $_POST = Filter::parse_full($_POST);
            $_POST['categoria_pagina_url'] = Filter::slug($_POST['categoria_pagina_nome']);
            $format = ['categoria_pagina_nome' => 'text', 'categoria_pagina_url' => 'text'];
            (new Factory('categoria_pagina'))->with($_POST)->format($format)->save();
            if (Req::get('return')) {
                Http::redirect_to("/" . Req::get('return'));
            } else {
                Http::redirect_to("/pagina-categoria/?success");
            }
        } else {
            Http::redirect_to("/pagina-categoria");
        }
    }
    public function remover_categoria()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('categoria_pagina'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function lista_subcategoria()
    {
        (new Factory('subcategoria_pagina'))
            ->select("subcategoria_pagina_id, subcategoria_pagina_nome, categoria_pagina_nome, subcategoria_pagina_categoria")
            ->join('categoria_pagina', 'categoria_pagina_id = subcategoria_pagina_categoria')
            ->order('subcategoria_pagina_nome ASC')
            ->get(1);
    }
    public function lista_subcategoria_from_cat()
    {
        $cat = Http::get_in_params('id', 'int');

        if (isset($cat->value) && $cat->value > 0) {
            (new Factory('subcategoria_pagina'))
                ->select("subcategoria_pagina_id, subcategoria_pagina_nome")
                ->where("subcategoria_pagina_categoria = $cat")
                ->get(1);
        }
    }
    public function gravar_subcategoria()
    {
        if (isset($_POST['subcategoria_pagina_nome']) && !empty($_POST['subcategoria_pagina_nome'])) {
            $_POST = Filter::parse_full($_POST);
            Sessao::perms('G');
            $_POST['subcategoria_pagina_url'] = Filter::slug($_POST['subcategoria_pagina_nome']);
            Req::drop_blank();
            $format = ['subcategoria_pagina_nome' => 'text', 'subcategoria_pagina_url' => 'text'];
            (new Factory('subcategoria_pagina'))->with($_POST)->format($format)->save();
            Http::redirect_to("/pagina-subcategoria/?success");
        } else {
            Http::redirect_to("/pagina-subcategoria");
        }
    }
    public function remover_subcategoria()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('subcategoria_pagina'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function gravar()
    {
        if (isset($_POST['pagina_titulo']) && !empty($_POST['pagina_titulo'])) {
            //$_POST = Filter::parse_full($_POST);
            Sessao::perms('G');
            Req::drop('_wysihtml5_mode');
            Req::drop_blank();
            if (isset($_FILES['files'])) {
                unset($_FILES['files']);
            }

            if (isset($_POST['pagina_status'])) {
                $_POST['pagina_status'] = intval($_POST['pagina_status']);
            }
            $id = Req::post('pagina_id');
            if (!empty($_FILES['pagina_capa']['name'])) {
                $media = Media::img_upload($_FILES['pagina_capa'], 'pagina');
            }

            if (!empty($media)) {
                $_POST['pagina_capa'] = $media->url;
                if (intval($id) > 0) {
                    $excluir = (new Factory('pagina'))->select('pagina_capa as url')->find($id);
                    $ds = DIRECTORY_SEPARATOR;
                    $path = Path::base() . $ds . 'media' . $ds . 'pagina' . $ds . $excluir->url;
                    if (is_file($path)) {
                        //@system("chmod -R 777 $path");
                        //                    @chmod("$path", 775);
                        @unlink($path);
                    }
                }
            }
            $escope = [
                'pagina_desc' => 'text',
                'pagina_keywords' => 'text',
            ];
            $_POST['pagina_status'] = 1;
            if (isset($_POST['pagina_titulo'])) {
                $_POST['pagina_url'] = Filter::slug($_POST['pagina_titulo']);
            }
            $pagina = (new Factory('pagina'))->with($_POST)->save();
            if ($pagina > 0) {
                Http::redirect_to('/pagina-lista/?success');
            } else {
                Http::redirect_to('/pagina-lista/?error');
            }
        }
    }
    public function editar()
    {
        $id = Http::get_in_params('id', 'int');

        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $base_uri = Http::base();
            $pagina = (new Factory('pagina'))
                ->select("*,DATE_FORMAT(pagina_updated, '%d de %M de %Y') as pagina_updated,IF(pagina_capa IS NOT NULL, 
                    CONCAT('$base_uri/media/pagina/', pagina_capa), '') AS pagina_capa")
                ->join("categoria_pagina", "categoria_pagina_id = pagina_categoria", 'LEFT')
                ->where("pagina_id = $id")
                ->get();
            if (isset($pagina)) {
                $data = [
                    'pagina' => $pagina[0],

                    'config' => (new Config)->get(),
                    'mapper' => ['config', 'pagina', 'modulos']
                ];
                Tpl::view('admin.pagina.form', $data, 1);
            } else {
                Http::redirect_to('/pagina-lista/');
            }
        } else {
            Http::redirect_to('/pagina-lista/');
        }
    }
    public function novo()
    {
        $pagina = (new Factory('pagina'))
            ->join("categoria_pagina", "categoria_pagina_id = pagina_categoria", 'INNER')
            ->map();
        $data = [
            'pagina' => $pagina,
            'config' => (new Config)->get(),

            'mapper' => ['config', 'pagina', 'modulos']
        ];
        $data['pagina']->categoria_pagina_url = '';
        Tpl::view('admin.pagina.form', $data);
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        $img = Req::post('img');
        $ds = DIRECTORY_SEPARATOR;
        $path = Path::base() . $ds . 'media' . $ds . 'pagina' . $ds . $img;
        if ($id > 0) {
            (new Factory('pagina'))->drop($id);
            if (is_file($path)) {
                //@system("chmod -R 777 $path");
                @unlink($path);
            }
            echo 1;
        } else {
            echo -1;
        }
    }

    public function altera_status()
    {
        Sessao::perms('G', 1);
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $status = intval($_POST['pagina_status']);
            $status == 1 ? $status = 0 : $status = 1;
            $data = [
                'id' => $id,
                'pagina_status' => $status
            ];
            (new Factory('pagina'))->with($data)->save();
        }
    }

    public function url()
    {
        if (isset($_POST['value'])) {
            $_POST['value'] = Filter::slug($_POST['value']);
        }
        echo $_POST['value'];
    }

    public function ordenar()
    {
        $cats = json_decode(Req::post('diff'));
        $db_cat = (new Factory('categoria_pagina'));

        foreach ($cats as $cat) {
            $id = explode('-', $cat->node->_prevClass);
            if (intval($id[2]) > 0 && isset($id[2])) {
                $data = [
                    'id' => $id[2],
                    'pos' => $cat->newPosition,
                ];
                $db_cat->with($data)->save();
            }
        }
    }
}
