<?php

class Favorito
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }
    public function indexAction()
    {
        if (!Session::client_node('uid')) {
            Http::redirect_to('/');
        }
        $data = [
            // Menu Superior
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            // Feed Produtos
            'produtos' => self::listar_by_cliente(),
            //'categoria' => $categoria,
            'marcas' => (new SlideFront())->listarMarcas(),
            // Footer
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            // Principal
            'config' => (new Config)->get(),
            'social' => (new Config)->getRedesSociais(),
            /*'cat' => $cat,
                'sub' => $sub,
                'min' => $min,
                'max' => $max,*/
            'mapper' => ['config', 'social'],
        ];

        Tpl::view("tema.loja.favorito.index", $data, 1);
    }

    public function listar_by_cliente()
    {
        if (!Session::client_node('uid')) {
            Http::redirect_to('/');
        }
        $sql = 'produto_id, 
                produto_oferta,
                produto_url, 
                produto_estoque, 
                produto_ref,
                produto_titulo, 
                produto_preco AS produto_preco_original, 
                (produto_preco - produto_desconto) AS produto_preco, 
                produto_desconto, 

                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                                    produto_estoque
                                ) AS produto_estoque,                                
                                (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto';

        $cliente_id = Session::client_node('uid');

        if ($cliente_id > 0) {
            $prod = (new Factory('favorito'))->select($sql)
                ->join('produto', 'favorito_produto = produto_id')
                ->where("favorito_cliente = $cliente_id")
                ->get();
            if (is_array($prod) && sizeof($prod) > 0) {
                $config_payment = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
                foreach ($prod as $k => $v) {
                    $preco = $prod[$k]->produto_preco;
                    $prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
                    $prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
                    $prod[$k]->produto_preco_desc_boleto = intval($config_payment->pay_fator_juros) > 0 ? Filter::moeda($preco - ($preco * (floatval('0.' . intval($config_payment->pay_fator_juros))))) : '0,00';
                    $prod[$k]->desc_boleto = intval($config_payment->pay_fator_juros);

                    $prod[$k]->qtd_parcelas = intval($config_payment->pay_c6);
                    $prod[$k]->produto_preco_parc =  Filter::moeda($preco / $prod[$k]->qtd_parcelas);
                    if ($prod[$k]->produto_foto == "")
                        $prod[$k]->produto_foto = 'nopic.png';
                }
            }
            if ($prod) {
                return $prod;
                //echo json_encode($produtos);exit;
            } else {
                return 0;
                echo 0;
                exit;
            }
        }
    }

    public function getQtdFavoritos()
    {
        $cliente_id = Session::client_node('uid');
        if ($cliente_id > 0) {
            $favoritos = (new Factory('favorito'))
                ->select('COUNT(favorito_id) AS favorito_qtd')
                ->where("favorito_cliente = $cliente_id")
                ->get();

            if (isset($favoritos[0])) {
                echo $favoritos[0]->favorito_qtd;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function gravar()
    {
        $cliente_id = Session::client_node('uid');
        $produto_id = Req::post('produto_id', 'int');
        if ($cliente_id > 0 && $produto_id > 0) {
            $dados = [
                'favorito_cliente' => $cliente_id,
                'favorito_produto' => $produto_id
            ];
            $save = (new Factory('favorito'))->with($dados)->save();
            if ($save > 0) {
                echo 1;
                exit;
            } else {
                echo 0;
                exit;
            }
        } else {
            echo -1;
            exit;
        }
    }

    //Retornar p estado do Botão de Favoritar
    public function is_favoritado()
    {
        $cliente_id = Session::client_node('uid');
        $produto_id = Req::post('produto_id', 'int');
        if ($cliente_id) {
            $produto = (new Factory('favorito'))
                ->select('favorito_id')
                ->where("favorito_cliente = $cliente_id AND favorito_produto = $produto_id")
                ->get();

            //Esse produto foi favoritado pelo cliente
            if (isset($produto[0])) {
                echo 1;
                exit;
            }
            //Não foi Favoritado
            else {
                echo 0;
                exit;
            }
        } else {
            //Cliente não logado
            echo -1;
            exit;
        }
    }

    public function remover()
    {
        $cliente_id = Session::client_node('uid');
        if (!$cliente_id) {
            Http::redirect_to('/');
        }
        $produto_id = Req::post('produto_id', 'int');
        if ($cliente_id > 0 && $produto_id > 0) {
            (new Factory('favorito'))->query("DELETE FROM favorito WHERE favorito_cliente = $cliente_id AND favorito_produto = $produto_id");
            echo 1;
            exit;
        } else {
            echo -1;
            exit;
        }
    }


    static function set_produto_sessao($produto_id = null)
    {
        if ($produto_id > 0) {
            $produto = (new Factory('produto'))->find($produto_id);
            if ($produto) {
                $_SESSION['ultimo_produto_visto'] = [
                    'produto_id' => $produto_id,
                    'produto_url' => $produto->produto_url,
                ];
            }
        }
    }
}
