<?php

use Erp\BlingApi;


class Cron
{

    private function sync_produto($pid = null)
    {
        if ($pid == null) {
            $pid = intval($_REQUEST['id']);
        }
        if (intval($pid) <= 0) {
            return false;
        }
        $p = (new Factory('produto'))->join('marca', 'marca_id = produto_marca', 'LEFT')->where('produto_id = ' . $pid)->get()[0];
        if (isset($p->produto_id) && $p->produto_id > 0) {
            $estoque = intval($p->produto_estoque);
            $status = ($p->produto_status == 1) ? 'A' : 'I';
            $status = 'A';
            $foto = $this->get_first_foto($pid);
            $p->marca_nome = ($p->marca_nome != '') ? $p->marca_nome : 'Marca';
            $link = Http::base() . "/produto/" . $p->produto_url;
            $p = [
                'nome'     => $p->produto_titulo,
                'preco'    => $p->produto_preco,
                'pesoLiquido'     => $p->produto_peso,
                'pesoBruto' => $p->produto_peso,
                'codigo'   => $p->produto_id,
                'marca'    => $p->marca_nome,
                'freteGratis' => ($p->produto_calcula_frete == 1) ? true : false,
                'gtin' => "{$p->produto_gtin}",
                'gtinEmbalagem' => "{$p->produto_gtint}",
                'tipoProducao' => ($p->produto_class_oriprod != '') ? $p->produto_class_oriprod : 'P',
                "dimensoes" => [
                    "largura" => $p->produto_largura,
                    "altura" => $p->produto_altura,
                    "profundidade" => $p->produto_comprimento,
                    "unidadeMedida" => 1
                ],
                'tributacao' => ['ncm' => "{$p->produto_class_fiscal}"],
                'tipo'     => 'P',
                'situacao' => $status,
                'linkExterno' => $link,
                'formato'  => 'S',
                'unidade'  => strtoupper($p->produto_tipo_unidade),
                //'imagemURL' => $foto,
                'midia' => [
                    /*'video' => [
                        'url' => '<string>'
                    ], */
                    'imagens' => [
                        'externas' => [
                            [
                                'link' => $foto
                            ]
                        ]
                    ]
                ]
            ];
            $pb = Bling::get_produto($pid);
            if (isset($pb->id)) {
                echo "sync  $pid - $pb->id <br>";
                $p['id'] = $pb->id;
                $p  = (object) $p;
                $res = Bling::sync_produto($p);
                //Filter::pre($res);
            } else {
                echo "add $pid <br>";
                $p  = (object) $p;
                $res =  Bling::add_produto($p);
                //Filter::pre($res);
            }
            //if (Bling::modulo_rec('rec3') == 1) {
            $rest = Bling::sync_estoque($pid, $estoque);
            //if ($rest) {
            //Filter::pre($rest);
            $today = date('Y-m-d H:i:s');
            $p->produto_estoque_dt_sync = $today;
            $produto = [
                'id' => $pid,
                'estoque_dt_sync' => $today
            ];
            $put = (new Factory('produto'))->with($produto)->save();
            //Filter::pre($put);

            //$get = (new Factory('produto'))->find($pid);
            //Filter::pre($get);
            //}
            //}
        }
    }

    static private function get_first_foto($pid)
    {
        $f = (new Factory('foto_produto'))->where("foto_produto_produto = $pid")->order('foto_produto_pos ASC')->limit(1)->get();
        $base = Http::base() . '/media/produto/';
        if (isset($f[0])) {
            return $base . $f[0]->foto_produto_img;
        } else {
            return $base . 'nopic.png';
        }
    }

    public function sync_produtos_bling()
    {
        Session::start();
        Session::node('uid', 0);
        sleep(1);
        $cond = 'produto_status = 1 AND ( (produto_estoque_dt_sync IS NULL OR produto_estoque_dt_sync <= NOW() - INTERVAL 6 HOUR)  OR produto_estoque_dt_sync < produto_updated)';
        $cond = 'produto_status = 1 AND ( (produto_estoque_dt_sync IS NULL OR produto_estoque_dt_sync <= NOW() - INTERVAL 1 HOUR)  )';
        $prods = (new Factory('produto'))
            ->where($cond)
            ->limit(10)
            ->order('produto_id DESC')
            ->get();
        if (isset($prods[0])) {
            foreach ($prods as $prod) {
                $this->sync_produto($prod->produto_id);
            }
        }
    }


    static public function refresh_bling_token()
    {
        Session::start();
        Session::node('uid', 0);
        Bling::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        return $token;
    }
    //busca pedidos na bling para baixar produtos na loja
    public function sync_bling_loja()
    {
        $token =  self::refresh_bling_token();
        sleep(1);
        $today = date('Y-m-d');
        $pedidos = BlingApi::pedidos($token, $today, $today);
        foreach ($pedidos->data as $ped) {
            $pedido = BlingApi::pedido($token, $ped->id);
            $log = (new Factory('pedido_bling'))->where("pedido_bling_id_bling = $ped->id")->get();
            if (!isset($log[0])) {
                (new Factory('pedido_bling'))->with(['id_bling' => $ped->id, 'data' => "$ped->data", 'numero' => $ped->numero])->save();
                //echo "<h1>Pedido: $ped->numero</h1>";
                foreach ($pedido->data->itens as $it) {
                    $produto_id = intval($it->codigo);
                    $qtde_vendida = intval($it->quantidade);
                    //echo "vendeu $qtde_vendida $it->descricao <br>";
                    Estoque::update_local_estoque(0, $produto_id, $qtde_vendida);
                }
            }
        };
    }
}
