<?php

class CategoriasProdutosFront
{
    public function listar()
    {
        $categorias = (new Factory('categoria_produto'))
            ->select("
                categoria_produto_id, categoria_produto_nome, categoria_produto_url,
                    (SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_categoria = categoria_produto_id) AS categoria_produto_qtd_produtos
                ")
            ->where("(SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_categoria = categoria_produto_id) > 0")
            ->order('categoria_produto_pos ASC')
            ->get();
        if (isset($categorias) && !empty($categorias) && is_array($categorias) && sizeof($categorias) > 0) {
            foreach ($categorias as $k => $v) {

                $categoria_id  = $categorias[$k]->categoria_produto_id;
                $categorias[$k]->categoria_produto_subcategorias = (new Factory('subcategoria_produto'))
                    ->select("subcategoria_produto_id, subcategoria_produto_nome, subcategoria_produto_url")
                    ->where("subcategoria_produto_categoria = $categoria_id AND (SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_subcategoria = subcategoria_produto_id) > 0")
                    ->order('subcategoria_produto_nome ASC')
                    ->get();
            }
            return $categorias;
        } else {
            return false;
        }
    }

    public function listaSubcategoriasDestaque()
    {
        return (new Factory('subcategoria_produto'))
            ->select("subcategoria_produto_id, IF(subcategoria_produto_apelido <> '', subcategoria_produto_apelido, subcategoria_produto_nome) AS subcategoria_produto_nome, subcategoria_produto_url, categoria_produto_url, subcategoria_produto_ordem_destaque")
            ->join('categoria_produto', 'categoria_produto_id = subcategoria_produto_categoria')
            ->where("subcategoria_produto_pos = 1 ORDER BY subcategoria_produto_ordem_destaque ASC")
            ->get();
    }
}
