<?php
session_start();
@setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'portuguese');


class CatalogoXml
{

    public function indexAction()
    {
        $feed = Http::get_param(1);
        if (isset($feed) && !empty($feed)) {
            match ($feed) {
                'google' => $this->google(),
                'facebook' => $this->facebook(),
                'instagram' => $this->instagram(),
                default => $this->feed()
            };
        }
    }

    public function google()
    {
        $csv = "id|title|description|price|condition|link|availability|image_link\t\r\n";
        $prod =  $this->produtos();
        $baseUri = Http::base();
        $base = $baseUri . "/media/produto";
        foreach ($prod as $p) {
            $foto = "{$base}/thumb_{$p->produto_foto}";
            $desc = Filter::cut("$p->produto_desc", 100, '');
            $p->produto_preco = Math::moeda($p->produto_preco);
            $csv .= "$p->produto_id|$p->produto_titulo|$p->produto_titulo|$p->produto_preco|new|$baseUri/produto/$p->produto_url|in_stock|{$foto}\t\r\n";
        }
        @header('Content-Type: application/csv; charset=utf-8');
        @header('Content-Disposition: attachment; filename="test.csv"');
        echo $csv;
    }

    public function facebook()
    {
        $csv = "id|title|description|price|condition|link|availability|image_link|brand\t\r\n";
        $prod =  $this->produtos();
        $baseUri = Http::base();
        $base = $baseUri . "/media/produto";
        foreach ($prod as $p) {
            $foto = "{$base}/thumb_{$p->produto_foto}";
            $desc = Filter::cut("$p->produto_desc", 100, '');
            $csv .= "$p->produto_id|$p->produto_titulo|$p->produto_titulo|$p->produto_preco|new|$baseUri/produto/$p->produto_url|in_stock|{$foto}|nobrand\t\r\n";
        }
        @header('Content-Type: application/csv; charset=utf-8');
        @header('Content-Disposition: attachment; filename="test.csv"');
        echo $csv;
    }

    public function instagram()
    {
        $this->facebook();
    }

    public function feed()
    {
        echo "FEED DE PRODUTO <br><br> /feed/google<br> /feed/facebook<br> /feed/instagram";
    }

    public function produtos()
    {
        $prod = (new Factory('produto'))
            ->select('
                produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos, produto_oferta, produto_url, produto_desc, produto_ref,produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto,
				 produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
            ->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
            ->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
            ->where('produto_status = 1')
            ->group_by('produto.produto_id')
            //->order('produto_id DESC LIMIT 8')
            ->get();
        if (isset($prod[0])) {
            foreach ($prod as $k => $v) {
                //$preco = $prod[$k]->produto_preco;
                //$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
                if ($prod[$k]->produto_foto == "") {
                    $prod[$k]->produto_foto = 'nopic.png';
                }
            }
        } else {
            return null;
        }
        return $prod;
    }
}
