<?php
/* Configuração de Rotas Alternativas da Aplicação */
/* ROTEAMENTO URL x Controller <-> Action */
$routes = [

    // ADMIN
    "home" => "Index:indexAction",
    "logout" => "Login:logout",
    "recupera-senha" => "Login:recupera_senha",
    "muda-senha" => "AreaCliente:muda_senha",
    "login-admin" => "Login:indexAction",

    // ORDER HOME
    "ordenar-home" => "OrdenarHome:indexAction",

    //    BLOG ADMIN
    "blog-lista" => "BlogAdmin:indexAction",
    "blog-novo-post" => "BlogAdmin:novo",
    "blog-editar-post" => "BlogAdmin:editar",
    "blog-categoria" => "BlogAdmin:categoria",

    //    FAQ ADMIN
    "faq-lista" => "FaqAdmin:indexAction",
    "faq-novo-post" => "FaqAdmin:novo",
    "faq-editar-post" => "FaqAdmin:editar",
    "faq-categoria" => "FaqAdmin:categoria",

    //    DEPOIMENTO ADMIN
    "depoimento-lista" => "Depoimento:indexAction",
    "depoimento-novo" => "Depoimento:novo",
    "depoimento-editar" => "Depoimento:editar",

    //    SLIDE ADMIN
    "slide-lista" => "Slide:indexAction",
    "slide-novo" => "Slide:novo",
    "slide-editar" => "Slide:editar",

    //    PARCEIRO ADMIN
    "parceiros-lista" => "Parceiros:indexAction",
    "parceiros-novo" => "Parceiros:novo",
    "parceiros-editar" => "Parceiros:editar",

    //    PRODUTO ADMIN
    "produtos-lista" => "ProdutosAdmin:indexAction",
    "produto-novo" => "ProdutosAdmin:novo",
    "produto-editar" => "ProdutosAdmin:editar",
    "produtos-categoria" => "ProdutosAdmin:categoria",
    "produtos-subcategoria" => "ProdutosAdmin:subcategoria",
    "produtos-avaliacoes" => "ProdutosAdmin:avaliacoes",

    //FAVORITOS
    "lista-de-desejos" => 'Favorito:indexAction',

    //      RELATÓRIOS
    "relatorio-acessos" => "ProdutosAdmin:acessos",
    "relatorio-produtos" => "Relatorios:listar_produtos",
    "relatorio-uf" => "Relatorios:totalVendasByYearUf",

    //    ATRIBUTO (PRODUTO) ADMIN
    "produtos-atributos" => "AtributosAdmin:indexAction",
    "produto-atributos-itens" => "AtributosAdmin:item",

    //    PAGINA ADMIN
    "pagina-lista" => "PaginaAdmin:indexAction",
    "nova-pagina" => "PaginaAdmin:novo",
    "editar-pagina" => "PaginaAdmin:editar",
    "pagina-categoria" => "PaginaAdmin:categoria",
    "pagina-subcategoria" => "PaginaAdmin:subcategoria",

    // GATEWAYS DE PAGAMENTO
    "pagamento" => "Gateway:indexAction",

    // FRETE
    //"frete" => "Frete:indexAction",  
    "retirada" => "Frete:retirada",
    "retirada-novo" => "Frete:retirada_novo",
    "retirada-editar" => "Frete:retirada_editar",
    // Rotas de frete por faixa de CEP
    "faixa-cep" => "Frete:faixa",
    "faixa-novo" => "Frete:faixa_novo",
    "faixa-editar" => "Frete:faixa_editar",
    // Rotas de frete por bairro/cidade/uf
    "frete-diferenciado" => "Frete:diferenciado",
    "frete-diferenciado-novo" => "Frete:diferenciado_novo",
    "frete-diferenciado-editar" => "Frete:diferenciado_editar",

    "frete-rastreio" => "FreteFront:rastreio",


    // CUPONS
    "cupom" => "Cupom:indexAction",
    "cupom-novo" => "Cupom:novo",
    "cupom-editar" => "Cupom:editar",

    // PEDIDOS
    "pedidos" => "Pedido:indexAction",
    "ver-pedido" => "Pedido:visualizar",
    "campos" => "CamposExtras:indexAction",

    // MARCAS
    "marcas" => "Marca:indexAction",

    // ENDEREÇOS
    "endereco-listar" => "Endereco:indexAction",
    "endereco-novo" => "Endereco:novo",
    "endereco-editar" => "Endereco:editar",

    //    PAGINA TEMPLATE
    "pagina" => "Pagina:ver",

    // COMMON
    "baixar-produto" => "Common:download_produto",

    // Loja
    "produto" => "ProdutosFront:viewProduto",
    "produto-detalhes" => "ProdutosFront:viewProduto",
    "busca-categoria" => "TelasPesquisa:indexAction",
    "busca-marca" => "TelasPesquisa:indexAction",
    "busca-valor" => "TelasPesquisa:valor",
    "busca-termo" => "TelasPesquisa:indexAction",

    "login-cliente" => "ClienteFront:viewLogin",
    "area-cliente" => "ClienteFront:indexAction",
    "adicionar-endereco" => "ClienteFront:viewNovoEndereco",
    "editar-endereco" => "ClienteFront:viewEditarEndereco",
    "cliente-recupera-senha" => "Index:viewRecuperaSenha",

    "pedido-detalhes" => "PedidoFront:indexAction",
    "pedido-pagar-pix" => "PedidoFront:pagarPix",
    "pedido-imprimir" => "PedidoFront:imprimirPedido",
    "pedido-imprimir-admin" => "Pedido:imprimirPedido",
    "anexar-comprovante" => "PedidoFront:anexarComprovante",
    "feed" => "CatalogoXml:indexAction",
    // SITEMAP
    "sitemap" => "Sitemap:indexAction"
];

/* URLS IGNORADAS PELO LOADER/GETROUTE/REGISTRY */
$ignore = ["page"];

/*PATHS OPCIONAIS*/
$paths = ['fotos' => DIRECTORY_SEPARATOR . 'media' . DIRECTORY_SEPARATOR . 'foto'];
