<?php 

use PHPImager\Watermarker;
use PHPImager\ImageResizer;

Class Thumb{

    public function indexAction(){
        $file = (isset($_GET['f']) && !empty($_GET['f']))? $_GET['f'] : 'foto.jpg';
        $marca = (isset($_GET['m']))? $_GET['m'] : 'marca.png';
        $path = "midias".DIRECTORY_SEPARATOR;
        $pathPic = $path.DIRECTORY_SEPARATOR."fotos".DIRECTORY_SEPARATOR.$file;     
        if(!file_exists($pathPic)){
            $pathPic = $path.DIRECTORY_SEPARATOR."fotos".DIRECTORY_SEPARATOR."sem-foto.png";
        }
        $pathMarca = $path.DIRECTORY_SEPARATOR."marca".DIRECTORY_SEPARATOR.$marca;
        $watermark = new Watermarker($pathPic, $pathMarca);
        return $watermark
        ->setSize(150,94)
        ->setResize(350, 280)
        ->addWatermark();        
    }

    public function lightbox(){
        $file = (isset($_GET['f']) && !empty($_GET['f']))? $_GET['f'] : 'foto.jpg' ;
        $marca = (isset($_GET['m']))? $_GET['m'] : 'marca.png';
        $path = "midias".DIRECTORY_SEPARATOR;
        $pathPic = $path.DIRECTORY_SEPARATOR."fotos".DIRECTORY_SEPARATOR.$file;
        $pathMarca = $path.DIRECTORY_SEPARATOR."marca".DIRECTORY_SEPARATOR.$marca;
        $watermark = new Watermarker($pathPic, $pathMarca);
        return $watermark->setResize(800, 600)->addWatermark();        
    }  


    public function resize(){
        $file = (isset($_GET['f']) && !empty($_GET['f']))? $_GET['f'] : 'foto.jpg' ;
        $w = (isset($_GET['w']))? intval($_GET['w']) : 400;
        $h = (isset($_GET['h']))? intval($_GET['h']) : 300;
        $pathPic = "media".DIRECTORY_SEPARATOR."produto".DIRECTORY_SEPARATOR.$file;
        if(!file_exists($pathPic)){
             $path = "media".DIRECTORY_SEPARATOR;
            $pathPic = $path.DIRECTORY_SEPARATOR."produto".DIRECTORY_SEPARATOR."sem-foto.png";
        }        
        $thumb = new ImageResizer($pathPic, $w, $h, false);
        return $pathPic;
    }     

    public function slide(){
        $file = (isset($_GET['f']) && !empty($_GET['f']))? $_GET['f'] : 'slide-padrao.jpg' ;
        $w = (isset($_GET['w']))? intval($_GET['w']) : 400;
        $h = (isset($_GET['h']))? intval($_GET['h']) : 300;
        $pathPic = "media".DIRECTORY_SEPARATOR."slides".DIRECTORY_SEPARATOR.$file;
        if(!file_exists($pathPic)){
             $path = "media".DIRECTORY_SEPARATOR;
            $pathPic = $path.DIRECTORY_SEPARATOR."slides".DIRECTORY_SEPARATOR."slide-padrao.jpg";
        }        
        $thumb = new ImageResizer($pathPic, $w, $h, false);
        return $pathPic;
    }      

}