<?php

class Sitemap
{

    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }


    public function indexAction()
    {
        $produtos = (new Factory('produto'))
            ->select("produto_url")
            ->get();
        
        if(isset($produtos[0])) {
            // Gera o XML do sitemap
            $produtos_xml = '';
            $baseUri = Http::base();
            foreach ($produtos as $prod) {
                $produtos_xml .= '
                <url>
                    <loc>' . $baseUri . '/produto/' . $prod->produto_url . '</loc>
                    <lastmod>' . date('Y-m-d H:i:s') . '</lastmod>
                    <changefreq>daily</changefreq>
                    <priority>0.95</priority>
                </url>';
            }
            $xml = '<?xml version="1.0" encoding="UTF-8"?>
            <urlset
                xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
                http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
                <url>
                    <loc>' . $baseUri . '</loc>
                    <lastmod>' . date('Y-m-d H:i:s') . '</lastmod>
                    <changefreq>daily</changefreq>
                    <priority>1.00</priority>
                </url>
                '. $produtos_xml .'
            </urlset>
                ';
            header("Content-type: text/xml");
            echo $xml;
        }     
    }
}
