<?php
class PedidoFront
{

    public $config = null;

    public function __construct()
    {
        (new Install)->check_tabelas_principais();
        $this->config = (new Config)->get();
    }

    public function indexAction()
    {
        if (Session::client_node('uid') == null) {
            $pedido_id = Http::get_in_params('pedido-detalhes', 'int');
            if (isset($pedido_id->value) && intval($pedido_id->value) > 0) {
                $_SESSION['produto_detalhes_logar'] = $pedido_id->value;
                Http::redirect_to("/login-cliente/");
            } else {
                Http::redirect_to("/login-cliente/");
            }
        }
        $pedido_id = Http::get_in_params('pedido-detalhes', 'int');
        if (isset($pedido_id->value) && intval($pedido_id->value) > 0) {
            $pedido_id = $pedido_id->value;
            $res = (new Factory('pedido'))
                ->select('pedido_id')
                ->where("pedido_id = " . $pedido_id . " AND pedido_cliente = " . Session::client_node('uid'))
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $deposito = (new Factory('pay'))->find(3); // Informações de Depósito
                $data = [
                    // Menu Superior
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'pedido' => $res[0],
                    'pedido_id' => $pedido_id,
                    'deposito_texto' => $deposito->pay_texto,
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social', 'pedido'],
                ];
                Tpl::view("tema.loja.pedido.index", $data, 1);
            } else {
                $data = [
                    // Menu Superior
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social'],
                ];
                Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
            }
        } else {
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'mapper' => ['config', 'social'],
            ];
            Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
        }
    }

    public function imprimirPedido()
    {
        $pedido_id = Http::get_in_params('pedido-imprimir', 'int');
        if (isset($pedido_id->value) && intval($pedido_id->value) > 0) {
            $pedido_id = $pedido_id->value;
            $res = (new Factory('pedido'))
                ->select('pedido_id')
                ->where("pedido_id = " . $pedido_id . " AND pedido_cliente = " . Session::client_node('uid'))
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $data = [
                    'config' => (new Config)->get(),
                    'pedido_id' => $pedido_id,
                    'mapper' => ['config', 'social'],
                ];
                Tpl::view("tema.loja.pedido.print", $data, 1);
            } else {
                echo 'Page de error de pedido nao encontrado';
                $data = [
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social'],
                ];
                Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
            }
        } else {
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'mapper' => ['config', 'social'],
            ];
            Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
        }
    }

    public function pagarPix()
    {
        if (Session::client_node('uid') == null) {
            Http::redirect_to('/login-cliente');
            exit;
        }
        $pedido_id = Http::get_in_params('pedido-pagar-pix', 'int');
        if (isset($pedido_id->value) && intval($pedido_id->value) > 0) {
            $pedido_id = $pedido_id->value;
            $res = (new Factory('pedido'))
                ->select('pedido_id,pedido_pix_qr,pedido_pix_qr_img,pedido_pay_url')
                ->where("pedido_id = " . $pedido_id . " AND pedido_info = 'pix'  AND pedido_cliente = " . Session::client_node('uid'))
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $deposito = (new Factory('pay'))->find(3); // Informações de pix
                $data = [
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'pedido' => $res[0],
                    'pedido_id' => $pedido_id,
                    'deposito_texto' => $deposito->pay_texto,
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social', 'pedido'],

                ];
                Tpl::view("tema.loja.pedido.pedido-pagar-pix", $data, 1);
            } else {
                //echo 'Page de error de pedido nao encontrado';
                $data = [
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social'],
                ];
                Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
            }
        } else {
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                'msg_erro' => "Desculpe, não foi possível encontrar este pedido.",
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'mapper' => ['config', 'social'],
            ];
            Tpl::view("tema.loja.pedido.page_not_found", $data, 1);
        }
    }

    public function getPedidoDetalhes()
    {
        if (Session::client_node('uid') == null) {
            Http::redirect_to('/login-cliente');
            exit;
        }
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $res = (new Factory('pedido'))
                ->select("*,pedido_pix_qr_img,pedido_pix_qr,pedido_comprovante,pedido_comprovante, pedido_pay_url, pedido_barcode, pedido_obs, pedido_info, pedido_status, pedido_pay_meio, pedido_endereco, pedido_frete,pedido_total_frete, pedido_total_produto, pedido_total_parcelado, pedido_prazo, pedido_cupom_desconto, DATE_FORMAT(pedido_created, '%d/%m/%Y') AS pedido_data, pedido_tipo,
            CASE pedido_status
                WHEN 1 THEN 'Aguardando Pagamento'
                WHEN 2 THEN 'Em análise'
                WHEN 3 THEN 'Aprovado'
                WHEN 4 THEN 'Disponível'
                WHEN 5 THEN 'Em disputa'
                WHEN 6 THEN 'Devolvido'
                WHEN 7 THEN 'Cancelado'            
                END AS pedido_status_nome,
            CASE pedido_status
                WHEN 1 THEN 'warning'
                WHEN 2 THEN 'info'
                WHEN 3 THEN 'success'
                WHEN 4 THEN 'success'
                WHEN 5 THEN 'warning'
                WHEN 6 THEN 'danger'
                WHEN 7 THEN 'danger'            
            END AS pedido_status_badge,
            DATE_FORMAT(pedido_updated, '%d/%m/%Y às %H:%i:%s') AS pedido_atualizacao,
            DATE_FORMAT(DATE_ADD(pedido_created, interval pedido_prazo day), '%d/%m/%Y') AS pedido_data_entrega")
                ->where("pedido_id = " . $id . " AND pedido_cliente = " . Session::client_node('uid'))
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $res = $res[0];
                $res->pedido_total_parcelado = $res->pedido_total_parcelado;
                if (isset($res->pedido_prazo) && intval($res->pedido_prazo) > 0) {
                    // teve frete, busca o endereçeo co cliente
                    $result = (new Factory('endereco_cliente'))
                        ->select('endereco_cliente_id, endereco_cliente_cep, endereco_cliente_rua, endereco_cliente_uf, endereco_cliente_num, endereco_cliente_complemento, endereco_cliente_cidade, endereco_cliente_titulo')
                        ->where('endereco_cliente_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->pedido_endereco_cliente = $result[0];
                    }
                } else {
                    // não teve frete, busca endereçeo de retyirada
                    $result = (new Factory('retirada'))
                        ->select('retirada_local, retirada_horario, retirada_rua, retirada_num, retirada_complemento, retirada_bairro, retirada_cidade, retirada_uf, retirada_cep, retirada_telefone')
                        ->where('retirada_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->retirada = $result[0];
                    }
                }
                $lista = (new Factory('lista_pedido'))
                    ->select('lista_pedido_id, lista_pedido_produto_titulo, lista_pedido_preco, lista_pedido_qtde, lista_pedido_foto')
                    ->where('lista_pedido_pedido = ' . $id)
                    ->get();
                if (isset($lista) && !empty($lista) && is_array($lista) && sizeof($lista) > 0) {
                    $res->lista = $lista;
                    //procura pelos atributos dos produtos
                    foreach ($res->lista as $l) {
                        $att = (new  Factory('lista_pedido_atributo'))
                            ->where('lista_pedido_atributo_lista = ' . $l->lista_pedido_id)
                            ->get();
                        if (isset($att[0]) && !empty($att[0])) {
                            $l->atributos = $att;
                        }
                    }
                    echo json_encode($res);
                }
            } else {
                echo json_encode(['error' => 'Nenhum pedido encontrado']);
            }
        } else {
            echo json_encode(['error' => 'Id não informado ou inválido']);
        }
    }

    /**Metodo para pegar os dados do pedido para ser enviado o email*/
    public function get_pedidos_mail_data($id, $cliente_id)
    {
        $pedido = null;
        $format = [
            'pedido_total_parcelado' => 'money',
            'pedido_total_produto' => 'money',
            'pedido_total_frete' => 'money',
        ];
        $res = (new Factory('pedido'))
            ->select("*, DATE_FORMAT(pedido_created, '%d/%m/%Y') AS pedido_data, pedido_tipo,
        DATE_FORMAT(pedido_updated, '%d/%m/%Y às %H:%i:%s') AS pedido_atualizacao,
        DATE_FORMAT(DATE_ADD(pedido_created, interval pedido_prazo day), '%d/%m/%Y') AS pedido_data_entrega")
            ->format($format)
            ->where("pedido_id = " . $id . " AND pedido_cliente = " . $cliente_id)
            ->get();
        if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
            $res = $res[0];

            if ($res->pedido_total_parcelado <= 0 || $res->pedido_total_parcelado == null || $res->pedido_total_parcelado == '') {
                $res->pedido_total_parcelado = $res->pedido_total_produto;
            }

            if (isset($res->pedido_prazo) && intval($res->pedido_prazo) > 0) {
                // teve frete, busca o endereçeo co cliente
                $result = (new Factory('endereco_cliente'))
                    ->select('endereco_cliente_id, endereco_cliente_cep, endereco_cliente_rua, endereco_cliente_uf, endereco_cliente_num, endereco_cliente_complemento, endereco_cliente_cidade, endereco_cliente_titulo')
                    ->where('endereco_cliente_id = ' . $res->pedido_endereco)
                    ->get();
                if (isset($result[0])) {
                    $res->pedido_endereco_cliente = $result[0];
                }
            } else {
                // não teve frete, busca endereçeo de retyirada
                $result = (new Factory('retirada'))
                    ->select('retirada_local, retirada_horario, retirada_rua, retirada_num, retirada_complemento, retirada_bairro, retirada_cidade, retirada_uf, retirada_cep, retirada_telefone')
                    ->where('retirada_id = ' . $res->pedido_endereco)
                    ->get();
                if (isset($result[0])) {
                    $res->retirada = $result[0];
                }
            }
            $lista = (new Factory('lista_pedido'))
                ->select('lista_pedido_id, lista_pedido_produto_titulo, lista_pedido_preco, lista_pedido_qtde, lista_pedido_foto')
                ->where('lista_pedido_pedido = ' . $id)
                ->get();
            if (isset($lista) && !empty($lista) && is_array($lista) && sizeof($lista) > 0) {
                $res->lista = $lista;

                //procura pelos atributos dos produtos
                foreach ($res->lista as $l) {
                    $att = (new  Factory('lista_pedido_atributo'))
                        ->where('lista_pedido_atributo_lista = ' . $l->lista_pedido_id)
                        ->get();
                    if (isset($att[0]) && !empty($att[0])) {
                        $l->atributos = $att;
                    }
                }
                $pedido = $res;
            }
        }

        return ($pedido) ? $pedido : 0;
    }

    public function anexarComprovante()
    {
        if (Session::client_node('uid') == null) {
            Http::redirect_to('/login-cliente');
            exit;
        }
        if (isset($_FILES['fileComprovante']) && !empty($_FILES['fileComprovante'])) {
            $file = $_FILES['fileComprovante'];

            $media = Media::file_upload($file, 'documentos');

            if (!empty($media)) {
                $comprovante = $media->name;
                $id = Req::post('pedido_id', 'int');
                if (intval($id) > 0) {
                    $excluir = (new Factory('pedido'))->select('pedido_comprovante as url')->find($id);
                    $path = Path::base() . "/media/documentos/$excluir->url";
                    if (file_exists($path)) {
                        @unlink($path);
                    }

                    // Salva o novo
                    $with = [
                        'pedido_id' => $id,
                        'pedido_comprovante' => $comprovante
                    ];
                    (new Factory('pedido'))->with($with)->save();
                    Http::redirect_to('/pedido-detalhes/' . $id . '/?success');
                }
            }
        }
    }


    public function get_pedido_status()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $res = (new Factory('pedido'))
                ->select("pedido_status")
                ->where("pedido_id = " . $id . " AND pedido_cliente = " . Session::client_node('uid'))
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                echo $res[0]->pedido_status;
            } else {
                echo 0;
            }
        }
    }
}
