<?php

function faturaMP($mp_data, $pedido_id, $pedido_total){
    // captura os itens e monta o array para enviar para o mp
    $itens_p = array();
    $items_mp = array();
    $itens = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $pedido_id)->get();
    if (isset($itens) && !empty($itens)) {
        foreach ($itens as $item) {
            $item->lista_pedido_preco = preg_replace('/\,/', '', $item->lista_pedido_preco);
            $titulo = substr($item->lista_pedido_produto_titulo, 0, 30);
            $itens_p["id"] = $item->lista_pedido_produto;
            $itens_p["title"] = ("$titulo");
            $itens_p["quantity"] = $item->lista_pedido_qtde;
            $itens_p["description"] = ("$item->lista_pedido_produto_titulo");
            $itens_p["category_id"] = 'Produtos';
            $itens_p["unit_price"] = $item->lista_pedido_preco;
            $items_mp[] = $itens_p;
        }
    }
    $endereco = null;
    if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
        $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
    } else {
        $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    }
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;
    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' ';
    if(isset($cliente->cliente_telefone) && !empty($cliente->cliente_telefone)){
        $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    }else{
        $cliente->telefone = preg_replace('/\W/', '', '');
    }
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);
    if (isset($_POST['cardholderName']) && !empty($_POST['cardholderName'])) {
        $cliente_full = explode(' ', $_POST['cardholderName']);
        if (isset($cliente_full[0]) && !empty($cliente_full[0])) {
            $cliente_nome = $cliente_full[0];
        } else {
            $cliente_nome = '';
        }
        if (isset($cliente_full[1]) && !empty($cliente_full[1])) {
            $cliente_sobrenome = $cliente_full[1];
        } else {
            $cliente_sobrenome = '';
        }
    }
    if (isset($_POST['docNumberFake']) && !empty($_POST['docNumberFake'])) {
        $cli_doc_num = $_POST['docNumberFake'];
        $cli_doc_num = str_replace('.', '', $cli_doc_num);
        $cli_doc_num = str_replace('-', '', $cli_doc_num);
        $cli_doc_num = str_replace('/', '', $cli_doc_num);
        $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    } else {
        $cli_doc_num = '';
        $cli_tipo_doc = '';
    }
    $_mpago = $mp_data;
    $retorno = get_mp_notification_url();
    $token = str_replace(' ', '', trim($_mpago->pay_user));
    $payment = [];
    $payment['token'] = $token;
    $payment['transaction_amount'] = floatval(number_format($pedido_total, '2', '.', ''));
    $payment['external_reference'] = $pedido_id;
    if ($_SERVER['HTTP_HOST'] == 'localhost') {
        $payment['notification_url'] = "http://fluxshop.com.br/";
    } else {
       $payment['notification_url'] = "$retorno";
    }
    $payment['token'] = $_POST['card_token'];
    $payment['description'] = "Compra de produtos ref.: $pedido_id";
    $payment['installments'] = intval($_POST['card_parcela']);
    $payment['payment_method_id'] = $_POST['paymentMethodId'];
    $payment['payer'] = [
        //'operator_id' => '1',
        "email" => "$cliente_email",
        "first_name" => "$cliente_nome",
        "last_name" => "$cliente_sobrenome",
        "address" => [
            'zip_code' => "$cli_zip",
            'street_name' => "$cli_rua",
            'street_number' => "$cli_num",
        ],
        "identification" => [
            'type' => "$cli_tipo_doc",
            'number' => "$cli_doc_num",
        ],
    ];
    $payment['additional_info'] = [
        'items' => $items_mp,
        'payer' => [
            // "email" => "$cliente_email",
            "first_name" => "$cliente_nome",
            "last_name" => "$cliente_sobrenome",
            "address" => [
                'zip_code' => "$cli_zip",
                'street_name' => "$cli_rua",
                'street_number' => "$cli_num",
            ],
            'phone' => [
                'area_code' => "$cliente->ddd",
                'number' => "$cliente->telefone",
            ],
        ],
        'shipments' => [
            'receiver_address' => [
                'zip_code' => "$cli_zip",
                'street_name' => "$cli_rua",
                'street_number' => "$cli_num",
            ],
        ],
    ];
    $payment = json_encode($payment);
    $url = 'https://api.mercadopago.com/v1/payments?access_token=' . $token;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "$payment");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        return curl_error($ch);
    } else {
        $result = json_decode($result);
        return $result;
    }
}

function faturaMPBoleto($mp_data, $pedido_id, $pedido_total)
{
    $dia_qtd = (new Factory('pay'))->where('pay_name = "Config"')->get()[0]->pay_c1;
    //o prazo final nao pode ultrapassar 28 dias
    $dia_qtd = ($dia_qtd <= 28) ? $dia_qtd : 28;
    $hoje = date('y-m-d');
    $vencimento_util =  date('Y-m-d', strtotime("$hoje + $dia_qtd day"));
    $dia_semana = intval(date('w', strtotime($vencimento_util)));
    //se for sabado adiciona +2 dias no qtde_day
    if ($dia_semana == 6) {
        $dia_qtd = intval($dia_qtd) + 2;
    }
    //se for domingo adiciona +1 dia no qtde_day
    if ($dia_semana == 0) {
        $dia_qtd = intval($dia_qtd) + 1;
    }
    $vencimento =  date('Y-m-d', strtotime("$hoje + $dia_qtd day"));
    $_mpago = $mp_data;
    $retorno = get_mp_notification_url();
    $token = str_replace(' ', '', trim($_mpago->pay_user));
    $itens_p = [];
    $items_mp = [];
    $itens = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $pedido_id)->get();
    if (isset($itens) && !empty($itens)) {
        foreach ($itens as $item) {
            $item->lista_pedido_preco = preg_replace('/\,/', '', $item->lista_pedido_preco);
            $titulo = substr($item->lista_pedido_produto_titulo, 0, 30);
            $itens_p["id"] = $item->lista_pedido_produto;
            $itens_p["title"] = ("$titulo");
            $itens_p["quantity"] = $item->lista_pedido_qtde;
            $itens_p["description"] = ("$item->lista_pedido_produto_titulo");
            $itens_p["category_id"] = 'Produtos';
            $itens_p["unit_price"] = $item->lista_pedido_preco;
            $items_mp[] = $itens_p;
        }
    }
    $endereco = (new Factory('endereco_cliente'))
    ->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;
    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' '; 
    if(isset($cliente->cliente_telefone) && !empty($cliente->cliente_telefone)){
        $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    }else{
        $cliente->telefone = preg_replace('/\W/', '', '');
    } 
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);
    if ($cliente->cliente_cpf) {
        $cli_doc_num = $cliente->cliente_cpf;
        $cli_doc_num = str_replace('.', '', $cli_doc_num);
        $cli_doc_num = str_replace('-', '', $cli_doc_num);
        $cli_doc_num = str_replace('/', '', $cli_doc_num);
        $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    } else {
        $cli_doc_num = '';
        $cli_tipo_doc = '';
    }
    $payment = new stdClass();
    $payment->transaction_amount = $pedido_total;
    $payment->external_reference = $pedido_id;
    if ($_SERVER['HTTP_HOST'] == 'localhost') {
        $payment->notification_url = "http://fluxshop.com.br/";
    } else {
            $payment->notification_url = "$retorno";
    }
    $payment->description = "Compra de produtos ref.: $pedido_id";
    $payment->payment_method_id = "bolbradesco";
    $payment->payer = array(
        "email" => "$cliente_email",
        "first_name" => "$cliente_nome",
        "last_name" => "$cliente_sobrenome",
        "identification" => array(
            'type' => "$cli_tipo_doc",
            'number' => "$cli_doc_num",
        ),
        "address" => array(
            "zip_code" => addslashes("$endereco->endereco_cliente_cep"),
            "street_name" => addslashes("$endereco->endereco_cliente_rua"),
            "street_number" => addslashes("$endereco->endereco_cliente_num"),
            "neighborhood" => addslashes("$endereco->endereco_cliente_bairro"),
            "city" => addslashes("$endereco->endereco_cliente_cidade"),
            "federal_unit" => addslashes("$endereco->endereco_cliente_uf")
            )
        );

    //SE ATENTAR AOS ULTIMOS DIGITOS DEPENDENDO POR AVANÇAR UM DIA
    $payment->date_of_expiration = $vencimento."T23:59:59.000-02:00";
    $url = 'https://api.mercadopago.com/v1/payments?access_token=' . $token;    
    $payment = json_encode($payment);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "$payment");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        $erro = curl_error($ch);
    } else {
        $result = json_decode($result);
        return $result;
    }
}
        
function faturaMPPix($mp_data, $pedido_id, $pedido_total){
    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $data = [
        'pedido_id' => $pedido_id,
        'cliente_nome' => $cliente->cliente_nome,
        'cliente_cpf' => $cliente->cliente_cpf,
        'cliente_email' => $cliente->cliente_email,
        "pedido_total" => floatval($pedido_total),
        'cliente_tel' => ''
    ];
    if(empty($cliente->cliente_telefone)){
       $cliente->cliente_telefone = '11999999888';
    }
    $cliente_nome_full = explode(" ", $cliente->cliente_nome);    
    $cliente_nome_pri = $cliente_nome_full[0];   
    unset($cliente_nome_full[0]); 
    $cliente_nome_sobre = implode(" ", $cliente_nome_full);
    $cliente_doc = $cliente->cliente_cpf;
    $cliente_email = $cliente->cliente_email;
    $telefone = preg_replace('/\D/', '', $cliente->cliente_telefone);
    $ddd = substr($telefone, 0, 2);
    $fone = substr($telefone, 2); 
    $payment_data = [
        "transaction_amount" => $pedido_total,
        //"description" => "COMPRA LOJA $sistema_titulo  - Ref: {$pedido_id}",
        "description" => "Compra de produtos ref. $pedido_id",
        "external_reference" => $pedido_id,
        "payment_method_id" => "pix",
        "payer" => [
            "entity_type" => "individual",
            "type" => "customer",
            "email" => "$cliente_email",
            "identification" => ["type" => "CPF", "number" => $cliente_doc],
        ],
        "additional_info" => [
            "payer" => [
                "first_name" => "$cliente_nome_pri",
                "last_name" => "$cliente_nome_sobre",
                "phone" => [
                    "area_code" => "$ddd",
                    "number" => "$fone",
                ],
            ],
        ],
        'notification_url' => get_mp_notification_url(),
    ];
    $MP_TOKEN = get_mp_token();
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.mercadopago.com/v1/payments');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payment_data));
    $headers = array();
    $headers[] = 'Authorization: Bearer ' . $MP_TOKEN;
    $headers[] = 'X-Idempotency-Key:  ' . $pedido_id;    
    $headers[] = 'Content-Type: application/x-www-form-urlencoded';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $payment = curl_exec($ch);
    $payment = json_decode($payment);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);
    if (isset($payment->point_of_interaction->transaction_data->qr_code)) {
        $qr_copy = $payment->point_of_interaction->transaction_data->qr_code;
        $qr_im = $payment->point_of_interaction->transaction_data->qr_code_base64;
        return (object) [
            'result' => 1, 
            'id' => $payment->id,
            'url' => $payment->point_of_interaction->transaction_data->ticket_url,
            'qr' => $qr_copy, 
            'img' => $qr_im, 
            'pedido' => $pedido_id, 
            'info' => 'pix gerado'
        ];
    } else {
        return (object) ['result' => 0, 'pay' => $payment, 'info' => 'erro ao gerar pix - entre em contato conosco'];
    }        
}
function get_mp_token() {
    $gateway = (new Factory('pay'))->find(6);
    $MP_TOKEN = $gateway->pay_user;
    return $MP_TOKEN;
}

function get_mp_notification_url() {
    return Http::base() . "/notificacao/mercadopago/";
}
