<?php

class Integracao
{
    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {

    }

    public function bling(){
        $data = [
            'config' => (new Config)->get(),
            'bling' => Bling::get_credenciais(),
            'mapper' => ['config','bling']
        ];
        Tpl::view('admin.integracoes.bling.index', $data, 1); 
    }




    
	public function migrate() {
        //BLING PRODUTO MIGRATE
		$columns = [
			['name' => 'class_fiscal', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'tipo_unidade', 'type' => 'VARCHAR(20)', 'default' => '"UN"'],
		];
		(new DB)->add_columns('produto', $columns);

        //BLING PEDIDO MIGRATE
		$columns = [
            ['name' => 'nf_status', 'type' => 'int', 'default' => '0'],
			['name' => 'nf_num_id', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_serie', 'type' => 'int', 'default' => '0'],
            ['name' => 'nf_num', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_chave', 'type' => 'VARCHAR(200)', 'default' => '""'],
		];
		(new DB)->add_columns('pedido', $columns);
	}

    public function integracao_create() {
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'gw', 'type' => 'varchar(20)'],
            ['name' => 'ativo', 'type' => 'int', 'default' => '0'],
			['name' => 'secret', 'type' => 'longtext'],
			['name' => 'client_id', 'type' => 'longtext'],
			['name' => 'token', 'type' => 'longtext'],
			['name' => 'refresh_token', 'type' => 'longtext'],
			['name' => 'data_refresh_token', 'type' => 'date'],
		];
        
		$seed = [
			'integracao_gw' => 'Bling',
			'integracao_secret' => 'secret',
			'integracao_client_id' => 'client_id',
		];
		(new DB)->drop_table("integracao");
		(new DB)->create_table('integracao', $columns, $seed);
	}
} 