<?php

class Importacao
{
	public $host;
	public $base;
	public $port;
	public $user;
	public $pass;
	public $con;
	public $sql;
	public $data;
	public $query;
	public $res;
	public $db_reset = true;
	public $loja_v3_dir;

	public function query($sql)
	{
		$this->res = $this->con->prepare($sql) or die(print_r($this->con->errorInfo()[2], true));
		return $this->res->execute();
	}

	public function fetch($sql = null)
	{
		if ($sql != null) {
			$this->query = $sql;
		}
		$this->res = $this->con->prepare($this->query) or die(print_r($this->con->errorInfo()[2], true));
		$this->res->execute();
		$this->data = $this->res->fetchAll(PDO::FETCH_OBJ);
		return $this->data;
	}

	public function __construct()
	{
		//Dados de conexao V3
		$this->host = "localhost";
		$this->base = "loja";
		$this->user = "loja";
		$this->pass = "lj@";
		$this->port = 3306;
		$this->loja_v3_dir = 'https://lojav3.com.br/';
		//https://loja-v4.com.br/importacao/
		try {
			$this->con = new PDO("mysql:host=$this->host;port=$this->port;dbname=$this->base", $this->user, $this->pass, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));
			$this->con->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, false);
			$this->con->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
			$this->con->exec("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
		} catch (PDOException $e) {
			if ($e->getCode() === 1049) {
				(new Page)->_erro(('Banco de dados [' . $this->base . '] não encontrado! <br> Verifique os dados!'))->_and_stop();
			}
			if ($e->getCode() === 1045) {
				(new Page)->_erro(('Dados de acesso (usuário/senha) ao banco de dados, incorretos!. <br> Verifique os dados'))->_and_stop();
			}
			if ($e->getCode() === 2005) {
				(new Page)->_erro(('Endereço do servidor SQL [' . $this->host . '] incorreto. <br> Verifique o parâmetro "host"'))->_and_stop();
			}
			(new Page)->_erro($e->getMessage())->_and_stop();
		}
	}

	public function indexAction()
	{
		//Tpl::view('admin.importacao');
		self::importar_categorias();
		self::importar_atributos();
		self::importar_produtos();
		self::importar_clientes();
		self::importar_endereco_retirada();
	}

	public function importar_categorias()
	{
		//utiliza o DB para ler os dados da V3
		$categoria = $this->fetch("SELECT * FROM categoria");
		//Filter::pre($categoria);
		//se estiver marcado no form para limpar antes de importar
		if ($this->db_reset == true) {
			(new Factory('categoria_produto'))->where('1 = 1')->drop();
			(new Factory('subcategoria_produto'))->where('1 = 1')->drop();
		}
		//monta array com campos da categoria v4 e valores da categoria v3
		foreach ($categoria as $c) {
			$cat = [
				'categoria_produto_id' => $c->categoria_id,
				'categoria_produto_nome' => $c->categoria_title,
				'categoria_produto_url' => $c->categoria_url,
				'categoria_produto_pos' => $c->categoria_pos,
			];
			//utilza o Factory para inserir na V4
			(new Factory('categoria_produto'))->with($cat)->add();
			//importa subcategorias
			self::importar_subcategorias($c->categoria_id);
		}
	}

	public function importar_subcategorias($categoria)
	{
		//utiliza o DB para ler os dados da V3
		$sub = $this->fetch("SELECT * FROM sub WHERE sub_categoria = $categoria");
		//Filter::pre($sub);
		//monta array com campos da categoria v4 e valores da categoria v3
		foreach ($sub as $s) {
			$itens = [
				'subcategoria_produto_id' => $s->sub_id,
				'subcategoria_produto_nome' => $s->sub_title,
				'subcategoria_produto_pos' => $s->sub_pos,
				'subcategoria_produto_url' => $s->sub_url,
				'subcategoria_produto_categoria' => $s->sub_categoria,
			];
			//utilza o Factory para inserir na V4
			(new Factory('subcategoria_produto'))->with($itens)->add();
		}
	}

	public function importar_atributos()
	{
		//utiliza o DB para ler os dados da V3
		$atributo = $this->fetch("SELECT * FROM atributo");
		//se estiver marcado no form para limpar antes de importar
		if ($this->db_reset == true) {
			(new Factory('atributo'))->where('1 = 1')->drop();
			(new Factory('item_atributo'))->where('1 = 1')->drop();
		}
		if (isset($atributo[0])) {
			foreach ($atributo as $a) {
				$itens = [
					'atributo_id' => $a->atributo_id,
					'atributo_nome' => $a->atributo_nome,
					'atributo_tipo' => 4,
				];

				//utilza o Factory para inserir na V4
				(new Factory('atributo'))->with($itens)->add();

				//importa os itens do atributo pai
				self::importar_atributo_itens($a);
			}
		}
	}

	public function importar_atributo_itens($atributo)
	{
		//utiliza o DB para ler os dados da V3
		$itens_atributo = $this->fetch("SELECT * FROM iattr WHERE iattr_atributo = $atributo->atributo_id");
		//Filter::pre($itens_atributo);

		//monta array com campos da categoria v4 e valores da categoria v3
		if (isset($itens_atributo[0])) {
			foreach ($itens_atributo as $a) {
				$itens = [
					'item_atributo_id' => $a->iattr_id,
					'item_atributo_nome' => $a->iattr_nome,
					'item_atributo_atributo' => $atributo->atributo_id,
				];
				//utilza o Factory para inserir na V4
				(new Factory('item_atributo'))->with($itens)->add();
			}
		}
	}

	public function importar_produtos()
	{
		//utiliza o DB para ler os dados da V3
		$produtos = $this->fetch("SELECT * FROM item");
		//Filter::pre($produtos);
		//se estiver marcado no form para limpar antes de importar
		if ($this->db_reset == true) {
			(new Factory('produto'))->where('1 = 1')->drop();
			(new Factory('produtos_relacionados'))->where('1 = 1')->drop();
			(new Factory('vinculo_categoria_produto'))->where('1 = 1')->drop();
			(new Factory('relacao_atributo'))->where('1 = 1')->drop();
			(new Factory('relacao_item'))->where('1 = 1')->drop();
			(new Factory('foto_produto'))->where('1 = 1')->drop();
		}

		foreach ($produtos as $p) {
			$itens = [
				'produto_id' => $p->item_id,
				'produto_titulo' => $p->item_title,
				'produto_desc' => (!$p->item_desc) ? '' : $p->item_desc,
				'produto_preco' => number_format($p->item_preco, 2, '.', ','),
				'produto_keywords' => $p->item_keywords,
				'produto_url' => $p->item_url,
				'produto_ref' => "$p->item_ref",
				'produto_min_estoque' => $p->item_min_estoque,
				'produto_estoque' => $p->item_estoque,
				'produto_status' => $p->item_show,
				'produto_largura' => $p->item_largura,
				'produto_altura' => $p->item_altura,
				'produto_comprimento' => $p->item_comprimento,
				'produto_peso' => number_format($p->item_peso, 2, '.', ','),
				'produto_oferta' => $p->item_oferta,
				'produto_destaque' => $p->item_destaque,
				'produto_disp' => $p->item_disp,
				'produto_desconto' => number_format($p->item_desconto, 2, '.', ','),
				'produto_calcula_frete' => ($p->item_calcula_frete == 2) ? 1 : 0,
			];

			//utilza o Factory para inserir na V4
			//Filter::pre($itens);
			(new Factory('produto'))->with($itens)->add();

			//Vinculando produto a categoria e a subcategoria
			self::vincular_produto_categoria_sub($p);
			self::importar_produto_fotos($p);
			self::importar_produtos_relacionados($p);
			self::vincular_produto_atributos($p);
		}
	}

	public function vincular_produto_categoria_sub($produto)
	{

		$itens = [
			'vinculo_categoria_produto_categoria' => $produto->item_categoria,
			'vinculo_categoria_produto_subcategoria' => $produto->item_sub,
			'vinculo_categoria_produto_produto' => $produto->item_id,
		];

		(new Factory('vinculo_categoria_produto'))->with($itens)->add();
	}

	public function importar_produto_fotos($produto)
	{
		//utiliza o DB para ler os dados da V3
		$produto_fotos = $this->fetch("SELECT * FROM foto WHERE foto_item = $produto->item_id");
		//Filter::pre($produto_fotos);
		if (isset($produto_fotos[0])) {
			foreach ($produto_fotos as $p) {
				$itens = [
					'foto_produto_id' => $p->foto_id,
					'foto_produto_img' => $p->foto_url,
					'foto_produto_url' => $p->foto_url,
					'foto_produto_pos' => $p->foto_pos + 1,
					'foto_produto_produto' => $produto->item_id,
					'foto_produto_tipo' => 1,
				];
				(new Factory('foto_produto'))->with($itens)->add();
				self::download_foto($p->foto_url);
			}
		}
	}

	public function download_foto($foto)
	{
		//recebe link do site no form do admin
		$site = $this->loja_v3_dir;

		//ex: nome da foto no bd b029ddeff76809c104118f8b916a8048.jpg;
		//monta a url com o caminho absoluto da foto remotadamente
		$url = $site . "app/fotos/$foto";

		//caminho para salvar na nova loja
		$diretorio = Path::base() . '/media/produto/';

		// Obtém o nome do arquivo da URL
		$nomeArquivo = basename($url);

		// Verifica se o diretório existe, se não, cria-o
		if (!is_dir($diretorio)) {
			mkdir($diretorio, 0777, true);
		}
		// Define o caminho completo para o arquivo no diretório
		$caminhoCompleto = $diretorio . $nomeArquivo;

		// Faz o download da imagem
		@file_put_contents($caminhoCompleto, file_get_contents($url));

		// Verifica se o download foi bem-sucedido
		if (file_exists($caminhoCompleto)) {
			// Download da imagem concluído com sucesso
			//echo "download sucesso";
		} else {
			echo "Falha ao fazer o download da imagem";
		}
	}

	public function importar_produtos_relacionados($produto)
	{
		//utiliza o DB para ler os dados da V3
		$produtos_relacionados = $this->fetch("SELECT * FROM relacionado WHERE produto_pai = $produto->item_id");
		//Filter::pre($produtos_relacionados);
		if (isset($produtos_relacionados[0])) {
			foreach ($produtos_relacionados as $p) {
				$itens = [
					'produtos_relacionados_id' => $p->relacionadoid,
					'produtos_relacionados_produto1' => $p->produto_pai,
					'produtos_relacionados_produto2' => $p->produto_relacionado,
				];

				(new Factory('produtos_relacionados'))->with($itens)->add();
			}
		}
	}

	public function importar_clientes()
	{
		//utiliza o DB para ler os dados da V3
		$clientes = $this->fetch("SELECT * FROM cliente");
		//Filter::pre($clientes);

		//se estiver marcado no form para limpar antes de importar
		if ($this->db_reset == true) {
			(new Factory('cliente'))->where('1 = 1')->drop();
			(new Factory('endereco_cliente'))->where('1 = 1')->drop();
			(new Factory('pedido'))->where('1 = 1')->drop();
			(new Factory('lista_pedido'))->where('1 = 1')->drop();
			(new Factory('lista_pedido_atributo'))->where('1 = 1')->drop();
		}

		if (isset($clientes[0])) {

			foreach ($clientes as $c) {
				if (!isset($c->cliente_id) || $c->cliente_id <= 0) return;
				$data_nascimento = explode('/', $c->cliente_datan);
				$itens = [
					'cliente_id' => $c->cliente_id,
					'cliente_nome' => "$c->cliente_nome $c->cliente_sobrenome",
					'cliente_email' => $c->cliente_email,
					'cliente_telefone' => $c->cliente_telefone,
					'cliente_password' => $c->cliente_password,
					'cliente_celular' => $c->cliente_celular,
					'cliente_cpf' => $c->cliente_cpf,
					'cliente_cnpj' => $c->cliente_cnpj,
					'cliente_ie' => "$c->cliente_ie",
					'cliente_contato' => $c->cliente_contato,
					'cliente_tipo' => ($c->cliente_tipo == 'Pessoa Física') ? 1 : 2,
				];

				if (isset($data_nascimento[2]) && is_array($data_nascimento)) {
					$itens['cliente_nascimento'] = $data_nascimento[2] . '-' . $data_nascimento[1] . '-' . $data_nascimento[0];
				}
				(new Factory('cliente'))->with($itens)->add();
				self::importar_cliente_enderecos($c);
				self::importar_pedidos($c);
			}
		}
	}

	public function importar_cliente_enderecos($cliente)
	{
		//utiliza o DB para ler os dados da V3
		$cliente_enderecos = $this->fetch("SELECT * FROM endereco WHERE endereco_cliente = $cliente->cliente_id");
		//Filter::pre($cliente_enderecos);
		if (isset($cliente_enderecos[0])) {
			foreach ($cliente_enderecos as $c) {
				$itens = [
					'endereco_cliente_id' => $c->endereco_id,
					'endereco_cliente_cliente' => $c->endereco_cliente,
					'endereco_cliente_cep' => $c->endereco_cep,
					'endereco_cliente_rua' => $c->endereco_rua,
					'endereco_cliente_uf' => $c->endereco_uf,
					'endereco_cliente_num' => $c->endereco_num,
					'endereco_cliente_complemento' => $c->endereco_complemento,
					'endereco_cliente_cidade' => $c->endereco_cidade,
					'endereco_cliente_bairro' => $c->endereco_bairro,
					'endereco_cliente_tipo' => ($c->endereco_tipo == 1) ? $c->endereco_tipo : 0,
					'endereco_cliente_titulo' => $c->endereco_title,
				];

				(new Factory('endereco_cliente'))->with($itens)->add();
			}
		}
	}

	public function importar_pedidos($cliente)
	{
		$pedidos = $this->fetch("SELECT * FROM pedido WHERE pedido_cliente = $cliente->cliente_id");
		//Filter::pre($pedidos);exit;

		if (isset($pedidos[0])) {
			foreach ($pedidos as $p) {
				$data_hora_created = explode(' ', $p->pedido_data);
				$data_hora_updated = explode(' ', $p->pedido_data);

				$itens = [

					'pedido_id' => $p->pedido_id,
					'pedido_cliente' => $p->pedido_cliente,

					'pedido_endereco' => $p->pedido_endereco,
					'pedido_entrega' => ($p->pedido_entrega == 1) ? 1 : 0,
					'pedido_obs' => "$p->pedido_obs",
					'pedido_updated' => $p->pedido_update,

					'pedido_status' => $p->pedido_status,
					'pedido_total_frete' => $p->pedido_frete,
					'pedido_frete' => $p->pedido_frete,
					'pedido_prazo' => ($p->pedido_prazo && !ctype_space($p->pedido_prazo)) ? 1 : 0,

					'pedido_pay_situacao' => $p->pedido_pay_situacao,
					'pedido_pay_gw' => $p->pedido_pay_gw,
					'pedido_pay_code' => "$p->pedido_pay_code",
					'pedido_pay_url' => "$p->pedido_pay_url",

					'pedido_pay_meio' => "$p->pedido_pay_meio",
					'pedido_pay_obs' => "$p->pedido_pay_obs",

					'pedido_cupom_alfa' => "$p->pedido_cupom_alfa",
					'pedido_cupom_info' => $p->pedido_cupom_info,

					'pedido_total_produto' => $p->pedido_total_produto,
					'pedido_codigo_rastreio' => "$p->pedido_codigo_rastreio",

					'pedido_total_parcelado' => (!$p->pedido_total_parcelado) ? ($p->pedido_total_produto - $p->pedido_cupom_desconto) + $p->pedido_frete : $p->pedido_total_parcelado,
				];

				//Se não tiver desconto o campo tem que ser null
				if (isset($p->pedido_cupom_desconto) && !empty($p->pedido_cupom_desconto) && $p->pedido_cupom_desconto != 0) {
					$itens['pedido_cupom_desconto'] = "R$ $p->pedido_cupom_desconto";
				}

				//Se não tiver comprovante o campo tem que ser null
				if (isset($p->pedido_comprovante) && !empty($p->pedido_comprovante) && !ctype_space($p->pedido_comprovante)) {
					$itens['pedido_comprovante'] = "$p->pedido_comprovante";
				}

				//Inserindo a forma de pagamento do pedido
				if (isset($p->pedido_pay_code) && ($p->pedido_pay_code == 'pix' || $p->pedido_pay_code == 'deposito')) {
					$itens['pedido_info'] = 'deposito';
				} else if (isset($p->pedido_pay_gw) && $p->pedido_pay_gw > 0) {
					if ($p->pedido_pay_gw == 1 && !empty($p->pedido_total_parcelado)) {
						$itens['pedido_info'] = 'cartao';
					} else if ($p->pedido_pay_gw == 5) {
						$itens['pedido_info'] = 'boleto';
					}
				}

				if (isset($data_hora_created[0])) {
					$data = explode('/', $data_hora_created[0]);
					if (isset($data[2])) {
						$itens['pedido_created'] = $data[2] . '-' . $data[1] . '-' . $data[0];
						if (isset($data_hora_created[1])) {
							$itens['pedido_created'] .= ' ' . $data_hora_created[1];
						}
					}
				}

				(new Factory('pedido'))->with($itens)->add(false);
				self::importar_lista_pedido($p);
				if (isset($p->pedido_comprovante) && !empty($p->pedido_comprovante) && !ctype_space($p->pedido_comprovante)) {
					self::download_comprovante($p->pedido_comprovante);
				}
			}
		}
	}

	public function importar_lista_pedido($pedido)
	{
		$lista_pedido = $this->fetch("SELECT * FROM lista WHERE lista_pedido = $pedido->pedido_id");

		if (isset($lista_pedido[0])) {
			foreach ($lista_pedido as $p) {

				$itens = [
					'lista_pedido_id' => $p->lista_id,
					'lista_pedido_pedido' => $p->lista_pedido,
					'lista_pedido_produto' => $p->lista_item,
					'lista_pedido_produto_titulo' => $p->lista_title,
					'lista_pedido_preco' => $p->lista_preco,
					'lista_pedido_qtde' => $p->lista_qtde,
					'lista_pedido_foto' => $p->lista_foto,
				];

				//Filter::pre($itens);
				(new Factory('lista_pedido'))->with($itens)->add();

				if ($p->lista_atributos && !ctype_space($p->lista_atributos)) {

					$atributos_item_pedido = explode('|', $p->lista_atributos);

					//Mais de uma atributo na lista
					if (isset($atributos_item_pedido[0]) && is_array($atributos_item_pedido)) {
						foreach ($atributos_item_pedido as $a) {
							self::importar_atributos_lista_pedido($a, $p->lista_id);
						}
					} else {
						self::importar_atributos_lista_pedido($atributos_item_pedido, $p->lista_id);
					}
				}
			}
		}
	}

	public function importar_atributos_lista_pedido($lista_atributos, $lista_id)
	{

		$lista_atributos = explode(';', $lista_atributos);

		$itens = [
			'lista_pedido_atributo_attnome' => $lista_atributos[0],
			'lista_pedido_atributo_itemnome' => $lista_atributos[1],
			'lista_pedido_atributo_valor_adicional' => $lista_atributos[4],
			'lista_pedido_atributo_lista' => $lista_id,
		];

		(new Factory('lista_pedido_atributo'))->with($itens)->add();
	}

	public function download_comprovante($comprovante)
	{
		//recebe link do site no form do admin
		$site = $this->loja_v3_dir;

		//ex: nome da foto no bd b029ddeff76809c104118f8b916a8048.jpg;
		//monta a url com o caminho absoluto da foto remotadamente
		$url = $site . "app/fotos/comprovantes/$comprovante";

		//caminho para salvar na nova loja
		$diretorio = Path::base() . '/media/documentos/';

		// Obtém o nome do arquivo da URL
		$nomeArquivo = basename($url);

		// Verifica se o diretório existe, se não, cria-o
		if (!is_dir($diretorio)) {
			mkdir($diretorio, 0777, true);
		}
		// Define o caminho completo para o arquivo no diretório
		$caminhoCompleto = $diretorio . $nomeArquivo;

		// Faz o download da imagem
		@file_put_contents($caminhoCompleto, file_get_contents($url));

		// Verifica se o download foi bem-sucedido
		if (file_exists($caminhoCompleto)) {
			// Download da imagem concluído com sucesso
			//echo "download sucesso";
		} else {
			echo "Falha ao fazer o download do comprovante";
		}
	}

	public function importar_endereco_retirada()
	{
		$retirada = $this->fetch("SELECT * FROM retirada");
		(new Factory('retirada'))->where('1 = 1')->drop();
		if (isset($retirada[0]->retirada_id)) {
			foreach ($retirada as  $ret) {
				(new Factory('retirada'))->with($ret)->add();
			}
		}
	}

	public function vincular_produto_atributos($produto)
	{
		$relacionamento_pai = $this->fetch("SELECT * FROM relatrr WHERE relatrr_item = $produto->item_id GROUP BY relatrr_atributo ORDER BY relatrr_id ASC;");
		$itens_atributos = [];
		$relacao_id = null;
		$atributo_id = null;
		if (!empty($relacionamento_pai)) {
			for ($i = 0; $i < sizeof($relacionamento_pai); $i++) {

				$itens = [
					'relacao_atributo_produto' => $produto->item_id,
					'relacao_atributo_atributo' => $relacionamento_pai[$i]->relatrr_atributo,
				];

				if (isset($relacionamento_pai[$i + 1])) {
					$itens['relacao_atributo_relacao_pai'] = $relacionamento_pai[$i + 1]->relatrr_atributo;
				}

				$relacao_id = (new Factory('relacao_atributo'))->with($itens)->add();
				$atributo_id = $relacionamento_pai[$i]->relatrr_atributo;
			}

			if ($relacao_id > 0 && $atributo_id > 0 && $produto->item_id > 0) {
				self::vincular_produto_item_atributo($relacao_id, $atributo_id, $produto->item_id);
			}
		}
	}

	public function vincular_produto_item_atributo($relacao_id, $atributo_id, $produto_id)
	{

		//Itens que vão ser combinados
		$relacao_item_relacao_pai = [];

		//Todos os atributos vinculados trazido em ordem de cadastro
		$atributos_pai = $this->fetch("SELECT * FROM relatrr WHERE relatrr_item = $produto_id GROUP BY relatrr_atributo ORDER BY relatrr_id ASC;");

		//Ultimo atributo da hierarquia dos atributos vinculados ao produto
		$ultimo_atr = $atributos_pai[sizeof($atributos_pai) - 1]->relatrr_atributo;

		//Trazendo todos os itens do ultimo atributo vinculado
		$itens_ultimo_atributo = $this->fetch("SELECT * FROM relatrr WHERE relatrr_item = $produto_id AND relatrr_atributo = $ultimo_atr AND relatrr_iattr IS NOT NULL;");

		Filter::pre($produto_id);

		//Inserindo os itens do atributo na ordem da hierarquia
		for ($i = 0; $i < sizeof($atributos_pai) - 1; $i++) {
			$atr = self::get_relacao_item_atributo($atributos_pai[$i]);
			array_push($relacao_item_relacao_pai, $atr);
		}

		$str_itens_combinados = self::combinarStrings($relacao_item_relacao_pai);

		//Filter::pre($str_itens_combinados);

		if (isset($str_itens_combinados[0])) {
			foreach ($str_itens_combinados as $a) {
				foreach ($itens_ultimo_atributo as $u) {

					$itens_relacionamento = [
						'relacao_item_relacao_atributo' => $relacao_id,
						'relacao_item_atributo' => $atributo_id,
						'relacao_item_item' => ($u->relatrr_iattr),
						'relacao_item_produto' => $produto_id,
						'relacao_item_qtd' => intval($u->relatrr_qtde),
						'relacao_item_preco' => $u->relatrr_preco,
						'relacao_item_relacao_pai' => $a,
					];

					(new Factory('relacao_item'))->with($itens_relacionamento)->add();
				}
			}
		} else {
			foreach ($itens_ultimo_atributo as $u) {

				$itens_relacionamento = [
					'relacao_item_relacao_atributo' => $relacao_id,
					'relacao_item_atributo' => $atributo_id,
					'relacao_item_item' => ($u->relatrr_iattr),
					'relacao_item_produto' => $produto_id,
					'relacao_item_qtd' => intval($u->relatrr_qtde),
					'relacao_item_preco' => $u->relatrr_preco,
					'relacao_item_relacao_pai' => '',
				];

				(new Factory('relacao_item'))->with($itens_relacionamento)->add();
			}
		}
	}

	//Vai retornar um array com os ids dos itens de atributos relacionados ao produto
	public function get_relacao_item_atributo($atributo)
	{
		$relacionamento_filho = $this->fetch("SELECT * FROM relatrr WHERE relatrr_item = $atributo->relatrr_item AND relatrr_atributo = $atributo->relatrr_atributo AND relatrr_iattr IS NOT NULL;");
		//Filter::pre($relacionamento_filho);
		if (isset($relacionamento_filho[0])) {
			return array_column($relacionamento_filho, 'relatrr_iattr');
		} else {
			return 0;
		}
	}

	//Função que vai combinar os ids em niveis ex: '15>12'
	public function combinarStrings($array, $index = 0, $prefix = '')
	{
		if (!isset($array[$index]) || !is_array($array[$index]) || $array[$index] == 0) {
			return '';
		}

		$result = array();

		if ($index === count($array)) {
			$result[] = $prefix;
			return $result;
		}

		foreach ($array[$index] as $num) {
			if ($index + 1 < count($array)) {
				$newPrefix = $prefix . ($prefix ? '>' : '') . $num;
				$result = array_merge($result, $this->combinarStrings($array, $index + 1, $newPrefix));
			} else {
				$result[] = $prefix . ($prefix ? '>' : '') . $num;
			}
		}

		return $result;
	}
}
