<?php
@session_start();

use Frete\MelhorEnvio;
use Frete\Kangu;
use Frete\FreteFrenet;
use Frete\FreteFaixaCep;

class FreteFront
{

	public $config_frete;
	public $config;

	public function __construct()
	{
		(new Install)->check_tabelas_principais();
		$this->config = (new Config)->get();
		$this->config_frete = (new Factory('frete'))->find(1);
	}

	public function goToEndereco()
	{
		$_SESSION['cliente_frete_redirect'] = true;
	}

	public function indexAction()
	{
		$tipoEntrega = (new Factory('frete'))->select('frete_opcoes')->where('frete_id = 1')->get()[0];
		$data = [
			'categorias' => (new CategoriasProdutosFront())->listar(),
			'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
			'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
			'paginasTopo' => (new Pagina())->listarPaginasTopo(),
			"frete_gratis" => "0",
			'paginasFooter' => (new Pagina())->listarPaginasFooter(),
			'faq' => (new Faq())->listaFooter(),
			'config' => $this->config,
			'social' => (new Config)->getRedesSociais(),
			'mapper' => ['config', 'social'],
		];

		if (isset($tipoEntrega->frete_opcoes)) {
			$data["frete_opcoes"] = $tipoEntrega->frete_opcoes;
		}
		if (intval($this->config_frete->frete_gratis_ativo) > 0) {
			$cart = (new Carrinho)->getCarrinho(1);
			if ($cart['info']['subtotal'] >= $this->config_frete->frete_gratis_valor_minimo) {
				$data["frete_gratis"] = "1";
			}
		}
		Tpl::view("tema.loja.checkout.frete", $data, 1);
	}

	public function indexActionOrcamento()
	{
		$tipoEntrega = (new Factory('frete'))->select('frete_opcoes')->where('frete_id = 1')->get()[0];
		$data = [
			'categorias' => (new CategoriasProdutosFront())->listar(),
			'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
			'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
			'paginasTopo' => (new Pagina())->listarPaginasTopo(),
			"frete_gratis" => "0",
			'paginasFooter' => (new Pagina())->listarPaginasFooter(),
			'faq' => (new Faq())->listaFooter(),
			'config' => $this->config,
			'social' => (new Config)->getRedesSociais(),
			'mapper' => ['config', 'social'],
		];
		if (isset($tipoEntrega->frete_opcoes)) {
			$data["frete_opcoes"] = $tipoEntrega->frete_opcoes;
		}
		if (intval($this->config_frete->frete_gratis_ativo) > 0) {
			$cart = (new Carrinho)->getCarrinho(1);
			if ($cart['info']['subtotal'] >= $this->config_frete->frete_gratis_valor_minimo) {
				$data["frete_gratis"] = "1";
			}
		}
		Tpl::view("tema.loja.checkout.frete-orcamento", $data, 1);
	}

	public function get_frete()
	{

		$cart = (new Carrinho)->getCarrinho(1);
		if (
			isset($this->config_frete->frete_cep_origem) &&
			!empty($this->config_frete->frete_cep_origem)
		) {
			if (!isset($_REQUEST['cep']) && empty($_REQUEST['cep'])) {
				echo json_encode(['error' => 'CEP Não informado!']);
				exit;
			}
			$destino = $_REQUEST['cep'];
			$_SESSION['CEP'] = $_REQUEST['cep'];
			$carrinho = [];
			$produtos = [];
			$qtd_produtos_frete_gratis = 0;
			if (isset($_POST['produto']['produto_id']) && intval($_POST['produto']['produto_calcula_frete']) > 0) {
				// consulta a partir de um produto
				$_POST['produto']['largura'] = isset($_POST['produto']['produto_largura']) ? $_POST['produto']['produto_largura'] : '16';
				$_POST['produto']['altura'] = isset($_POST['produto']['produto_altura']) ? $_POST['produto']['produto_altura'] : '16';
				$_POST['produto']['comprimento'] = isset($_POST['produto']['produto_comprimento']) ? $_POST['produto']['produto_comprimento'] : '16';
				$_POST['produto']['peso'] = isset($_POST['produto']['produto_peso']) ? $_POST['produto']['produto_peso'] : '0.3';
				$_POST['produto']['quantidade'] = isset($_POST['produto']['qtd']) ? $_POST['produto']['qtd'] : '1';
				$produtos[] = $_POST['produto'];
			} else if (
				isset($_SESSION['carrinho']) &&
				!empty($_SESSION['carrinho']) &&
				is_array($_SESSION['carrinho']) &&
				sizeof($_SESSION['carrinho']) > 0
			) {
				$carrinho = $_SESSION['carrinho'];

				foreach ($carrinho as $k) {
					if (isset($k['produto']['produto_calcula_frete']) && $k['produto']['produto_calcula_frete'] == '0') {
						$qtd_produtos_frete_gratis++;
					}
					//else {
					// Adequação para o uso do helper
					$k['produto']['largura'] = isset($k['produto']['produto_largura']) ? $k['produto']['produto_largura'] : '16';
					$k['produto']['altura'] = isset($k['produto']['produto_altura']) ? $k['produto']['produto_altura'] : '16';
					$k['produto']['comprimento'] = isset($k['produto']['produto_altura']) ? $k['produto']['produto_altura'] : '16';
					$k['produto']['peso'] = isset($k['produto']['produto_peso']) ? $k['produto']['produto_peso'] : '0.3';
					$k['produto']['quantidade'] = isset($k['produto']['qtd']) ? $k['produto']['qtd'] : '1';
					$produtos[] = $k['produto'];
					//}
				}
				//Filter::pre($produtos, 1);
				/*
				if ($qtd_produtos_frete_gratis == sizeof($carrinho)) {
					// todos os produtos do carrinho com frete gratis
					foreach ($carrinho as $k) {
						// Adequação para o uso do helper
						$k['produto']['largura'] = isset($k['produto']['produto_largura']) ? $k['produto']['produto_largura'] : '16';
						$k['produto']['altura'] = isset($k['produto']['produto_altura']) ? $k['produto']['produto_altura'] : '16';
						$k['produto']['comprimento'] = isset($k['produto']['produto_altura']) ? $k['produto']['produto_altura'] : '16';
						$k['produto']['peso'] = isset($k['produto']['produto_peso']) ? $k['produto']['produto_peso'] : '0.3';
						$k['produto']['quantidade'] = isset($k['produto']['qtd']) ? $k['produto']['qtd'] : '1';
						$produtos[] = $k['produto'];
					}
				}
				*/
			}
			/* INICIO DO CALCULO DE FRETE */
			$cotacoes = [];
			// PRODUTO FRETE GRATIS PARA TODO CARRINHO
			if ($qtd_produtos_frete_gratis == sizeof($carrinho) && !isset($_POST['produto']['produto_id'])) {
				$gratis[] = [
					"code" => $this->config_frete->frete_gratis_label,
					"price" => '0.00',
					"name" => $this->config_frete->frete_gratis_label,
					"deadline" => $this->config_frete->frete_prazo,
				];
				$cotacoes[] = $gratis;
			}
			// MELHOR ENVIO
			if (intval($this->config_frete->frete_melhorenvio) > 0) {
				$conf = [
					"melhorenvio_token" => $this->config_frete->frete_melhorenvio_token,
					"melhorenvio_servicos" => $this->config_frete->frete_melhorenvio_servicos,
					"cep_origem" => $this->config_frete->frete_cep_origem,
					"cep_destino" => $destino,
				];
				$melhorenv = (new MelhorEnvio)->get_frete($conf, $produtos);
				if (sizeof($melhorenv) > 0) {
					$cotacoes[] = $melhorenv;
				}
			}
			//KANGU 
			if (isset($this->config_frete->frete_kangu) && intval($this->config_frete->frete_kangu) > 0) {
				$conf = [
					"kangu_token" => $this->config_frete->frete_kangu_token,
					"cep_origem" => $this->config_frete->frete_cep_origem,
					"cep_destino" => $destino,
				];
				$kangu = (new Kangu)->get_frete($conf, $produtos);
				if (sizeof($kangu) > 0) {
					$cotacoes[] = $kangu;
				}
			}

			// FRETE GRATIS
			if ($this->config_frete->frete_gratis_ativo == 1) {
				if (
					(isset($cart['info']['subtotal']) && $cart['info']['subtotal'] >= $this->config_frete->frete_gratis_valor_minimo)
					||
					isset($_POST['produto']['produto_id']) && !empty($_POST['produto']['produto_id']) &&
					$_POST['produto']['produto_preco'] >= $this->config_frete->frete_gratis_valor_minimo

				) {
					$gratis[] = [
						"code" => $this->config_frete->frete_gratis_label,
						"price" => '0.00',
						"name" => $this->config_frete->frete_gratis_label,
						"deadline" => $this->config_frete->frete_prazo,
					];
					$cotacoes[] = $gratis;
				}
			}

			// FRENET
			/*
			if (intval($this->config_frete->frete_frenet) > 0) {
				$conf = [
					"frenet_token" => $this->config_frete->frete_frenet_token,
					"cep_origem" => $this->config_frete->frete_cep_origem,
					"cep_destino" => $destino,
				];
				$frenet = (new FreteFrenet)->get_frete($conf, $produtos);
				if ($qtd_produtos_frete_gratis == sizeof($carrinho) || (isset($produtos[0]['produto_calcula_frete']) && intval($produtos[0]['produto_calcula_frete']) == 0)) {
					// só tem produtos com frete gratis no carrinho, zerar frete
					foreach ($frenet as $k => $v) {
						$frenet[$k]['price'] = '0.00';
					}
				}
				if (isset($frenet[0])) {
					$cotacoes[] = $frenet;
				}
			}
			*/

			// CORREIOS
			/*
			if(isset($this->config_frete->frete_pac)){
				$loja = [
					'origem' => $this->config_frete->frete_cep_origem,
					'pac' => $this->config_frete->frete_pac,
					'sedex' => $this->config_frete->frete_sedex,
					'sedex10' => $this->config_frete->frete_sedex10,
					'nCdEmpresa' => $this->config_frete->frete_correios_cod_empresa,
					'sDsSenha' => $this->config_frete->frete_correios_senha_empresa,
				];
				if (intval($loja['pac']) > 0 || intval($loja['sedex']) > 0 || intval($loja['sedex10']) > 0) {
					$correios = (new FreteCorreios)->get_frete($loja, $destino, $produtos);
					if (!isset($correios['error'])) {
						if ($qtd_produtos_frete_gratis == sizeof($produtos)) {
							foreach ($correios as $k => $v) {
								$correios[$k]['price'] = '0.00';
							}
						}
						$cotacoes[] = $correios;
					}
				}
			}
			*/
			// CEP FAIXA
			if (isset($this->config_frete->frete_faixa) && $this->config_frete->frete_faixa >= 0) {
				$peso = 0;
				foreach ($produtos as $k => $v) {
					$peso += $v['peso'];
				}
				$escope = [
					'faixa_cep_inicio' => 'numbers',
					'faixa_cep_final' => 'numbers',
					'faixa_cep_peso_de' => 'numbers',
					'faixa_cep_peso_ate' => 'numbers',
					'faixa_cep_valor' => 'numbers',
				];
				$faixas = (new Factory('faixa_cep'))->format($escope)->get();
				$faixaCep = (new FreteFaixaCep())->get_frete($faixas, $destino, $peso);
				// produtos com frete gratis no carrinho, zerar frete
				if (
					$qtd_produtos_frete_gratis == sizeof($carrinho) ||
					(isset($produtos[0]['produto_calcula_frete']) && intval($produtos[0]['produto_calcula_frete']) == 0)
				) {
					foreach ($faixaCep as $k => $v) {
						$faixaCep[$k]['price'] = '0.00';
					}
				}
				$cotacoes[] = $faixaCep;
			}
			$final = [];
			if (isset($cotacoes[0])) {
				foreach ($cotacoes as $cot) {
					$final = array_merge($final, $cot);
				}
			}
			echo json_encode([$final]);
		}
	}

	public function goToPagamentoEntrega()
	{
		$cupom = Req::post('cupom'); // objeto
		$frete = Req::post('frete'); // objeto
		$endereco = Req::post('endereco', 'int');

		if (!isset($frete) && empty($frete)) {
			echo '-1';
			exit;
		} else {
			if (isset($cupom) && !empty($cupom)) {
				$this->setCupom($cupom);
			}
			$this->setFrete($frete, $endereco);
			echo '1';
			exit;
		}
	}

	public function goToPagamentoRetirada()
	{
		$cupom = Req::post('cupom');
		$retirada = Req::post('retirada');
		if (!isset($retirada) && empty($retirada)) {
			echo '-1';
			exit;
		} else {
			if (isset($cupom) && !empty($cupom)) {
				$this->setCupom($cupom);
			}
			$this->setRetirada($retirada);
			echo '1';
			exit;
		}
	}
	public function setCupom($cupom)
	{
		$_SESSION['cupom'] = $cupom;
	}

	public function setFrete($frete, $end)
	{
		$_SESSION['frete'] = $frete;
		$_SESSION['frete']['endereco_id'] = intval($end);
	}

	public function setRetirada($retirada)
	{
		$_SESSION['retirada'] = $retirada;
	}

	public function getValorFrete()
	{
		if (isset($_SESSION['frete']) && !empty($_SESSION['frete'])) {
			echo json_encode(['frete' => $_SESSION['frete']]);
		}
	}

	public function getValorCupom()
	{
		if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom'])) {
			echo json_encode(['cupom' => $_SESSION['cupom']]);
		}
	}

	public function clearFrete()
	{
		unset($_SESSION['retirada']);
		unset($_SESSION['frete']);
		echo '1';
	}

	public function rastreio()
	{
		$codigo = Http::get_param(1);
		$pedido = (new Factory('pedido'))
			->where("pedido_codigo_rastreio = '$codigo'")
			->get();
		$pedido = (isset($pedido[0]) && is_array($pedido)) ? $pedido[0] : null;
		if ($pedido) {
			//Melhor envio
			//if ($pedido->pedido_empresa_rastreio == 1) {
			$url = "https://www.melhorrastreio.com.br/rastreio/$pedido->pedido_codigo_rastreio";
			//}
			Http::redirect($url);
		}
	}
}
