<?php

use Frete\MelhorEnvio;


class Frete
{

    public function __construct()
    {
        Sessao::check();
        if (ucfirst(Session::node('ulevel')) != '1') {
            Http::redirect_to('/admin/?error');
        }
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $frete = (new Factory('frete'))->get();
        if (isset($frete[0])) {
            $frete = $frete[0];
            $frete->frete_gratis_valor_minimo = number_format($frete->frete_gratis_valor_minimo, 2, ',', ' ');
            $frete->frete_melhor_envio_auth_url = self::get_melhorenvio_auth_url($frete);
            $frete->frete_melhor_envio_callback_url = self::get_melhorenvio_callback_url();
            $data = [
                'config' => (new Config)->get(),
                'frete'  => $frete,
                'faixa_cep' => (new Factory('faixa_cep'))->map(),
                'mapper' => ['config', 'frete', 'faixa_cep']
            ];
            Tpl::view('admin.frete.index', $data, 1);
        }
    }

    static public function upgrade()
    {
        /** FRETE 09/02/2024  */
        $columns = [
            ['name' => 'kangu', 'type' => 'int(1)', 'default' => 0],
            ['name' => 'kangu_token', 'type' => 'longtext'],
        ];
        (new DB)->add_columns('frete', $columns);

        $columns = [
            ['name' => 'servico_frete', 'type' => 'varchar(200)'],
        ];
        (new DB)->add_columns('pedido', $columns);
    }

    public function gravar()
    {
        Sessao::perms('G');
        Req::drop('_wysihtml5_mode');
        // Req::drop_blank();
        if (isset($_POST['frete_id']) && !empty($_POST['frete_id'])) {
            if (isset($_POST['frete_melhorenvio_servicos']) && is_array($_POST['frete_melhorenvio_servicos']) && !empty($_POST['frete_melhorenvio_servicos'])) {
                $_POST['frete_melhorenvio_servicos'] = implode(',', $_POST['frete_melhorenvio_servicos']);
            } else {
                $_POST['frete_melhorenvio_servicos'] = '1,2,17,28,29,30';
            }
            $_POST = Filter::parse_full($_POST);
            $_POST['frete_sedex'] = isset($_POST['frete_sedex']) ? $_POST['frete_sedex'] : '0';
            $_POST['frete_sedex10'] = isset($_POST['frete_sedex10']) ? $_POST['frete_sedex10'] : '0';
            $_POST['frete_pac'] = isset($_POST['frete_pac']) ? $_POST['frete_pac'] : '0';
            $_POST['frete_frenet'] = isset($_POST['frete_frenet']) ? $_POST['frete_frenet'] : '0';
            $_POST['frete_kangu'] = isset($_POST['frete_kangu']) ? $_POST['frete_kangu'] : '0';
            $_POST['frete_melhorenvio'] = isset($_POST['frete_melhorenvio']) ? $_POST['frete_melhorenvio'] : '0';

            if ((!isset($_POST['frete_correios_cod_empresa']) && empty($_POST['frete_correios_cod_empresa']) && !isset($_POST['frete_correios_senha_empresa']) && empty($_POST['frete_correios_senha_empresa'])) || ($_POST['frete_correios_cod_empresa'] == '' && $_POST['frete_correios_senha_empresa'] == '')) {
                $_POST['frete_correios_cod_empresa'] = '';
                $_POST['frete_correios_senha_empresa'] = '';
            }
            $escope = [
                'frete_gratis_valor_minimo' => 'money',
            ];
            (new Factory('frete'))->with($_POST)->format($escope)->save();
            Http::redirect_to('/frete/?success');
        } else {
            Http::redirect_to('/frete/?error');
        }
    }

    public function diferenciado()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.frete.diferenciado.index', $data, 1);
    }

    public function diferenciado_novo()
    {
        $data = [
            'config' => (new Config)->get(),
            'frete_diferenciado' => (new Factory('frete_diferenciado'))->map(),
            'mapper' => ['config', 'frete_diferenciado']
        ];
        Tpl::view('admin.frete.diferenciado.form', $data, 1);
    }

    public function gravar_diferenciado()
    {
        if (isset($_POST['frete_diferenciado_cep']) && !empty($_POST['frete_diferenciado_cep'])) {
            $_POST = Filter::parse_full($_POST);
            (new Factory('frete_diferenciado'))->with($_POST)->save();
            Http::redirect_to('/frete-diferenciado/?success');
        }
    }

    public function diferenciado_lista()
    {
        (new Factory('frete_diferenciado'))
            ->select('frete_diferenciado_valor, frete_diferenciado_id, frete_diferenciado_cep, frete_diferenciado_bairro, frete_diferenciado_cidade, frete_diferenciado_uf, 
        CASE frete_diferenciado_tipo
        WHEN 1 THEN "UF"
        WHEN 2 THEN "Cidade"
        WHEN 3 THEN "Bairro"
        END AS frete_diferenciado_tipo
        ')
            ->get(1);
    }

    public function diferenciado_editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $diferenciado = (new Factory('frete_diferenciado'))->find($id);
            if ($diferenciado) {
                $data = [
                    'config' => (new Config)->get(),
                    'frete_diferenciado' => $diferenciado,
                    'mapper' => ['config', 'frete_diferenciado']
                ];
                Tpl::view('admin.frete.diferenciado.form', $data, 1);
            } else {
                Http::redirect_to('/frete-diferenciado/?error');
            }
        } else {
            Http::redirect_to('/frete-diferenciado/?error');
        }
    }

    public function diferenciado_remover()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('frete_diferenciado'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    public function retirada()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.frete.retirada.index', $data, 1);
    }

    public function retirada_novo()
    {
        $data = [
            'config' => (new Config)->get(),
            'retirada' => (new Factory('retirada'))->map(),
            'mapper' => ['config', 'retirada']
        ];
        Tpl::view('admin.frete.retirada.form', $data, 1);
    }

    public function retirada_editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $retirada = (new Factory('retirada'))->find($id);
            if ($retirada) {
                $data = [
                    'config' => (new Config)->get(),
                    'retirada' => $retirada,
                    'mapper' => ['config', 'retirada']
                ];
                Tpl::view('admin.frete.retirada.form', $data, 1);
            } else {
                Http::redirect_to('/retirada/?error');
            }
        } else {
            Http::redirect_to('/retirada/?error');
        }
    }

    public function retirada_lista()
    {
        echo (new Factory('retirada'))
            ->get('json');
    }

    public function gravar_retirada()
    {
        if (isset($_POST['retirada_cep']) && !empty($_POST['retirada_cep'])) {
            $_POST = Filter::parse_full($_POST);
            (new Factory('retirada'))->with($_POST)->save();
            Http::redirect_to('/retirada/?success');
        }
    }

    public function remover_retirada()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('retirada'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    public function faixa()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.frete.faixa.index', $data, 1);
    }

    public function faixa_novo()
    {
        $data = [
            'config' => (new Config)->get(),
            'faixa_cep' => (new Factory('faixa_cep'))->map(),
            'mapper' => ['config', 'faixa_cep']
        ];
        Tpl::view('admin.frete.faixa.form', $data, 1);
    }

    public function gravar_faixa()
    {
        if (isset($_POST['faixa_cep_inicio']) && !empty($_POST['faixa_cep_inicio'])) {
            $_POST = Filter::parse_full($_POST);
            $escope = [
                'faixa_cep_inicio' => 'numbers',
                'faixa_cep_final' => 'numbers',
                'faixa_cep_peso_de' => 'money',
                'faixa_cep_peso_ate' => 'money',
                'faixa_cep_valor' => 'money',
            ];
            (new Factory('faixa_cep'))->format($escope)->with($_POST)->save();
            Http::redirect_to('/frete/?success');
        }
    }

    public function faixa_lista()
    {
        $escope = [
            'faixa_cep_inicio' => 'numbers',
            'faixa_cep_final' => 'numbers',
            'faixa_cep_peso_de' => 'money',
            'faixa_cep_peso_ate' => 'money',
            'faixa_cep_valor' => 'money',
        ];
        echo (new Factory('faixa_cep'))->format($escope)->get('json');
    }

    public function faixa_editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $faixa = (new Factory('faixa_cep'))->find($id);
            if ($faixa) {
                $data = [
                    'config' => (new Config)->get(),
                    'faixa' => $faixa,
                    'mapper' => ['config', 'faixa']
                ];
                Tpl::view('admin.frete.faixa.form', $data, 1);
            } else {
                Http::redirect_to('/faixa/?error');
            }
        } else {
            Http::redirect_to('/faixa/?error');
        }
    }

    public function remover_faixa()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('faixa_cep'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    static function get_melhorenvio_auth_url($frete)
    {
        $redirect_uri = self::get_melhorenvio_callback_url();
        return "https://melhorenvio.com.br/oauth/authorize?client_id=$frete->frete_melhorenvio_client_id&redirect_uri=$redirect_uri&response_type=code&state=codigo_para_consultas&scope=cart-read cart-write companies-read companies-write coupons-read coupons-write notifications-read orders-read products-read products-write purchases-read shipping-calculate shipping-cancel shipping-checkout shipping-companies shipping-generate shipping-preview shipping-print shipping-share shipping-tracking ecommerce-shipping transactions-read users-read users-write";
    }

    static function get_melhorenvio_callback_url()
    {
        return Http::base() . '/frete/melhorenvio_callback/';
    }

    public function melhorenvio_callback()
    {
        (new MelhorEnvio)->autorizacao_callback();
    }
}
