<?php

class Checkout
{

    public function __construct()
    {
        (new Install)->check_tabelas_principais();

        $config = (new Config)->get();
        self::validatorCarrinho();

        //Modo loja padrão valida login
        if (intval($config->config_site_modo) == 1) {
            self::validatorLogin();
            // Loja normal
            self::validatorFrete();
            self::validatorPagamento();
        } //Orçamento
        else if (intval($config->config_site_modo) == 2) {
            //Verificando se os dados do form do orçamento estão na sessão
            if (!isset($_SESSION['__CLIENTE_ORCAMENTO__'])) {
                Http::redirect_to('/login-cliente');
            }
            self::finaliza_orcamento();
        } else {
            Http::redirect_to('/');
        }
    }


    static public function upgrade()
    {
        /** ATTR ORCAMENTO 17/05/2024  */
        $columns = [
            ['name' => 'atributo', 'type' => 'int(11)']
        ];
        (new DB)->add_columns('lista_pedido_atributo', $columns);
    }

    public function indexAction()
    {
    }

    // Método para verificar se o usuário está logado
    static function validatorLogin()
    {
        if (Session::client_node('uid') == null) {
            $_SESSION['cliente_checkout_redirect'] = true;
            Http::redirect_to('/login-cliente');
            exit;
        }
    }

    // Método para verificar se existe itens no carrinho
    static function validatorCarrinho()
    {
        if (!isset($_SESSION['carrinho']) && empty($_SESSION['carrinho']) || sizeof($_SESSION['carrinho']) == 0) {
            Http::redirect_to('/carrinho/?carrinho-vazio');
            exit;
        }
        // Validação de itens com arquivo
        $cart = (new Carrinho)->getCarrinho(1);
        $cart = $cart['carrinho'];
        if (is_array($cart) && sizeof($cart) > 0) {
            foreach ($cart as $k) {
                $prod = $k['produto'];
                if (isset($prod['produto_arquivo'])) {
                    if (intval($prod['produto_arquivo']) == 1 && !isset($prod['arquivo_url'])) {
                        Http::redirect_to('/carrinho/?erro-arquivo');
                        exit;
                    }
                }
            }
        }
    }

    // Método para verificar se o frete já foi setado
    static function validatorFrete()
    {
        $cart = (new Carrinho)->getCarrinho(1);
        if (!isset($cart['info'])) {
            Http::redirect_to('/carrinho/?erro=vm');
        }
        $info = $cart['info']['compra_min'];
        if (is_array($cart) && sizeof($cart) > 0) {
            if (!isset($info['compra_min_check']) || $info['compra_min_check'] == false) {
                Http::redirect_to('/carrinho/?erro=vm');
                exit;
            }
        }

        if ((!isset($_SESSION['frete']) && empty($_SESSION['frete'])) && (!isset($_SESSION['retirada']) && empty($_SESSION['retirada']))) {
            // Verifica se está habilitada a funcionalidade de frete gratis
            (new FreteFront)->indexAction();
            exit;
        }
    }

    // Método para verificar se o frete já foi setado como ORÇAMENTO
    static function validatorFreteOrcamento()
    {
        if ((!isset($_SESSION['frete']) && empty($_SESSION['frete'])) && (!isset($_SESSION['retirada']) && empty($_SESSION['retirada']))) {
            // Verifica se está habilitada a funcionalidade de frete gratis
            (new FreteFront)->indexActionOrcamento();
            exit;
        }
    }

    static function validatorPagamento()
    {
        $cart = (new Carrinho)->getCarrinho(1);
        if (!isset($cart['info'])) {
            Http::redirect_to('/carrinho/?erro=vm');
        }
        $info = $cart['info']['compra_min'];
        if (is_array($cart) && sizeof($cart) > 0) {
            if (!isset($info['compra_min_check']) || $info['compra_min_check'] == false) {
                Http::redirect_to('/carrinho/?erro=vm');
                exit;
            }
        }

        (new PagamentoFront)->indexAction();
    }

    static function finaliza_orcamento()
    {
        if (
            isset($_SESSION['__CLIENTE_ORCAMENTO__']) && !empty($_SESSION['__CLIENTE_ORCAMENTO__']) &&
            isset($_SESSION['__CLIENTE_ORCAMENTO__']->cliente_id) && $_SESSION['__CLIENTE_ORCAMENTO__']->cliente_id > 0
        ) {
            (new PagamentoFront)->finaliza_orcamento();
        } else {
            Http::redirect_to('/login-cliente/?error');
        }
    }
}
