<?php

class Carrinho
{
    public $carrinho_id = null;


    public function __construct()
    {
        @session_start();
    }

    public function indexAction()
    {
        //Filter::pre($_SESSION['carrinho']);        exit;
        $cep = '';
        if (isset($_SESSION['CEP'])) {
            $cep = $_SESSION['CEP'];
        }
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => (new Config)->get(),
            'social' => (new Config)->getRedesSociais(),
            'cep' => ['cep' => $cep],
            'mapper' => ['config', 'social', 'cep'],
        ];
        Tpl::view("tema.loja.carrinho.index", $data, 1);
    }

    public function getCarrinho($isReturned = false)
    {
        $compra_min = floatval((new Factory('pay'))->where('pay_name = "Config"')->get()[0]->pay_c1);
        if (isset($_SESSION['carrinho']) && !empty($_SESSION['carrinho'])) {
            $cart = $_SESSION['carrinho'];
            $subtotal = 0;
            $subtotal_desconto = 0;
            $qtd_itens_carrinho = sizeof($_SESSION['carrinho']);
            if (sizeof($cart) > 0) {
                foreach ($cart as $k => $v) {
                    //if (!is_numeric($cart[$k]['produto']['produto_preco'])) {
                    //}
                    if (isset($cart[$k]['produto']['valor_adicional']) && !empty($cart[$k]['produto']['valor_adicional']) && floatval($cart[$k]['produto']['valor_adicional']) > 0) {
                        $cart[$k]['produto']['produto_preco'] = (floatval($cart[$k]['produto']['produto_preco']) + floatval($cart[$k]['produto']['valor_adicional']))  * intval($cart[$k]['produto']['qtd']);
                    }
                    $subtotal += floatval($cart[$k]['produto']['produto_preco'])  * intval($cart[$k]['produto']['qtd']);
                    //$subtotal_desconto += floatval($cart[$k]['produto']['produto_preco_desc_boleto'])  * intval($cart[$k]['produto']['qtd']);
                    $subtotal_desconto +=  Math::money2Decimal(($cart[$k]['produto']['produto_preco_desc_boleto'])) * intval($cart[$k]['produto']['qtd']);
                    $cart[$k]['produto']['produto_preco'] = Filter::moeda($cart[$k]['produto']['produto_preco'], 'brl');
                    $cart[$k]['produto']['produto_preco_original'] = Filter::moeda($cart[$k]['produto']['produto_preco_original'], 'usd');
                }
            }
            if ($compra_min <= $subtotal) {
                $compra_min_info = ["compra_min_valor" => $compra_min, "compra_min_rest" => 0, "compra_min_check" => true];
            } else {
                $compra_min_info = [
                    "compra_min_valor" => $compra_min, "compra_min_rest" => Math::moeda($compra_min - $subtotal),
                    "compra_min_check" => false
                ];
            }
            //$subtotal_desconto = (floatval($subtotal_desconto) > 0) ?  Math::moeda($subtotal_desconto) : 0;
            if ($isReturned) {
                $cart = [
                    "carrinho" => $cart,
                    "info" => ["qtd_itens" => $qtd_itens_carrinho, "subtotal" => $subtotal, "subtotal_desconto" => $subtotal_desconto, 'compra_min' => $compra_min_info]
                ];
                return $cart;
            } else {
                echo json_encode([
                    "carrinho" => $cart,
                    "info" => ["qtd_itens" => $qtd_itens_carrinho, "subtotal" => $subtotal, "subtotal_desconto" => $subtotal_desconto, 'compra_min' => $compra_min_info]
                ]);
            }
        }
    }

    public function clearCarrinho()
    {
        if (isset($_SESSION['carrinho']) && !empty($_SESSION['carrinho'])) {
            unset($_SESSION['carrinho']);
            unset($_SESSION['retirada']);
            unset($_SESSION['frete']);
        }
    }
    public function insereProdutoCarrinho()
    {
        if (isset($_POST['produto']) && !empty($_POST['produto']) && intval($_POST['produto']['produto_id'])) {
            $produto = (array) $_POST['produto'];
            $this->verificaProdutoRepetido($produto); // caso exista produto repetido, $this->carrinho_id recebe o carrinho id onde este produto se encontra

            if ($this->carrinho_id != null) {
                // Tenta alterar os valores do produto, pois o cliente inseriu um produto que já esta no carrinho
                foreach ($_SESSION['carrinho'] as $k => $v) {
                    if ($_SESSION['carrinho'][$k]['carrinho_id'] == $this->carrinho_id) {
                        $qtdDesejada = intval($_SESSION['carrinho'][$k]['produto']['qtd']) + intval($produto['qtd']);
                        $this->verificaDisponibilidade($produto, $qtdDesejada);
                        $_SESSION['carrinho'][$k]['produto']['qtd'] = $qtdDesejada;
                    }
                }
            } else {
                // Novo produto no carrinho
                $produto = $this->verificaDisponibilidade($produto);
                // adiciona novo produto no carrinho            
                $this->setRandCarrinhoId();
                $_SESSION['carrinho'][] = [
                    'carrinho_id' => $this->carrinho_id,
                    'produto' => $produto
                ];
            }
            echo '1';
        } else {
            echo '0';
        }
    }

    // Verifica se o produto tem estoque disponivel
    public function verificaDisponibilidade($produto, $qtd = 0)
    {
        if (intval($qtd) > 0) {
            $produto['qtd'] = intval($qtd);
        }
        // Verifica se o produto tem atributos, se tiver, verifica disponibilidade pelos atributos, senao verifica pela quantidade em estoque        
        if (isset($produto['atributos_selecionados'][0])) {
            // tem atributos
            $item_mandante = $produto['atributos_selecionados'][sizeof($produto['atributos_selecionados']) - 1]; // atributo mandante é sempre o ultimo
            $itens_pais = $produto['atributos_selecionados'];
            array_pop($itens_pais);
            if (isset($itens_pais[0])) {
                // tem itens pais

                $relacao_item_relacao_pai = implode(">", $itens_pais);
                $qtd_em_estoque = (new Factory('relacao_item'))
                    ->select("relacao_item_qtd")
                    ->where("relacao_item_qtd >= " . $produto['qtd'] . " AND relacao_item_item = $item_mandante AND relacao_item_relacao_pai = '$relacao_item_relacao_pai' AND relacao_item_produto = " . $produto['produto_id'])
                    ->get();
                if (!isset($qtd_em_estoque[0])) {
                    // não tem estoque :/
                    echo '-1';
                    exit;
                }
                // Monta um esquema de exibição com os atributos selecionados
                $arr_itens_atributos = implode(',', $produto['atributos_selecionados']);
                $atributos = (new Factory('item_atributo'))
                    ->select('atributo_nome')
                    ->join('atributo', 'atributo_id = item_atributo_atributo')
                    ->where("item_atributo_id IN ($arr_itens_atributos)")
                    ->group_by('atributo_id')
                    ->get();
                $itens = (new Factory('item_atributo'))
                    ->select('item_atributo_nome')
                    ->where("item_atributo_id IN ($arr_itens_atributos)")
                    ->group_by('item_atributo_id')
                    ->get();
            } else {
                // Não tem itens pais
                $qtd_em_estoque = (new Factory('relacao_item'))
                    ->select("relacao_item_qtd")
                    ->where("relacao_item_qtd >= " . $produto['qtd'] . " AND relacao_item_item = $item_mandante AND relacao_item_produto = " . $produto['produto_id'])
                    ->get();
                if (!isset($qtd_em_estoque[0])) {
                    // não tem estoque :/
                    echo '-1';
                    exit;
                }
                // Monta um esquema de exibição com os atributos selecionados
                $atributos = (new Factory('item_atributo'))
                    ->select('atributo_nome')
                    ->join('atributo', 'atributo_id = item_atributo_atributo')
                    ->where("item_atributo_id = $item_mandante")
                    ->group_by('atributo_id')
                    ->get();
                $itens = (new Factory('item_atributo'))
                    ->select('item_atributo_nome')
                    ->where("item_atributo_id = $item_mandante")
                    ->group_by('item_atributo_id')
                    ->get();
            }
            $itens_final = [];

            if (isset($itens[0])) {
                foreach ($itens as $k) {
                    array_push($itens_final, $k->item_atributo_nome);
                }
            }
            $produto['nomes_atributos'] = $atributos;
            $produto['nomes_atributos_selecionados'] = $itens_final;
        } else {
            // não tem atributos
            $res = (new Factory('produto'))
                ->select('produto_estoque')
                ->find($produto['produto_id']);

            if (isset($res->produto_estoque) && $produto['qtd'] > $res->produto_estoque) {
                echo '-1';
                exit;
            }
        }
        return $produto;
    }

    /**
     * Método que verifica se o produto que esta sendo inserido no carrinho já existe
     * Caso exista ele seta o atributo $carrinho_id
     * Caso não exista o $carrinho_id continua null
     */
    public function verificaProdutoRepetido($produto)
    {
        if (isset($_SESSION['carrinho']) && !empty($_SESSION['carrinho'])) {
            $cart = $_SESSION['carrinho'];

            $produtoValidator = null; // recebe o produto no carrinho caso ele exista lá
            $carrinhoValidator = null; // recebe o id do carrinho que o produto ta inserido
            foreach ($cart as $k => $v) {
                if ($cart[$k]['produto']['produto_id'] == $produto['produto_id']) {
                    // O produto ja existe no carrinho, verifica os atributos
                    $produtoValidator = $cart[$k]['produto'];
                    $carrinhoValidator = $cart[$k]['carrinho_id'];
                }
            }
            if ($produtoValidator != null) {
                if (isset($produtoValidator['atributos_selecionados']) && !empty($produtoValidator['atributos_selecionados']) && is_array($produtoValidator['atributos_selecionados']) && sizeof($produtoValidator['atributos_selecionados']) > 0) {
                    // tem atributos, fazer validação pra saber se os atributos inseridos no novo produto é o mesmo que ja ta no carrinho
                    if ($produtoValidator['atributos_selecionados'] == $produto['atributos_selecionados']) {
                        // Mesmo produto no carrinho
                        $this->carrinho_id = $carrinhoValidator;
                    }
                } else {
                    $this->carrinho_id = $carrinhoValidator;
                }
            }
        }
    }

    public function atualizaProduto()
    {
        $id = Req::post('carrinho_id', 'string');
        $qtd = Req::post('qtd', 'int');
        if (isset($_SESSION['carrinho'])) {
            foreach ($_SESSION['carrinho'] as $k => $v) {
                if ($_SESSION['carrinho'][$k]['carrinho_id'] == $id) {
                    $this->verificaDisponibilidade($_SESSION['carrinho'][$k]['produto'], $qtd);
                    $_SESSION['carrinho'][$k]['produto']['qtd'] = $qtd;
                }
            }
            echo '1';
        } else {
            echo '-1';
        }
    }

    public function removeProduto()
    {
        if (isset($_SESSION['carrinho']) && !empty($_SESSION['carrinho'])) {
            $id = Req::post('carrinho_id', 'string');

            if (isset($id) && !empty($id)) {
                $cart = $_SESSION['carrinho'];

                foreach ($cart as $k => $v) {
                    if ($cart[$k]['carrinho_id'] == $id) {
                        unset($cart[$k]);
                    }
                }

                $_SESSION['carrinho'] = $cart;
                unset($_SESSION['retirada']);
                unset($_SESSION['frete']);
                echo '1';
            } else {
                echo '0';
            }
        }
    }

    public function salva_arquivo()
    {

        $carrinho_id = Req::post('carrinho_id', 'string');

        if (isset($carrinho_id) && !empty($carrinho_id) && isset($_FILES['arquivo'])) {

            if (intval($_FILES['arquivo']['error']) > 0) {
                Http::redirect_to('/carrinho/?erro-upload');
            }

            $media = Media::img_upload($_FILES['arquivo'], 'temp');
            if (isset($media->url)) {
                // salva o link do arquivo temporário no carrinho
                $cart = (new Carrinho)->getCarrinho(1);
                if (isset($cart['carrinho'])) {
                    foreach ($cart['carrinho'] as $k => $v) {
                        if ($cart['carrinho'][$k]['carrinho_id'] == $carrinho_id) {
                            // Verifica se já existia algum arquivo salvo
                            if (isset($cart['carrinho'][$k]['produto']['arquivo_url']) && !empty($cart['carrinho'][$k]['produto']['arquivo_url'])) {
                                $ds = DIRECTORY_SEPARATOR;
                                $path = Path::base() . $ds . 'media' . $ds . 'temp' . $ds . $cart['carrinho'][$k]['produto']['arquivo_url'];
                                if (is_file($path)) {
                                    //@system("chmod -R 777 $path");
                                    @unlink($path);
                                }
                            }
                            $cart['carrinho'][$k]['produto']['arquivo_url'] = $media->url;
                            $_SESSION['carrinho'] = $cart['carrinho'];
                            Http::redirect_to('/carrinho/?upload-ok');
                        }
                    }
                } else {
                    Http::redirect_to('/carrinho/?erro-upload');
                }
            } else {
                Http::redirect_to('/carrinho/?erro-upload');
            }
        }
    }

    public function setRandCarrinhoId()
    {
        $this->carrinho_id = base64_encode(uniqid(md5(time())));
    }
}
