<?php

use Erp\BlingApi;

class Bling
{
    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
    }

    static function modulo_status()
    {
        $data = (new Factory('integracao'))->find(1);
        return (isset($data->integracao_ativo) && !empty($data->integracao_ativo)) ? $data->integracao_ativo : 0;
    }

    public function gravar_credenciais()
    {

    }

    public function gravar_token()
    {

    }

    public function atualizar_token($redirect = false)
    {

        //Checando se o token está prestes a expirar
        $refresh = self::check_token_timelimit();

       
    }

    /**
     * @method gerar_nfe
     * @param $pedido  | required
     * @param $produto | required
     * @param $cliente | required
     * @description Metodo que vai apenas gerar a NFE na Bling
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error
     */
    static function gerar_nfe($pedido, $produto, $cliente)
    {

        self::atualizar_token();
     
    }

    /**
     * @method enviar_nfe
     * @param int $pedido_id | required
     * @param int $nfe_id | required
     * @description Metodo que vai enviar a NFE gerada na Bling para o SEFAZ(Secretaria da Fazenda)
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error_enviar_nfe
     */
    public function enviar_nfe($pedido_id, $nfe_id)
    {

        self::atualizar_token();
        $res = BlingApi::enviar_nfe(self::get_credenciais(), $nfe_id);

      
    }

    /**
     * @method gerar_enviar_nfe
     * @param $pedido  | required
     * @param $produto | required
     * @param $cliente | required
     * @description Vai gerar a NFE na Bling e imediatamente enviar para o SEFAZ
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error_enviar_nfe
     */
    public function gerar_enviar_nfe($pedido, $produto, $cliente)
    {
        self::atualizar_token();

    }

    static function get_credenciais()
    {
        $data = (new Factory('integracao'))->find(1);
        $data->bling_callback_url = self::get_callback_url();
        $data->bling_auth_url = self::get_auth_url($data);
        return $data;
    }

    static function get_auth_url($data)
    {
        $state = uniqid();
        $redirect_uri = self::get_callback_url();
        $url = "https://www.bling.com.br/OAuth2/views/authorization.php?response_type=code&client_id=$data->integracao_client_id&redirect_uri=$redirect_uri&state=$state";
        return $url;
    }

    static function get_callback_url()
    {
        $redirect_uri = Http::base() . '/bling/gravar_token/';
        return $redirect_uri;
    }

    /**
     * O token da Bling ele expira em 21600 segundos(6 horas)
     * Esse metodo vai checar quanto tempo falta para expirar o token 
     * @return true | se tiver ainda tiver menos de 5 horas desde que foi criado/atualizado
     * @return false | se tiver ainda tiver 5 horas ou mais desde que foi criado/atualizado
     */
    public function check_token_timelimit()
    {
        $timestamp_atual = date('Y-m-d H:i:s');

        $refresh = (new Factory('integracao'))
            ->select("integracao_id")
            ->where("integracao_id = 1 AND TIMESTAMPDIFF(HOUR,integracao_datetime_refresh_token,'$timestamp_atual') <= 5")
            ->get();

        $refresh = (isset($refresh[0]) && is_array($refresh)) ? true : false;
        return $refresh;
    }
}
