<?php

class AtributosAdmin
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config']
        ];
        Tpl::view('admin.produto.atributos.index', $data, 1);
    }

    public function lista()
    {
        (new Factory('atributo'))
            ->select("atributo_id, atributo_nome, atributo_tipo, CASE atributo_tipo WHEN 1 THEN 'Normal' WHEN 2 THEN 'Hexadecimal' WHEN 3 THEN 'Foto' WHEN 4 THEN 'Botão' END AS atributo_tipo_nome")
            ->order('atributo_id DESC')
            ->get(1);
    }

    public function listaItens()
    {
        $atributo = Http::get_in_params('listaItens');
        if (isset($atributo->value) && intval($atributo->value) > 0) {
            $atributo = intval($atributo->value);
            (new Factory('item_atributo'))
                ->select("item_atributo_id, item_atributo_nome")
                ->where('item_atributo_atributo = ' . $atributo)
                ->order('item_atributo_id DESC')
                ->get(1);
        }
    }

    public function gravarItem()
    {
        if (isset($_POST['item_atributo_nome']) && !empty($_POST['item_atributo_nome'])) {
            Sessao::perms('G');
            Req::drop('_wysihtml5_mode');
            Req::drop_blank();
            $_POST = Filter::parse_full($_POST);
            $escope = [
                'nome' => 'text'
            ];
            $atributo = (new Factory('item_atributo'))->with($_POST)->format($escope)->save();
            if ($atributo > 0) {
                Http::redirect_to('/AtributosAdmin/item/' . $_POST['item_atributo_atributo'] . '/?success');
            } else {
                Http::redirect_to('/AtributosAdmin/item/' . $_POST['item_atributo_atributo'] . '/?error');
            }
        }
    }

    public function gravar()
    {
        if (isset($_POST['atributo_nome']) && !empty($_POST['atributo_nome'])) {
            Sessao::perms('G');
            Req::drop('_wysihtml5_mode');
            Req::drop_blank();
            $escope = [
                'nome' => 'text'
            ];
            $_POST = Filter::parse_full($_POST);
            $atributo = (new Factory('atributo'))->with($_POST)->format($escope)->save();
            if ($atributo > 0) {
                Http::redirect_to('/produtos-atributos/?success');
            } else {
                Http::redirect_to('/produtos-atributos/?error');
            }
        }
    }

    public function item()
    {
        $atributo = Http::get_in_params('item');
        if (isset($atributo->value) && intval($atributo->value) > 0) {
            $atributo = intval($atributo->value);
            $att = (new Factory('atributo'))
                ->where('atributo_id = ' . $atributo)
                ->get();
            $data = [
                'atributo' => $att[0],                
                'config' => (new Config)->get(),
                'mapper' => ['config', 'atributo']
            ];
            Tpl::view('admin.produto.atributos.itens', $data, 1);
        }
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('item_atributo'))->where("item_atributo_atributo = $id")->drop();
            (new Factory('atributo'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function removerItem()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('item_atributo'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }
}
