<?php
if(!function_exists("antiSQL")) {
function antiSQL($campo, $adicionaBarras = false) {
// remove palavras que contenham sintaxe sql perigosa apenas no início/meio de palavras
$campo = preg_replace("/\b(drop table|alter table|delete from|insert into|update set|union select|show tables)\b/i","[BLOQUEADO]",$campo);
// CORRIGIR: Apenas bloquear comentários SQL reais, NÃO entidades HTML
$campo = preg_replace("/(\-\-\s|\/\*|\*\/)/","[COMENTARIO_BLOQUEADO]",$campo);
$campo = trim($campo);//limpa espaços vazio
// Não remove tags HTML aqui pois pode afetar conteúdo legítimo
// get_magic_quotes_gpc() removida no PHP 8.0, sempre aplicamos addslashes se necessário
if($adicionaBarras)
$campo = addslashes($campo);
return $campo;
} }
?>

<?php
if(!function_exists("antiSQLTextB")) {
function antiSQLTextB($campo, $adicionaBarras = false) {
// remove palavras que contenham sintaxe sql perigosa para campos de texto
$campo = preg_replace("/\b(drop table|alter table|delete from|insert into|update set|union select|show tables)\b/i","[BLOQUEADO]",$campo);
$campo = preg_replace("/(--|\/\*|\*\/)/","[COMENTARIO_BLOQUEADO]",$campo);
$campo = trim($campo);//limpa espaços vazio
// Mantém tags HTML para campos de texto
// get_magic_quotes_gpc() removida no PHP 8.0, sempre aplicamos addslashes se necessário
if($adicionaBarras)
$campo = addslashes($campo);
return $campo;
} }
?>

<?php
if(!function_exists("antiSQLColor")) {
function antiSQLColor($campo, $adicionaBarras = false) {
// Função específica para campos de cores - preserva # para cores hexadecimais
$campo = preg_replace("/\b(drop table|alter table|delete from|insert into|update set|union select|show tables)\b/i","[BLOQUEADO]",$campo);
// NÃO remove # pois é necessário para cores hexadecimais
$campo = preg_replace("/(--|\/\*|\*\/)/","[COMENTARIO_BLOQUEADO]",$campo);
$campo = trim($campo);//limpa espaços vazio
// Validar se é uma cor hexadecimal válida
if (preg_match("/^#[a-fA-F0-9]{6}$/", $campo)) {
    // É uma cor hexadecimal válida, manter como está
} elseif (preg_match("/^[a-fA-F0-9]{6}$/", $campo)) {
    // É uma cor sem #, adicionar o #
    $campo = '#' . $campo;
}
// get_magic_quotes_gpc() removida no PHP 8.0, sempre aplicamos addslashes se necessário
if($adicionaBarras)
$campo = addslashes($campo);
return $campo;
} }
?>

<?php
if(!function_exists("antiSQLRichText")) {
function antiSQLRichText($campo, $adicionaBarras = false) {
// Função específica para campos de texto rico (TinyMCE) - preserva HTML corretamente
if (empty($campo)) return '';

// Bloquear apenas SQL injection perigoso, NÃO caracteres HTML válidos
$campo = preg_replace("/\b(drop\s+table|alter\s+table|delete\s+from|insert\s+into|update\s+set|union\s+select|show\s+tables)\b/i","[BLOQUEADO]",$campo);
$campo = preg_replace("/(\-\-\s|\/\*|\*\/)/","[COMENTARIO_BLOQUEADO]",$campo);

// CORRIGIR: Remover caracteres \r\n LITERAIS que o TinyMCE adiciona indevidamente
$campo = str_replace(['\r\n', '\r', '\n', "\r\n", "\r", "\n"], '', $campo);

// Remover múltiplas aplicações de stripslashes até não haver mais mudança
$previous = '';
while ($previous !== $campo) {
    $previous = $campo;
    $campo = stripslashes($campo);
}

// Limpar múltiplas barras invertidas consecutivas
$campo = preg_replace('/\\\\{2,}/', '\\', $campo);

// NÃO remover barras de entidades HTML válidas como &#227; &#233; etc
// Apenas remover barras de caracteres que realmente não precisam de escape
$campo = str_replace(['\(', '\)', '\[', '\]'], ['(', ')', '[', ']'], $campo);

// Limpar espaços vazios e normalizar HTML
$campo = preg_replace('/<p[^>]*>\s*<\/p>/', '', $campo); // Remove parágrafos vazios
$campo = preg_replace('/<br\s*\/?>\s*<br\s*\/?>/', '<br>', $campo); // Remove BRs duplos
$campo = preg_replace('/>\s+</', '><', $campo); // Remove espaços entre tags

$campo = trim($campo);

// Escape básico do MySQL sem duplicação
global $conn;
if ($conn && !empty($campo)) {
    $campo = mysqli_real_escape_string($conn, $campo);
}

return $campo;
} }

if(!function_exists("displayRichText")) {
function displayRichText($campo) {
// Função para exibir corretamente campos de texto rico salvos no banco
if (empty($campo)) return '';

// CORRIGIR: Remover caracteres \r\n LITERAIS que aparecem na visualização
$campo = str_replace(['\r\n', '\r', '\n'], '', $campo);

// Remover múltiplos escapes que podem ter sido salvos
$previous = '';
while ($previous !== $campo) {
    $previous = $campo;
    $campo = stripslashes($campo);
}

// Limpar barras extras desnecessárias
$campo = preg_replace('/\\\\{2,}/', '', $campo);

// NÃO mexer em entidades HTML como &#227; etc, apenas limpar caracteres simples
$campo = str_replace(['\(', '\)', '\[', '\]'], ['(', ')', '[', ']'], $campo);

// Remover múltiplas quebras de linha HTML consecutivas
$campo = preg_replace('/<p[^>]*>\s*<\/p>/', '', $campo); // Remove parágrafos vazios
$campo = preg_replace('/<br\s*\/?>\s*<br\s*\/?>/', '<br>', $campo); // Remove BRs consecutivos
$campo = preg_replace('/>\s+</', '><', $campo); // Remove espaços entre tags

return $campo;
} }
?>