<?php include 'includes/tema/topo.php'; ?>
<?php include 'includes/dynamic_queries.php'; ?>

<?php 
// Processar upload de mídias (imagens e vídeos) para backgrounds das páginas
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['Alterar'])) {
    
    // Criar diretório de uploads se não existir
    $upload_dir = '../uploads/page_backgrounds/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    // Processar uploads de mídia para cada página (1 a 20)
    for ($i = 1; $i <= 20; $i++) {
        $media_field = "pagina{$i}_media";
        $tipo_field = "pagina{$i}_media_tipo";
        $file_field = "pagina{$i}_media_file";
        $url_field = "pagina{$i}_media_url";
        
        // Se selecionou 'video' e forneceu URL
        if (isset($_POST[$tipo_field]) && $_POST[$tipo_field] === 'video' && !empty($_POST[$url_field])) {
            $_POST[$media_field] = antisql($_POST[$url_field]);
        }
        // Se selecionou 'imagem' e fez upload de arquivo
        elseif (isset($_POST[$tipo_field]) && $_POST[$tipo_field] === 'imagem' && isset($_FILES[$file_field]) && $_FILES[$file_field]['error'] === 0) {
            $file = $_FILES[$file_field];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            
            if (in_array($ext, $allowed)) {
                $filename = "page{$i}_bg_" . time() . ".{$ext}";
                $filepath = $upload_dir . $filename;
                
                if (move_uploaded_file($file['tmp_name'], $filepath)) {
                    $_POST[$media_field] = 'uploads/page_backgrounds/' . $filename;
                }
            }
        }
        // Se selecionou 'nenhum', limpar campo
        elseif (isset($_POST[$tipo_field]) && $_POST[$tipo_field] === 'nenhum') {
            $_POST[$media_field] = '';
        }
    }
}

// Processar todas as operações de configuração automaticamente
$result = processConfigOperations('paginas', null, [], 'paginas');
$acao = $result['acao'];

// Configuração de páginas - Nomes e ícones
$paginas_config = [
    1 => ['nome' => 'Home/Slider', 'icone' => 'fa-home', 'editor' => false],
    2 => ['nome' => 'Sobre Nós / A Empresa', 'icone' => 'fa-briefcase', 'editor' => true],
    3 => ['nome' => 'Missão', 'icone' => 'fa-bullseye', 'editor' => false],
    4 => ['nome' => 'Equipe', 'icone' => 'fa-users', 'editor' => false],
    5 => ['nome' => 'Serviços', 'icone' => 'fa-cogs', 'editor' => false],
    6 => ['nome' => 'Agenda', 'icone' => 'fa-calendar', 'editor' => false],
    7 => ['nome' => 'Fotos / Galeria', 'icone' => 'fa-camera', 'editor' => false],
    8 => ['nome' => 'Portfolio', 'icone' => 'fa-briefcase', 'editor' => false],
    9 => ['nome' => 'Produtos', 'icone' => 'fa-shopping-cart', 'editor' => false],
    10 => ['nome' => 'Vídeos', 'icone' => 'fa-video-camera', 'editor' => false],
    11 => ['nome' => 'Blog / Notícias', 'icone' => 'fa-newspaper-o', 'editor' => false],
    12 => ['nome' => 'Contato (Especial)', 'icone' => 'fa-envelope', 'editor' => false],
    13 => ['nome' => 'Músicas / Áudio', 'icone' => 'fa-music', 'editor' => false],
    14 => ['nome' => 'Página Extra 1', 'icone' => 'fa-file-o', 'editor' => false],
    15 => ['nome' => 'Página Extra 2', 'icone' => 'fa-file-o', 'editor' => false],
    16 => ['nome' => 'Página Extra 3', 'icone' => 'fa-file-o', 'editor' => false],
    17 => ['nome' => 'Página Extra 4', 'icone' => 'fa-file-o', 'editor' => false],
    18 => ['nome' => 'Página Extra 5', 'icone' => 'fa-file-o', 'editor' => false],
    19 => ['nome' => 'Página Extra 6', 'icone' => 'fa-file-o', 'editor' => false],
    20 => ['nome' => 'Contato Principal', 'icone' => 'fa-phone', 'editor' => false],
];
?>

<style type="text/css">
    .bootstrap-tagsinput {
        background-color: aliceblue;
    }
    
    .media-preview {
        max-width: 300px;
        max-height: 200px;
        margin-top: 10px;
        border: 2px solid #ddd;
        border-radius: 4px;
    }
    
    .media-selector {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        margin: 15px 0;
        border: 1px solid #dee2e6;
    }
    
    .media-selector h5 {
        color: #495057;
        margin-bottom: 15px;
        font-weight: 600;
    }
    
    .media-option {
        display: none;
        padding: 15px;
        background: white;
        border-radius: 4px;
        margin-top: 10px;
    }
    
    .media-option.active {
        display: block;
    }
    
    .page-number-badge {
        background: #007bff;
        color: white;
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 12px;
        margin-right: 5px;
    }
    
    /* CORREÇÃO: Garantir que inputs são editáveis */
    .gui-input,
    .gui-textarea,
    input[type="text"],
    input[type="file"],
    select,
    textarea {
        pointer-events: auto !important;
        user-select: text !important;
        -webkit-user-select: text !important;
        -moz-user-select: text !important;
        -ms-user-select: text !important;
    }
    
    /* Remover qualquer overlay que possa estar bloqueando */
    .field::before,
    .field::after {
        pointer-events: none !important;
    }
    
    /* Forçar visibilidade do TinyMCE */
    .tox-tinymce {
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    .tox .tox-edit-area__iframe {
        visibility: visible !important;
        opacity: 1 !important;
        pointer-events: auto !important;
    }
    
    /* Forçar que o conteúdo do TinyMCE seja editável */
    .tox-edit-area__iframe body {
        pointer-events: auto !important;
        user-select: text !important;
        -webkit-user-select: text !important;
    }
    
    /* Remover qualquer overlay sobre TinyMCE */
    .tox-tinymce::before,
    .tox-tinymce::after,
    .tox-edit-area::before,
    .tox-edit-area::after {
        display: none !important;
        pointer-events: none !important;
    }
</style>

<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Configurações</a></li>
                            <li class="breadcrumb-item" aria-current="page">Páginas</li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">Configuração de Páginas</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

        <?php 
        $sql = mysqli_query($conn, "SELECT * FROM paginas WHERE id = 0")->fetch_assoc();
        if (!$sql) {
            // Criar registro padrão se não existir
            mysqli_query($conn, "INSERT INTO paginas (id) VALUES (0)");
            $sql = mysqli_query($conn, "SELECT * FROM paginas WHERE id = 0")->fetch_assoc();
        }
        ?>

        <div class="smart-wrap">
            <div class="smart-forms smart-container wrap-0">
                <div class="form-header header-blue bg-primary">
                    <h4><i class="fa fa-copy"></i> Configuração de Páginas (20 Páginas Disponíveis)</h4>
                </div>

                <form name="configuracoes" id="configuracoes" method="post" 
                      action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
                    
                    <div class="form-body">
                        <div class="row">
                            <div class="col-lg-12 mb-4 mb-lg-0">
                                <div class="accordion accordion-lg" id="acordeon1">
                                    
                                    <?php 
                                    // LOOP DINÂMICO - GERA TODOS OS 20 ACORDEONS AUTOMATICAMENTE
                                    foreach ($paginas_config as $num => $config): 
                                        $campo_nome = "pagina{$num}";
                                        $campo_subtitulo = "pagina{$num}_subtitulo";
                                        $campo_status = "pagina{$num}_status";
                                        $campo_media = "pagina{$num}_media";
                                        $campo_media_tipo = "pagina{$num}_media_tipo";
                                        
                                        // Valores atuais
                                        $valor_nome = htmlspecialchars($sql[$campo_nome] ?? '');
                                        $valor_subtitulo = $config['editor'] ? displayRichText($sql[$campo_subtitulo] ?? '') : htmlspecialchars($sql[$campo_subtitulo] ?? '');
                                        $valor_status = $sql[$campo_status] ?? '1';
                                        $valor_media = htmlspecialchars($sql[$campo_media] ?? '');
                                        $valor_media_tipo = $sql[$campo_media_tipo] ?? 'nenhum';
                                        
                                        // Se for página 1 ou 2, abrir por padrão (página 2 tem TinyMCE)
                                        $collapse_class = ($num === 1 || $num === 2) ? 'show' : '';
                                        $aria_expanded = ($num === 1 || $num === 2) ? 'true' : 'false';
                                    ?>
                                    
                                    <!-- PÁGINA <?php echo $num; ?>: <?php echo strtoupper($config['nome']); ?> -->
                                    <div class="card card-default">
                                        <div class="card-header" id="acordeon<?php echo $num; ?>_header">
                                            <h4 class="card-title m-0">
                                                <a class="accordion-toggle" data-bs-toggle="collapse" 
                                                   data-bs-target="#acordeon<?php echo $num; ?>_abertura" 
                                                   aria-expanded="<?php echo $aria_expanded; ?>">
                                                    <span class="page-number-badge"><?php echo $num; ?></span>
                                                    <i class="fa <?php echo $config['icone']; ?>"></i>
                                                    <?php echo $config['nome']; ?>
                                                </a>
                                            </h4>
                                        </div>
                                        <div id="acordeon<?php echo $num; ?>_abertura" 
                                             class="collapse <?php echo $collapse_class; ?>" 
                                             aria-labelledby="acordeon<?php echo $num; ?>_header" 
                                             data-bs-parent="#acordeon1">
                                            <div class="card-body">
                                                
                                                <!-- NOME DA PÁGINA -->
                                                <div class="frm-row">
                                                    <div class="section colm colm2"></div>
                                                    <div class="section colm colm8">
                                                        <label class="field prepend-icon">
                                                            <input type="text" name="<?php echo $campo_nome; ?>" 
                                                                   id="<?php echo $campo_nome; ?>"
                                                                   class="gui-input" 
                                                                   placeholder="Nome da Página <?php echo $num; ?>"
                                                                   value="<?php echo $valor_nome; ?>">
                                                            <span class="field-icon">
                                                                <i class="fa <?php echo $config['icone']; ?>"></i>
                                                            </span>
                                                        </label>
                                                    </div>
                                                </div>

                                                <!-- SUBTÍTULO/DESCRIÇÃO -->
                                                <div class="frm-row">
                                                    <?php if ($config['editor']): ?>
                                                        <!-- Editor rico (TinyMCE) para páginas específicas -->
                                                        <div class="section colm colm12">
                                                            <textarea class="gui-textarea" 
                                                                      id="<?php echo $campo_subtitulo; ?>" 
                                                                      name="<?php echo $campo_subtitulo; ?>" 
                                                                      placeholder="Escreva o Subtítulo" 
                                                                      rows="8" 
                                                                      cols="50"><?php echo $valor_subtitulo; ?></textarea>
                                                        </div>
                                                    <?php else: ?>
                                                        <!-- Campo de texto simples -->
                                                        <div class="section colm colm2"></div>
                                                        <div class="section colm colm8">
                                                            <label class="field prepend-icon">
                                                                <input type="text" 
                                                                       name="<?php echo $campo_subtitulo; ?>" 
                                                                       class="gui-input" 
                                                                       placeholder="Subtítulo / Descrição"
                                                                       value="<?php echo $valor_subtitulo; ?>">
                                                                <span class="field-icon">
                                                                    <i class="fa fa-text-height"></i>
                                                                </span>
                                                            </label>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>

                                                <!-- CAMPOS ESPECIAIS PARA PÁGINA 12 (Contato) -->
                                                <?php if ($num === 12): ?>
                                                <div class="frm-row">
                                                    <div class="section colm colm2"></div>
                                                    <div class="section colm colm4">
                                                        <label class="field prepend-icon">
                                                            <input type="text" name="pagina12_link" 
                                                                   class="gui-input" placeholder="Link/Âncora"
                                                                   value="<?php echo htmlspecialchars($sql['pagina12_link'] ?? ''); ?>">
                                                            <span class="field-icon"><i class="fa fa-link"></i></span>
                                                        </label>
                                                    </div>
                                                    <div class="section colm colm4">
                                                        <label class="field prepend-icon">
                                                            <input type="text" name="pagina12_nome_link" 
                                                                   class="gui-input" placeholder="Nome do Link"
                                                                   value="<?php echo htmlspecialchars($sql['pagina12_nome_link'] ?? ''); ?>">
                                                            <span class="field-icon"><i class="fa fa-tag"></i></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <?php endif; ?>

                                                <!-- SELETOR DE MÍDIA (IMAGEM OU VÍDEO) -->
                                                <div class="media-selector">
                                                    <h5><i class="fa fa-picture-o"></i> Mídia de Fundo da Seção</h5>
                                                    
                                                    <div class="frm-row">
                                                        <div class="section colm colm12">
                                                            <select name="<?php echo $campo_media_tipo; ?>" 
                                                                    id="<?php echo $campo_media_tipo; ?>"
                                                                    class="gui-input media-type-selector" 
                                                                    data-page="<?php echo $num; ?>">
                                                                <option value="nenhum" <?php echo $valor_media_tipo === 'nenhum' ? 'selected' : ''; ?>>
                                                                    🚫 Sem Mídia (Usar Cor Sólida/Gradiente CSS)
                                                                </option>
                                                                <option value="imagem" <?php echo $valor_media_tipo === 'imagem' ? 'selected' : ''; ?>>
                                                                    🖼️ Imagem de Fundo
                                                                </option>
                                                                <option value="video" <?php echo $valor_media_tipo === 'video' ? 'selected' : ''; ?>>
                                                                    🎬 Vídeo de Fundo
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <!-- OPÇÃO: UPLOAD DE IMAGEM -->
                                                    <div class="media-option media-option-<?php echo $num; ?>-imagem <?php echo $valor_media_tipo === 'imagem' ? 'active' : ''; ?>">
                                                        <label class="field">
                                                            <strong>📁 Upload de Imagem:</strong>
                                                            <input type="file" 
                                                                   name="pagina<?php echo $num; ?>_media_file" 
                                                                   accept="image/jpeg,image/png,image/gif,image/webp"
                                                                   class="gui-input">
                                                            <small style="color: #6c757d;">
                                                                Formatos aceitos: JPG, PNG, GIF, WEBP | Tamanho recomendado: 1920x1080px
                                                            </small>
                                                        </label>
                                                        <?php if (!empty($valor_media) && $valor_media_tipo === 'imagem'): ?>
                                                            <div style="margin-top: 10px;">
                                                                <strong>Preview atual:</strong><br>
                                                                <img src="../<?php echo $valor_media; ?>" 
                                                                     class="media-preview" alt="Preview da imagem">
                                                                <input type="hidden" name="<?php echo $campo_media; ?>" 
                                                                       value="<?php echo $valor_media; ?>">
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>

                                                    <!-- OPÇÃO: URL DE VÍDEO -->
                                                    <div class="media-option media-option-<?php echo $num; ?>-video <?php echo $valor_media_tipo === 'video' ? 'active' : ''; ?>">
                                                        <label class="field prepend-icon">
                                                            <strong>🔗 URL do Vídeo:</strong>
                                                            <input type="text" 
                                                                   name="pagina<?php echo $num; ?>_media_url" 
                                                                   class="gui-input" 
                                                                   placeholder="Cole a URL aqui..."
                                                                   value="<?php echo $valor_media_tipo === 'video' ? $valor_media : ''; ?>">
                                                            <span class="field-icon"><i class="fa fa-link"></i></span>
                                                        </label>
                                                        <small style="color: #6c757d; display: block; margin-top: 5px;">
                                                            <strong>Exemplos válidos:</strong><br>
                                                            • YouTube: https://www.youtube.com/embed/VIDEO_ID<br>
                                                            • Vídeo local: uploads/videos/meu-video.mp4<br>
                                                            • Vimeo: https://player.vimeo.com/video/VIDEO_ID
                                                        </small>
                                                    </div>
                                                </div>

                                                <!-- STATUS ON/OFF -->
                                                <div class="spacer-b30">
                                                    <div class="tagline">
                                                        <span style="color: black">
                                                            <i class="fa fa-power-off"></i> Página Ativa?
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="frm-row">
                                                    <div class="section colm colm5"></div>
                                                    <div class="section colm colm1">
                                                        <label class="switch switch-round block">
                                                            <input type="radio" name="<?php echo $campo_status; ?>" 
                                                                   value="1" <?php echo $valor_status == '1' ? 'checked' : ''; ?>>
                                                            <span class="switch-label" data-on="ON"></span>
                                                        </label>
                                                    </div>
                                                    <div class="section colm colm1">
                                                        <label class="switch switch-round block">
                                                            <input type="radio" name="<?php echo $campo_status; ?>" 
                                                                   value="0" <?php echo $valor_status == '0' ? 'checked' : ''; ?>>
                                                            <span class="switch-label" data-on="OFF"></span>
                                                        </label>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    
                                    <?php endforeach; ?>
                                    <!-- FIM DO LOOP DINÂMICO -->

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-footer" align="center">
                        <input type="hidden" name="Alterar" value="ok">
                        <button type="submit" class="button btn-primary btn-lg">
                            <i class="fa fa-save"></i> Salvar Todas as Configurações
                        </button>
                        <button type="button" class="button btn-secondary btn-lg" 
                                onclick="location.href='<?php echo $_SERVER['PHP_SELF']; ?>'">
                            <i class="fa fa-refresh"></i> Cancelar / Recarregar
                        </button>
                    </div>

                </form>
            </div>
        </div>

    </div>
</section>

<?php include 'includes/tema/base.php'; ?>

<!-- TinyMCE JS -->
<script language="javascript" type="text/javascript" src="assets/js/plugins/tinymce/tinymce.min.js"></script>
<script language="javascript" type="text/javascript">
tinymce.init({
    selector: 'textarea#pagina2_subtitulo',
    readonly: false,
    setup: function(editor) {
        editor.on('init', function(e) {
            // Forçar contenteditable no iframe do TinyMCE
            var body = editor.getBody();
            body.setAttribute('contenteditable', 'true');
            body.removeAttribute('readonly');
            body.style.cursor = 'text';
            
            // Remover qualquer atributo que possa bloquear
            var iframe = editor.getContentAreaContainer().querySelector('iframe');
            if (iframe) {
                iframe.removeAttribute('readonly');
                iframe.removeAttribute('disabled');
            }
            
            console.log('TinyMCE pronto para edição');
            console.log('contenteditable:', body.getAttribute('contenteditable'));
            
            // Testar clicando no body
            body.click();
            editor.focus();
        });
        editor.on('change', function(e) {
            editor.save();
        });
    },
    language: 'pt_BR',
    browser_spellcheck: true,
    language_url: 'assets/js/plugins/tinymce/langs/pt_BR.js',
    
    // TODOS os 45 plugins que existem no servidor
    plugins: 'accordion advlist anchor autolink autoresize autosave bbcode charmap code codesample colorpicker contextmenu directionality emoticons fullpage fullscreen help hr image imagetools importcss insertdatetime legacyoutput link lists media nonbreaking noneditable pagebreak paste preview print quickbars save searchreplace spellchecker tabfocus table template textcolor textpattern toc visualblocks visualchars wordcount',
    
    toolbar: 'undo redo | formatselect | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright alignjustify | numlist bullist outdent indent | link image media table | code fullscreen | removeformat',
    
    entity_encoding: "numeric",
    valid_elements: '*[*]',
    element_format: 'html,php,java',
    extended_valid_elements: 'input[placeholder|accept|alt|checked|disabled|maxlength|name|readonly|size|src|type|value|header]'

});
</script>

<script>
// CORREÇÃO: Garantir que todos os inputs são editáveis ao carregar a página
document.addEventListener('DOMContentLoaded', function() {
    // Remover readonly de todos os inputs
    document.querySelectorAll('input, textarea, select').forEach(function(field) {
        field.removeAttribute('readonly');
        field.removeAttribute('disabled');
        field.style.pointerEvents = 'auto';
        field.style.userSelect = 'text';
    });
    
    console.log('Campos de input liberados para edição');
    
    // FORÇA ADICIONAL: Remover bloqueios do TinyMCE após 2 segundos
    setTimeout(function() {
        var tinymceIframe = document.querySelector('.tox-edit-area__iframe');
        if (tinymceIframe) {
            var iframeDoc = tinymceIframe.contentDocument || tinymceIframe.contentWindow.document;
            var body = iframeDoc.body;
            
            if (body) {
                body.setAttribute('contenteditable', 'true');
                body.style.pointerEvents = 'auto';
                body.style.userSelect = 'text';
                body.removeAttribute('readonly');
                body.removeAttribute('disabled');
                
                // Remover qualquer listener de mousedown/click que possa estar bloqueando
                var clone = body.cloneNode(true);
                body.parentNode.replaceChild(clone, body);
                
                console.log('TinyMCE iframe forçado a ser editável');
            }
        }
    }, 2000);
});

// Toggle entre opções de mídia (imagem/vídeo/nenhum) - DINÂMICO
document.querySelectorAll('.media-type-selector').forEach(function(select) {
    select.addEventListener('change', function() {
        var page = this.dataset.page;
        var tipo = this.value;
        
        // Esconder todas as opções desta página
        document.querySelectorAll('.media-option-' + page + '-imagem, .media-option-' + page + '-video').forEach(function(el) {
            el.classList.remove('active');
        });
        
        // Mostrar opção selecionada
        if (tipo !== 'nenhum') {
            var targetClass = '.media-option-' + page + '-' + tipo;
            var targetEl = document.querySelector(targetClass);
            if (targetEl) {
                targetEl.classList.add('active');
            }
        }
    });
});

// Preview de imagens antes do upload
document.querySelectorAll('input[type="file"][accept*="image"]').forEach(function(input) {
    input.addEventListener('change', function(e) {
        var file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            var reader = new FileReader();
            reader.onload = function(e) {
                // Procurar ou criar preview
                var container = input.closest('.media-option');
                var preview = container.querySelector('.media-preview');
                
                if (!preview) {
                    var previewDiv = document.createElement('div');
                    previewDiv.style.marginTop = '10px';
                    previewDiv.innerHTML = '<strong>Preview:</strong><br>';
                    
                    preview = document.createElement('img');
                    preview.className = 'media-preview';
                    
                    previewDiv.appendChild(preview);
                    container.appendChild(previewDiv);
                }
                
                preview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });
});

// Confirmação antes de sair se houver mudanças não salvas
var formModified = false;
document.getElementById('configuracoes').addEventListener('change', function() {
    formModified = true;
});

window.addEventListener('beforeunload', function(e) {
    if (formModified) {
        e.preventDefault();
        e.returnValue = 'Você tem alterações não salvas. Deseja realmente sair?';
    }
});

document.getElementById('configuracoes').addEventListener('submit', function() {
    formModified = false; // Reset ao salvar
});

// Scroll suave para acordeons
document.querySelectorAll('.accordion-toggle').forEach(function(toggle) {
    toggle.addEventListener('click', function() {
        setTimeout(function() {
            toggle.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 350); // Aguardar animação do collapse
    });
});
</script>
