<?php 
// Incluir conexão com banco de dados
include 'dbconfig.php';

// Consultas para obter dados reais do banco
$query_usuarios = "SELECT COUNT(*) as total_usuarios FROM usuarios";
$result_usuarios = mysqli_query($conn, $query_usuarios);
$total_usuarios = mysqli_fetch_assoc($result_usuarios)['total_usuarios'];

$query_agenda = "SELECT COUNT(*) as total_agendas FROM agenda";
$result_agenda = mysqli_query($conn, $query_agenda);
$total_agendas = mysqli_fetch_assoc($result_agenda)['total_agendas'];

$query_agenda_situacao = "SELECT situacao, COUNT(*) as total FROM agenda GROUP BY situacao";
$result_agenda_situacao = mysqli_query($conn, $query_agenda_situacao);
$agenda_situacoes = [];
while($row = mysqli_fetch_assoc($result_agenda_situacao)) {
    $agenda_situacoes[] = $row;
}

$query_produtos = "SELECT COUNT(*) as total_produtos FROM produtos";
$result_produtos = mysqli_query($conn, $query_produtos);
$total_produtos = mysqli_fetch_assoc($result_produtos)['total_produtos'];

$query_blog = "SELECT COUNT(*) as total_posts FROM blog";
$result_blog = mysqli_query($conn, $query_blog);
$total_posts = mysqli_fetch_assoc($result_blog)['total_posts'];

$query_anotacoes = "SELECT COUNT(*) as total_anotacoes FROM anotacoes";
$result_anotacoes = mysqli_query($conn, $query_anotacoes);
$total_anotacoes = mysqli_fetch_assoc($result_anotacoes)['total_anotacoes'];

// Novos módulos do sistema
$query_equipe = "SELECT COUNT(*) as total_equipe FROM equipe";
$result_equipe = mysqli_query($conn, $query_equipe);
$total_equipe = mysqli_fetch_assoc($result_equipe)['total_equipe'];

$query_fotos = "SELECT COUNT(*) as total_fotos FROM fotos";
$result_fotos = mysqli_query($conn, $query_fotos);
$total_fotos = mysqli_fetch_assoc($result_fotos)['total_fotos'];

$query_missao = "SELECT COUNT(*) as total_missao FROM missao";
$result_missao = mysqli_query($conn, $query_missao);
$total_missao = mysqli_fetch_assoc($result_missao)['total_missao'];

$query_slider = "SELECT COUNT(*) as total_slider FROM slider";
$result_slider = mysqli_query($conn, $query_slider);
$total_slider = mysqli_fetch_assoc($result_slider)['total_slider'];

$query_videos = "SELECT COUNT(*) as total_videos FROM videos";
$result_videos = mysqli_query($conn, $query_videos);
$total_videos = mysqli_fetch_assoc($result_videos)['total_videos'];

$query_musicas = "SELECT COUNT(*) as total_musicas FROM musicas";
$result_musicas = mysqli_query($conn, $query_musicas);
$total_musicas = mysqli_fetch_assoc($result_musicas)['total_musicas'];

// Variáveis calculadas para o dashboard
$total_tarefas = $total_agendas + $total_anotacoes;
$tarefas_pendentes = 0; // Será calculado baseado em agendas não atendidas
$query_pendentes = "SELECT COUNT(*) as pendentes FROM agenda WHERE situacao NOT IN ('Atendido')";
$result_pendentes = mysqli_query($conn, $query_pendentes);
$tarefas_pendentes = mysqli_fetch_assoc($result_pendentes)['pendentes'];

// Agendas por profissional
$query_agenda_profissional = "SELECT u.nome, COUNT(a.id) as total 
    FROM agenda a 
    LEFT JOIN usuarios u ON a.id_profissional = u.id 
    GROUP BY a.id_profissional, u.nome";
$result_agenda_profissional = mysqli_query($conn, $query_agenda_profissional);
$agenda_profissional = [];
while($row = mysqli_fetch_assoc($result_agenda_profissional)) {
    $agenda_profissional[] = $row;
}

// Últimas agendas para seção de transações
$query_ultimas_agendas = "SELECT a.*, u.nome as nome_paciente, u2.nome as nome_profissional, ac.nome_categoria
    FROM agenda a 
    LEFT JOIN usuarios u ON a.id_paciente = u.id 
    LEFT JOIN usuarios u2 ON a.id_profissional = u2.id 
    LEFT JOIN agenda_categoria ac ON a.id_categoria = ac.id 
    ORDER BY a.id DESC LIMIT 10";
$result_ultimas_agendas = mysqli_query($conn, $query_ultimas_agendas);
$ultimas_agendas = [];
while($row = mysqli_fetch_assoc($result_ultimas_agendas)) {
    $ultimas_agendas[] = $row;
}

// Produtos mais recentes
$query_ultimos_produtos = "SELECT p.*, pm.marca 
    FROM produtos p 
    LEFT JOIN produtos_marcas pm ON p.id_marca = pm.id 
    ORDER BY p.id DESC LIMIT 5";
$result_ultimos_produtos = mysqli_query($conn, $query_ultimos_produtos);
$ultimos_produtos = [];
while($row = mysqli_fetch_assoc($result_ultimos_produtos)) {
    $ultimos_produtos[] = $row;
}

// Estatísticas de produtos por marca
$query_produtos_marca = "SELECT pm.marca, COUNT(p.id) as total, AVG(CAST(REPLACE(p.preco, ',', '.') AS DECIMAL(10,2))) as preco_medio
    FROM produtos p 
    LEFT JOIN produtos_marcas pm ON p.id_marca = pm.id 
    WHERE pm.marca IS NOT NULL
    GROUP BY p.id_marca, pm.marca
    ORDER BY total DESC";
$result_produtos_marca = mysqli_query($conn, $query_produtos_marca);
$produtos_por_marca = [];
while($row = mysqli_fetch_assoc($result_produtos_marca)) {
    $produtos_por_marca[] = $row;
}

// Total de tarefas (anotações + agendas)
$total_tarefas = $total_anotacoes + $total_agendas;
$tarefas_pendentes = 0;
$query_tarefas_pendentes = "SELECT COUNT(*) as total FROM agenda WHERE situacao IN ('Remarcado', 'Cancelado pelo paciente')";
$result_tarefas_pendentes = mysqli_query($conn, $query_tarefas_pendentes);
if($result_tarefas_pendentes) {
    $tarefas_pendentes = mysqli_fetch_assoc($result_tarefas_pendentes)['total'];
}

// Últimas atividades do blog
$query_ultimos_posts = "SELECT * FROM blog ORDER BY id DESC LIMIT 3";
$result_ultimos_posts = mysqli_query($conn, $query_ultimos_posts);
$ultimos_posts = [];
while($row = mysqli_fetch_assoc($result_ultimos_posts)) {
    $ultimos_posts[] = $row;
}
?>

<?php include 'includes/tema/topo.php'; ?>

<!-- [ Main Content ] start -->
<div class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <!-- Banner Principal -->
      <div class="col-12">
        <div class="card welcome-banner bg-primary mb-4">
          <div class="card-body">
            <div class="row align-items-center">
              <div class="col-sm-8">
                <div class="p-3">
                  <h2 class="text-white mb-2">Painel Administrativo Kubonet</h2>
                  <p class="text-white mb-3">Sistema de gestão completo com dados em tempo real do banco de dados.</p>
                  <a href="usuarios.php" class="btn btn-outline-light">
                    <i class="ti ti-settings me-2"></i>Gerenciar Sistema
                  </a>
                </div>
              </div>
              <div class="col-sm-4 text-center">
                <div class="img-welcome-banner">
                  <img src="assets/images/widget/welcome-banner.png" alt="Sistema Kubonet" class="img-fluid">
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Cards Principais de Estatísticas -->
      
      <!-- Row 1: Cards Principais -->
      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Usuários</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_usuarios; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-users me-1"></i>
                  <span class="text-success mr-2">Cadastrados</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-primary">
                  <i class="ti ti-users text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="usuarios.php" class="btn btn-primary btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Agendas</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_agendas; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-calendar me-1"></i>
                  <span class="text-warning mr-2">Registradas</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-warning">
                  <i class="ti ti-calendar text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="agenda.php" class="btn btn-warning btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Produtos</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_produtos; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-package me-1"></i>
                  <span class="text-success mr-2">Cadastrados</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-success">
                  <i class="ti ti-package text-white f-20"></i>
                </div>
              </div>
            </div>
            <div class="mt-2 text-center">
              <small class="text-muted">
                <i class="ti ti-info-circle me-1"></i>Dados do catálogo
              </small>
            </div>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Blog Posts</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_posts; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-edit me-1"></i>
                  <span class="text-info mr-2">Publicados</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-info">
                  <i class="ti ti-edit text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="blog.php" class="btn btn-info btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <!-- Row 2: Cards Secundários -->
      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-secondary shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">Equipe</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_equipe; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-users me-1"></i>
                  <span class="text-secondary mr-2">Membros</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-secondary">
                  <i class="ti ti-users text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="equipe.php" class="btn btn-secondary btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Fotos</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_fotos; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-camera me-1"></i>
                  <span class="text-primary mr-2">Galeria</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-primary">
                  <i class="ti ti-camera text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="fotos.php" class="btn btn-primary btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Missão</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_missao; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-target me-1"></i>
                  <span class="text-warning mr-2">Registros</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-warning">
                  <i class="ti ti-target text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="missao.php" class="btn btn-warning btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Slider</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_slider; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-photo me-1"></i>
                  <span class="text-success mr-2">Imagens</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-success">
                  <i class="ti ti-photo text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="slider.php" class="btn btn-success btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <!-- Row 3: Cards Finais -->
      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Vídeos</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_videos; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-video me-1"></i>
                  <span class="text-info mr-2">Biblioteca</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-info">
                  <i class="ti ti-video text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="videos.php" class="btn btn-info btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-danger shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Músicas</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_musicas; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-music me-1"></i>
                  <span class="text-danger mr-2">Playlist</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-danger">
                  <i class="ti ti-music text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="musicas.php" class="btn btn-danger btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
          <div class="card-body">
            <div class="row no-gutters align-items-center">
              <div class="col mr-2">
                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Anotações</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_anotacoes; ?></div>
                <div class="mt-2 mb-0 text-muted text-xs">
                  <i class="ti ti-notes me-1"></i>
                  <span class="text-warning mr-2">Registros</span>
                </div>
              </div>
              <div class="col-auto">
                <div class="icon-circle bg-warning">
                  <i class="ti ti-notes text-white f-20"></i>
                </div>
              </div>
            </div>
            <a href="anotacoes.php" class="btn btn-warning btn-sm mt-2 w-100">
              <i class="ti ti-external-link me-1"></i>Gerenciar
            </a>
          </div>
        </div>
      </div>

    </div>
    <!-- Fim dos Cards de Estatísticas -->

    <!-- Seção de Gráficos e Análises -->
    <div class="row mt-4">
      
      <!-- Gráfico de Usuários -->
      <div class="col-lg-6 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
              <i class="ti ti-users me-2"></i>Estatísticas de Usuários
            </h6>
            <div class="dropdown no-arrow">
              <a class="dropdown-toggle" href="usuarios.php" role="button">
                <i class="ti ti-external-link text-gray-400"></i>
              </a>
            </div>
          </div>
          <div class="card-body">
            <div class="chart-area">
              <div id="usuarios-graph"></div>
            </div>
            <div class="mt-3 text-center">
              <span class="text-xs font-weight-bold text-primary text-uppercase">Total: <?php echo $total_usuarios; ?> Usuários</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Gráfico de Agendas -->
      <div class="col-lg-6 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-warning">
              <i class="ti ti-calendar me-2"></i>Distribuição de Agendas
            </h6>
            <div class="dropdown no-arrow">
              <a class="dropdown-toggle" href="agenda.php" role="button">
                <i class="ti ti-external-link text-gray-400"></i>
              </a>
            </div>
          </div>
          <div class="card-body">
            <div class="chart-area">
              <div id="agendas-graph"></div>
            </div>
            <div class="mt-3 text-center">
              <span class="text-xs font-weight-bold text-warning text-uppercase">Total: <?php echo $total_agendas; ?> Agendas</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Gráfico de Produtos -->
      <div class="col-lg-6 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-success">
              <i class="ti ti-package me-2"></i>Análise de Produtos
            </h6>
            <div class="text-muted">
              <small><i class="ti ti-chart-bar me-1"></i>Visualização dos dados</small>
            </div>
          </div>
          <div class="card-body">
            <div class="chart-area">
              <div id="produtos-graph"></div>
            </div>
            <div class="mt-3 text-center">
              <span class="text-xs font-weight-bold text-success text-uppercase">Total: <?php echo $total_produtos; ?> Produtos</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Gráfico de Situações -->
      <div class="col-lg-6 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-info">
              <i class="ti ti-chart-pie me-2"></i>Análise Situacional
            </h6>
          </div>
          <div class="card-body">
            <div class="chart-area">
              <div id="situacao-graph"></div>
            </div>
            <div class="mt-3 text-center">
              <span class="text-xs font-weight-bold text-info text-uppercase">Distribuição por Status</span>
            </div>
          </div>
        </div>
      </div>

    </div>
    <!-- Fim da Seção de Gráficos -->

    <!-- Seção de Atividades Recentes e Resumos -->
    <div class="row mt-4">
      
      <!-- Atividades Recentes -->
      <div class="col-lg-8 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
              <i class="ti ti-activity me-2"></i>Atividades Recentes do Sistema
            </h6>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-hover">
                <thead class="table-dark">
                  <tr>
                    <th>Módulo</th>
                    <th>Ação</th>
                    <th>Status</th>
                    <th>Total</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><i class="ti ti-users text-primary"></i> Usuários</td>
                    <td>Cadastros Ativos</td>
                    <td><span class="badge bg-success">Ativo</span></td>
                    <td><strong><?php echo $total_usuarios; ?></strong></td>
                  </tr>
                  <tr>
                    <td><i class="ti ti-calendar text-warning"></i> Agendas</td>
                    <td>Eventos Programados</td>
                    <td><span class="badge bg-warning">Pendente</span></td>
                    <td><strong><?php echo $total_agendas; ?></strong></td>
                  </tr>
                  <tr>
                    <td><i class="ti ti-package text-success"></i> Produtos</td>
                    <td>Itens no Catálogo</td>
                    <td><span class="badge bg-info">Disponível</span></td>
                    <td><strong><?php echo $total_produtos; ?></strong></td>
                  </tr>
                  <tr>
                    <td><i class="ti ti-edit text-danger"></i> Blog</td>
                    <td>Posts Publicados</td>
                    <td><span class="badge bg-success">Publicado</span></td>
                    <td><strong><?php echo $total_posts; ?></strong></td>
                  </tr>
                  <tr>
                    <td><i class="ti ti-users text-info"></i> Equipe</td>
                    <td>Membros Ativos</td>
                    <td><span class="badge bg-primary">Ativo</span></td>
                    <td><strong><?php echo $total_equipe; ?></strong></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>

      <!-- Resumo de Mídia -->
      <div class="col-lg-4 mb-4">
        <div class="card shadow h-100">
          <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-warning">
              <i class="ti ti-photo me-2"></i>Biblioteca de Mídia
            </h6>
          </div>
          <div class="card-body">
            <div class="list-group list-group-flush">
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-camera text-primary me-2"></i>Fotos
                </div>
                <span class="badge bg-primary rounded-pill"><?php echo $total_fotos; ?></span>
              </div>
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-video text-info me-2"></i>Vídeos
                </div>
                <span class="badge bg-info rounded-pill"><?php echo $total_videos; ?></span>
              </div>
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-music text-danger me-2"></i>Músicas
                </div>
                <span class="badge bg-danger rounded-pill"><?php echo $total_musicas; ?></span>
              </div>
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-photo text-success me-2"></i>Slider
                </div>
                <span class="badge bg-success rounded-pill"><?php echo $total_slider; ?></span>
              </div>
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-notes text-warning me-2"></i>Anotações
                </div>
                <span class="badge bg-warning rounded-pill"><?php echo $total_anotacoes; ?></span>
              </div>
              <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                <div>
                  <i class="ti ti-target text-secondary me-2"></i>Missão
                </div>
                <span class="badge bg-secondary rounded-pill"><?php echo $total_missao; ?></span>
              </div>
            </div>
          </div>
        </div>

    </div>
    <!-- Fim da Seção de Atividades e Resumos -->

  </div>
  <!-- Fim do conteúdo principal -->
  
</div>
<!-- Fim do container -->

<?php include './includes/tema/footer.php'; ?>

<!-- Scripts dos Gráficos Personalizados -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  // Aguardar carregamento do ApexCharts
  setTimeout(function() {
    // Gráfico de Usuários
    var optionsUsuarios = {
      chart: { type: 'bar', height: 50, sparkline: { enabled: true } },
      colors: ['#4680FF'],
      plotOptions: { bar: { columnWidth: '80%' } },
      series: [{ data: [<?php echo $total_usuarios; ?>, <?php echo $total_usuarios + 1; ?>, <?php echo $total_usuarios; ?>] }],
      tooltip: {
        y: {
          title: {
            formatter: function (seriesName) {
              return 'Usuários: ';
            }
          }
        }
      }
    };
    var chartUsuarios = new ApexCharts(document.querySelector('#usuarios-graph'), optionsUsuarios);
    chartUsuarios.render();

    // Gráfico de Agendas
    var optionsAgendas = {
      chart: { type: 'bar', height: 50, sparkline: { enabled: true } },
      colors: ['#E58A00'],
      plotOptions: { bar: { columnWidth: '80%' } },
      series: [{ data: [<?php echo $total_agendas - 1; ?>, <?php echo $total_agendas; ?>, <?php echo $total_agendas + 1; ?>] }],
      tooltip: {
        y: {
          title: {
            formatter: function (seriesName) {
              return 'Agendas: ';
            }
          }
        }
      }
    };
    var chartAgendas = new ApexCharts(document.querySelector('#agendas-graph'), optionsAgendas);
    chartAgendas.render();

    // Gráfico de Produtos
    var optionsProdutos = {
      chart: { type: 'bar', height: 50, sparkline: { enabled: true } },
      colors: ['#2CA87F'],
      plotOptions: { bar: { columnWidth: '80%' } },
      series: [{ data: [<?php echo $total_produtos; ?>, <?php echo $total_produtos; ?>, <?php echo $total_produtos + 1; ?>] }],
      tooltip: {
        y: {
          title: {
            formatter: function (seriesName) {
              return 'Produtos: ';
            }
          }
        }
      }
    };
    var chartProdutos = new ApexCharts(document.querySelector('#produtos-graph'), optionsProdutos);
    chartProdutos.render();

    // Gráfico de Blog
    var optionsBlog = {
      chart: { type: 'bar', height: 50, sparkline: { enabled: true } },
      colors: ['#DC2626'],
      plotOptions: { bar: { columnWidth: '80%' } },
      series: [{ data: [<?php echo $total_posts; ?>, <?php echo $total_posts; ?>, <?php echo $total_posts; ?>] }],
      tooltip: {
        y: {
          title: {
            formatter: function (seriesName) {
              return 'Posts: ';
            }
          }
        }
      }
    };
    var chartBlog = new ApexCharts(document.querySelector('#blog-graph'), optionsBlog);
    chartBlog.render();

    // Gráfico de Agendas por Situação
    var agendaSituacaoData = [
      <?php 
      foreach($agenda_situacoes as $situacao) {
        echo $situacao['total'] . ',';
      }
      ?>
    ];
    
    var agendaSituacaoLabels = [
      <?php 
      foreach($agenda_situacoes as $situacao) {
        echo "'" . addslashes($situacao['situacao']) . "',";
      }
      ?>
    ];

    if(agendaSituacaoData.length > 0) {
      var optionsAgendaSituacao = {
        chart: {
          type: 'donut',
          height: 350
        },
        series: agendaSituacaoData,
        colors: ['#4680FF', '#E58A00', '#2CA87F', '#DC2626', '#6c757d'],
        labels: agendaSituacaoLabels,
        legend: {
          position: 'bottom'
        },
        plotOptions: {
          pie: {
            donut: {
              size: '65%',
              labels: {
                show: true,
                name: {
                  show: true
                },
                value: {
                  show: true
                }
              }
            }
          }
        },
        dataLabels: {
          enabled: true
        },
        responsive: [{
          breakpoint: 480,
          options: {
            chart: {
              width: 200
            },
            legend: {
              position: 'bottom'
            }
          }
        }]
      };
      
    var chartAgendaSituacao = new ApexCharts(document.querySelector('#agenda-situacao-graph'), optionsAgendaSituacao);
    chartAgendaSituacao.render();
  } else {
    document.querySelector('#agenda-situacao-graph').innerHTML = '<div class="text-center p-4"><p class="text-muted">Nenhuma agenda encontrada</p></div>';
  }

  // Gráfico de Produtos por Marca
  var produtosMarcaData = [
    <?php 
    if(!empty($produtos_por_marca)) {
      foreach($produtos_por_marca as $produto_marca) {
        echo $produto_marca['total'] . ',';
      }
    } else {
      echo '0';
    }
    ?>
  ];
  
  var produtosMarcaLabels = [
    <?php 
    if(!empty($produtos_por_marca)) {
      foreach($produtos_por_marca as $produto_marca) {
        echo "'" . addslashes($produto_marca['marca']) . "',";
      }
    } else {
      echo "'Sem dados'";
    }
    ?>
  ];

  if(document.querySelector('#produtos-marca-graph') && produtosMarcaData.length > 0 && produtosMarcaData[0] > 0) {
    var optionsProdutosMarca = {
      chart: {
        type: 'donut',
        height: 200
      },
      series: produtosMarcaData,
      colors: ['#4680FF', '#E58A00', '#2CA87F', '#DC2626', '#6c757d'],
      labels: produtosMarcaLabels,
      legend: {
        show: false
      },
      plotOptions: {
        pie: {
          donut: {
            size: '70%'
          }
        }
      },
      dataLabels: {
        enabled: true,
        formatter: function (val, opts) {
          return opts.w.config.series[opts.seriesIndex]
        }
      },
      tooltip: {
        y: {
          formatter: function (val) {
            return val + " produto" + (val > 1 ? "s" : "")
          }
        }
      }
    };
    
    var chartProdutosMarca = new ApexCharts(document.querySelector('#produtos-marca-graph'), optionsProdutosMarca);
    chartProdutosMarca.render();
  } else if(document.querySelector('#produtos-marca-graph')) {
    document.querySelector('#produtos-marca-graph').innerHTML = '<div class="text-center p-4"><p class="text-muted">Nenhum produto encontrado</p></div>';
  }
  
}, 1000);
});
</script><?php include 'includes/tema/base.php'; ?>