﻿<?php include 'includes/tema/topo.php'; ?>
<?php include 'includes/dynamic_queries.php'; ?>

<?php 
// Configuração para upload de fotos
$uploadConfig = [
    'field' => 'foto',
    'dir' => 'uploads/fotos',
    'extensions' => ['.jpg', '.jpeg', '.gif', '.png', '.pdf', '.doc', '.docx', '.txt']
];

// Processar todas as operações CRUD automaticamente
$result = processCRUDOperations('fotos', 'id_foto', $uploadConfig);

// Extrair variáveis para compatibilidade com o código existente
$acao = $result['acao'];
$idfoto = $result['recordId'];
?>


<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

        <?php if ($acao == "Alterar" && !empty($idfoto)) {
                $sql = mysqli_query($conn, "SELECT * FROM fotos WHERE id='$idfoto'")->fetch_array();
            } else {
                // Inicializar array vazio para o modo de inserção
                $sql = [
                    'foto' => '',
                    'titulo' => '',
                    'descricao' => '',
                    'endereco' => '',
                    'id_categoria' => ''
                ];
            } ?>

        <?php if ($acao != "") { ?>
        <div class="smart-wrap">
            <div class="smart-forms smart-container wrap-0">
                <div class="form-header header-blue bg-primary ">
                    <h4><i class="fa fa-calendar-o"></i>Fotos </h4>
                </div><!-- end .form-header section -->

                <form name="fotos" id="fotos" method="post" action="<?php echo $_SERVER['PHP_SELF'] . '?acao=' . urlencode($acao) . '&id_foto=' . urlencode($idfoto); ?>"
                    enctype="multipart/form-data">
                    <div class="form-body">
                        <div class="spacer-b30">
                            <div class="tagline"><span style="color: black"> Perfil </span></div>
                            <!-- .tagline -->
                        </div>

                        <div class="frm-row">
                            <div class="section colm colm3">
                                <div align="center">
                                    <a href="<?php echo BaseFoto() . $sql['foto']; ?>" target="_blank"><img
                                            src="<?php echo BaseFoto() . $sql['foto']; ?>" class="rounded img-responsive"
                                            alt="" width="40" height="40"></a>
                                </div>
                            </div>
                            <div class="section colm colm6">
                                <label for="file1" class="field prepend-icon file">
                                    <span class="button btn-primary"> Anexar </span>
                                    <input type="file" class="gui-file" name="foto" id="foto"
                                        onChange="document.getElementById('fotoup').value = this.value;">
                                    <input type="text" class="gui-input" id="fotoup"
                                        placeholder="Adicionar Foto do Perfil" readonly>
                                    <span class="field-icon"><i class="fa fa-upload"></i></span>
                                </label>
                            </div><!-- end  section -->
                        </div><!-- end  section -->

                        <div class="spacer-b30">
                            <div class="tagline"><span style="color: black"> Informações da Foto </span>
                            </div><!-- .tagline -->
                        </div>
                        <div class="frm-row">
                            <div class="section colm colm3"></div>
                            <div class="section colm colm6">
                                <label for="firstname" class="field prepend-icon">
                                    <input type="text" name="titulo" id="titulo" class="gui-input"
                                        placeholder="TÃ­tulo da Foto" value="<?php echo $sql['titulo']; ?>" required>
                                    <b class="tooltip tip-right-top"><b>Digite o <span style="color:#6CF;">Titulo</span>
                                            Exemplo: <span style="color:#6CF;"> Minha Foto </span></b></b>
                                    <span class="field-icon"><i class="fa fa-user"></i></span>


                                </label>
                            </div><!-- end section -->



                        </div><!-- end .frm-row section -->
                        <div class="frm-row">
                            <div class="section colm colm1"></div>
                            <div class="section colm colm10">
                                <label for="comment" class="field prepend-icon">
                                    <textarea class="gui-textarea" id="descricao" name="descricao"
                                        placeholder="Descrição da Imagem"><?php echo $sql['descricao']; ?></textarea>
                                    <span class="field-icon"><i class="fa fa-comments"></i></span>
                                    <span class="input-hint">
                                        <strong>OBS:</strong> Escreva a Descrição da Foto
                                    </span>
                                </label>
                            </div><!-- end section -->

                        </div>


                        <div class="frm-row">
                            <div class="section colm colm3"></div>
                            <div class="section colm colm6">
                                <label for="firstname" class="field prepend-icon">
                                    <input type="text" name="endereco" id="endereco" class="gui-input"
                                        placeholder="Link" value="<?php echo $sql['endereco']; ?>">
                                    <b class="tooltip tip-right-top"><b>Digite o <span style="color:#6CF;">Link</span>
                                            Exemplo: <span style="color:#6CF;">
                                                http://www.agenciapalhano.com.br
                                            </span></b></b>
                                    <span class="field-icon"><i class="fa fa-link"></i></span>


                                </label>
                            </div><!-- end section -->



                        </div><!-- end .frm-row section -->

                        <div class="spacer-b30">
                            <div class="tagline"><span style="color: black"> Categoria da Foto - <a
                                        href="fotos_categoria.php">Adicionar Categoria</a> </span></div>
                            <!-- .tagline -->
                        </div>

                        <div class="frm-row" style="margin-top: 20px;">
                            <div class="section colm colm3">
                            </div>
                            <div class="section colm colm6">
                                <label class="field select prepend-icon">

                                    <select name="id_categoria">
                                        <?php $sqla = mysqli_query($conn, "SELECT * FROM fotos_categoria ORDER BY id");
                                                while ($coluna = mysqli_fetch_array($sqla)) { ?>
                                        <option value="<?php echo $coluna['id']; ?>" <?php if
                                            ($sql['id_categoria']==$coluna['id']) echo " selected" ; ?>>
                                            <span>
                                                <?php echo $coluna['nome_categoria']; ?>
                                        </option>
                                        <?php } ?>
                                    </select> <span class="field-icon"><i class="fa fa-sort-alpha-asc"></i></span>
                                    <b class="tooltip tip-right-top"><b>Selecione a <span style="color:#6CF;">Categoria
                                                da FOTO</span> Exemplo: <span style="color:#6CF;"> Usuario
                                            </span></b></b> </label>
                            </div>
                        </div>












                    </div>




                    <div class="form-footer" align="center">
                        <input type="hidden" name="id_foto" value="<?php echo $idfoto; ?>">
                        <input type="hidden" name="<?php echo $acao; ?>" value="ok">
                        <input type="submit" class="button btn-blue" name="Submit" value="<?php echo $acao; ?>">

                    </div>

                </form>
            </div>
        </div>



        <div class="row page-titles">

            <div class="col-md-7 align-self-center text-left">
                <div class="d-flex justify-content align-items-center">

                    <button type="button" class="btn btn-primary d-lg-block m-l-15"
                        onclick="location.href='<?php $pagina = basename($_SERVER['PHP_SELF'], ''); echo $pagina; ?>';"><i
                            class="fa fa-plus-circle"></i>
                        Voltar</button>
                </div>
            </div>
        </div>


        <?php } else { ?>


        <div style="clear: both;"></div>


        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5>Tabela:
                        <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                            echo ucfirst(strtolower($pagina)); ?>
                    </h5>
                    <small>Aqui você tem as opções de <b>cadastrar</b>,<b>editar</b>,<b>excluir</b> <span
                            style="color:red;">
                            <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?><span>.</small>
                </div>
                <div class="card-body">
                    <div class="dt-responsive table-responsive">

                        <table id="footer-search" class="table table-striped table-bordered nowrap">

                            <thead>

                                <tr>
                                    <th style="width: 10px;">ID</th>
                                    <th style="width: 200px;">TÃ­tulo</th>
                                    <th style="width: 200px;">Descricao</th>
                                    <th style="width: 40px; ">Foto</th>
                                    <th>Categoria</th>
                                    <th style="width: 60px; ">Data</th>
                                    <th style="width: 30px;">Hora</th>
                                    <th style="width: 80px;">Status</th>


                                </tr>

                            </thead>

                            <tfoot>

                                <tr>
                                    <th>ID</th>
                                    <th>TÃ­tulo</th>
                                    <th>Descricao</th>
                                    <th>Foto</th>
                                    <th>Categoria</th>
                                    <th>Data</th>
                                    <th>Hora</th>
                                    <th hidden="">Status</th>

                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $sqlfotos = mysqli_query($conn, "SELECT * FROM fotos ORDER BY id desc"); // (SELECT * FROM cursos WHERE ativo='1' ORDER BY id asc) para selecionar somente os ativos
                                            while ($dadosfotos = mysqli_fetch_array($sqlfotos)) { ?>
                                <tr>
                                    <td style="width: 10px;">
                                        <?php echo $dadosfotos['id']; ?>
                                    </td>
                                    <td style="width: 200px;">
                                        <?php echo $dadosfotos['titulo']; ?>
                                    </td>
                                    <td style="width: 200px;">
                                        <?php echo $dadosfotos['descricao']; ?>
                                    </td>
                                    <td style="width: 40px;">
                                        <div class="popup-gallery row m-t-1">
                                            <?php if (!empty($dadosfotos['foto'])) { ?>
                                            <div class="col-md-12">
                                                <a class="image-popup-vertical-fit" href="<?php $img = $dadosfotos['foto'];
                                                                echo BaseFoto() . $img; ?>"
                                                    title="<?php echo $dadosfotos['titulo']; ?>">
                                                    <img class="img-responsive" src="<?php $img = $dadosfotos['foto'];
                                                                    echo BaseFoto() . $img; ?>" width="60" height="60"
                                                        alt="Img" title="<?php echo $dadosfotos['titulo']; ?>"
                                                        data-toggle="tooltip">
                                                </a>
                                            </div>
                                            <?php } ?>
                                        </div>


                                    </td>
                                    <td style="width: 80px;">
                                        <?php $nome_categoria = mysqli_query($conn, "SELECT nome_categoria FROM fotos_categoria WHERE id='".$dadosfotos['id_categoria']."'")->fetch_assoc();
                                                    echo $nome_categoria['nome_categoria']; ?>
                                    </td>
                                    <td style="width: 80px;">
                                        <?php echo $dadosfotos['data']; ?>
                                    </td>
                                    <td style="width: 20px;">
                                        <?php echo $dadosfotos['hora']; ?>
                                    </td>
                                    <td style="width: 40px;">

                                        <button type="button" class="btn btn-inverse-success waves-effect waves-light "
                                            title="Alterar">

                                            <a href="?acao=Alterar&id_foto=<?php echo $dadosfotos['id']; ?>"
                                                class="avtar avtar-s btn-link-success btn-pc-default"><i
                                                    class="ti ti-edit f-20"></i></a>
                                        </button>


                                        <button type="button" class="btn btn-inverse-danger waves-effect waves-light "
                                            title="Excluir">

                                            <a href="?Excluir=ok&id_foto=<?php echo $dadosfotos['id']; ?>"
                                                onClick="return pergunta();"
                                                class="avtar avtar-s btn-link-danger btn-pc-default"><i
                                                    class="ti ti-trash f-20"></i></a>

                                        </button>
                                    </td>

                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Individual Column Searching (Text Inputs) end -->

        <div class="row page-titles">

            <div class="col-md-2 align-self-center text-left">
                <div class="d-flex justify-content align-items-center">

                    <button type="button" class="btn btn-primary d-lg-block m-l-15"
                        onclick="location.href='?acao=Inserir';"><i class="fa fa-plus-circle"></i> Adicionar
                        <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
echo ucfirst(strtolower($pagina)); ?>
                    </button>
                </div>
            </div>
        </div>


        <?php } ?>

        <!-- Search API (Regular Expressions) table end -->
    </div>
</section>



<?php include 'includes/tema/base.php'; ?>