<?php
// diagnostico_avancado.php - Diagnóstico completo da configuração PHP
echo "<h2>🔬 Diagnóstico Avançado - LiteSpeed/cPanel</h2>";

echo "<h3>📊 Status Atual:</h3>";
echo "<strong>Loaded Configuration File:</strong> " . php_ini_loaded_file() . "<br>";
echo "<strong>Server API:</strong> " . php_sapi_name() . "<br>";
echo "<strong>Current Directory:</strong> " . __DIR__ . "<br>";

// Verificar se arquivos existem
$files_to_check = [
    __DIR__ . '/.htaccess',
    __DIR__ . '/php.ini',
    __DIR__ . '/.user.ini',
    __DIR__ . '/prepend.php'
];

echo "<h3>📁 Arquivos no Diretório:</h3>";
foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✅ " . basename($file) . " - EXISTE<br>";
        if (is_readable($file)) {
            $content = file_get_contents($file);
            echo "&nbsp;&nbsp;&nbsp;📄 Tamanho: " . strlen($content) . " bytes<br>";
            if (basename($file) === '.htaccess') {
                echo "&nbsp;&nbsp;&nbsp;🔍 Conteúdo relevante:<br>";
                $lines = explode("\n", $content);
                foreach ($lines as $line) {
                    if (stripos($line, 'user_ini') !== false || stripos($line, 'auto_prepend') !== false) {
                        echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . htmlspecialchars(trim($line)) . "<br>";
                    }
                }
            }
        }
    } else {
        echo "❌ " . basename($file) . " - NÃO EXISTE<br>";
    }
}

echo "<h3>🧪 Testes de Configuração:</h3>";

// Teste 1: Método .user.ini (mais compatível com LiteSpeed)
echo "<h4>Teste 1: Criar .user.ini</h4>";
$user_ini_content = "; .user.ini - Método alternativo para LiteSpeed
memory_limit = 512M
max_execution_time = 300
upload_max_filesize = 100M
post_max_size = 100M
auto_prepend_file = \"\"
display_errors = On
error_reporting = E_ALL & ~E_NOTICE & ~E_DEPRECATED
session.save_path = \"" . __DIR__ . "/sessions\"
date.timezone = \"America/Sao_Paulo\"";

if (file_put_contents(__DIR__ . '/.user.ini', $user_ini_content)) {
    echo "✅ .user.ini criado com método LiteSpeed<br>";
} else {
    echo "❌ Erro ao criar .user.ini<br>";
}

// Teste 2: Método php.ini como .user.ini
echo "<h4>Teste 2: Renomear php.ini para .user.ini</h4>";
if (file_exists(__DIR__ . '/php.ini')) {
    if (copy(__DIR__ . '/php.ini', __DIR__ . '/.user.ini.backup')) {
        echo "✅ Backup do php.ini criado<br>";
    }
    if (rename(__DIR__ . '/php.ini', __DIR__ . '/.user.ini.alternative')) {
        echo "✅ php.ini renomeado para .user.ini.alternative<br>";
    }
}

// Teste 3: .htaccess atualizado para LiteSpeed
echo "<h4>Teste 3: .htaccess otimizado para LiteSpeed</h4>";
$htaccess_litespeed = '# .htaccess OTIMIZADO PARA LITESPEED
# Remove auto_prepend_file e configura para usar .user.ini

# DESABILITAR auto_prepend_file completamente
php_admin_value auto_prepend_file ""
php_value auto_prepend_file ""

# CONFIGURAR para usar .user.ini (mais compatível com LiteSpeed)
php_flag user_ini.filename ".user.ini"
php_value user_ini.cache_ttl 60

# CONFIGURAÇÕES DIRETAS (fallback)
php_value memory_limit 512M
php_value max_execution_time 300
php_value upload_max_filesize 100M
php_value post_max_size 100M
php_flag display_errors On
php_value date.timezone "America/Sao_Paulo"

# SEGURANÇA
<Files ".user.ini">
    <RequireAll>
        Require all denied
    </RequireAll>
</Files>

<Files "*.log">
    <RequireAll>
        Require all denied
    </RequireAll>
</Files>

<Files "prepend.php">
    <RequireAll>
        Require all denied
    </RequireAll>
</Files>

# REWRITE RULES
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^\.user\.ini$ - [F,L]
    RewriteRule ^prepend\.php$ - [F,L]
</IfModule>';

if (file_put_contents(__DIR__ . '/.htaccess', $htaccess_litespeed)) {
    echo "✅ .htaccess atualizado para LiteSpeed<br>";
} else {
    echo "❌ Erro ao atualizar .htaccess<br>";
}

// Teste 4: Remover cache do LiteSpeed
echo "<h4>Teste 4: Limpar cache</h4>";
if (function_exists('opcache_reset')) {
    opcache_reset();
    echo "✅ OPCache resetado<br>";
}

// Criar diretório sessions se não existir
if (!is_dir(__DIR__ . '/sessions')) {
    if (mkdir(__DIR__ . '/sessions', 0755)) {
        echo "✅ Diretório sessions criado<br>";
    }
}

echo "<h3>🔄 IMPORTANTE:</h3>";
echo "<div style='background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107;'>";
echo "<strong>Para LiteSpeed funcionar:</strong><br>";
echo "1. Aguarde 60 segundos (cache_ttl)<br>";
echo "2. Recarregue esta página: <a href='info.php'>info.php</a><br>";
echo "3. Se ainda não funcionar, use cPanel MultiPHP INI Editor<br>";
echo "</div>";

echo "<h3>🎯 Métodos Testados:</h3>";
echo "✅ Método 1: .user.ini com configurações diretas<br>";
echo "✅ Método 2: .htaccess otimizado para LiteSpeed<br>";
echo "✅ Método 3: Configurações PHP diretas no .htaccess<br>";
echo "✅ Método 4: Cache limpo<br>";

echo "<h3>📋 Próximos Passos:</h3>";
echo "<ol>";
echo "<li><strong>Aguarde 60 segundos</strong> e teste <a href='info.php'>info.php</a></li>";
echo "<li>Se não funcionar, use <strong>cPanel > MultiPHP INI Editor</strong></li>";
echo "<li>Configurações já aplicadas diretamente no .htaccess como fallback</li>";
echo "</ol>";

// Mostrar configurações aplicadas
echo "<h3>⚙️ Configurações Aplicadas:</h3>";
echo "<ul>";
echo "<li>memory_limit = 512M</li>";
echo "<li>max_execution_time = 300</li>";
echo "<li>upload_max_filesize = 100M</li>";
echo "<li>auto_prepend_file = \"\" (DESABILITADO)</li>";
echo "<li>display_errors = On</li>";
echo "<li>timezone = America/Sao_Paulo</li>";
echo "</ul>";
?>