<?php
// detector_diretorio.php - Detecta o diretório correto automaticamente
echo "<h2>🔍 Detector de Diretório - kubonet.com.br</h2>";

// Obter o diretório atual do script
$script_dir = __DIR__;
$document_root = $_SERVER['DOCUMENT_ROOT'];
$script_filename = $_SERVER['SCRIPT_FILENAME'];

echo "<h3>📍 Informações do Servidor:</h3>";
echo "<strong>Diretório do Script:</strong> $script_dir<br>";
echo "<strong>Document Root:</strong> $document_root<br>";
echo "<strong>Script Filename:</strong> $script_filename<br>";
echo "<strong>SERVER_NAME:</strong> " . $_SERVER['SERVER_NAME'] . "<br>";
echo "<strong>HTTP_HOST:</strong> " . $_SERVER['HTTP_HOST'] . "<br>";

// Detectar possíveis diretórios
$possible_dirs = [
    $script_dir,
    dirname($script_filename),
    $document_root,
    $document_root . '/admin',
    '/home/kubonet/public_html/admin',
    '/home/kubonet/admin',
    '/home12/kubonet/public_html/admin',
    '/home12/kubonet/admin',
    str_replace('/public_html', '', $document_root) . '/admin',
    dirname($document_root) . '/admin'
];

echo "<h3>🎯 Diretórios Detectados:</h3>";
foreach ($possible_dirs as $dir) {
    if (is_dir($dir)) {
        echo "✅ <strong>$dir</strong> - EXISTE<br>";
        
        // Verificar permissões
        if (is_writable($dir)) {
            echo "&nbsp;&nbsp;&nbsp;📝 Permissão de escrita: SIM<br>";
        } else {
            echo "&nbsp;&nbsp;&nbsp;❌ Permissão de escrita: NÃO<br>";
        }
        
        // Listar alguns arquivos
        $files = array_slice(scandir($dir), 0, 10);
        echo "&nbsp;&nbsp;&nbsp;📁 Arquivos: " . implode(', ', array_filter($files, function($f) { return $f[0] !== '.'; })) . "<br><br>";
    } else {
        echo "❌ <strong>$dir</strong> - NÃO EXISTE<br>";
    }
}

// Obter informações do usuário atual
echo "<h3>👤 Informações do Sistema:</h3>";
if (function_exists('posix_getpwuid') && function_exists('posix_geteuid')) {
    $user_info = posix_getpwuid(posix_geteuid());
    echo "<strong>Usuário:</strong> " . $user_info['name'] . "<br>";
    echo "<strong>Home Dir:</strong> " . $user_info['dir'] . "<br>";
    echo "<strong>Shell:</strong> " . $user_info['shell'] . "<br>";
}

// Tentar detectar cPanel
if (is_dir('/usr/local/cpanel')) {
    echo "<strong>cPanel:</strong> ✅ Detectado<br>";
} else {
    echo "<strong>cPanel:</strong> ❌ Não detectado<br>";
}

// Verificar PHP info relevante
echo "<h3>🔧 Configuração PHP:</h3>";
echo "<strong>PHP Version:</strong> " . PHP_VERSION . "<br>";
echo "<strong>Server API:</strong> " . php_sapi_name() . "<br>";
echo "<strong>Config File Path:</strong> " . php_ini_loaded_file() . "<br>";
echo "<strong>Scan Dir:</strong> " . php_ini_scanned_files() . "<br>";

// Recomendar diretório correto
echo "<h3>🎯 RECOMENDAÇÃO:</h3>";
$recommended_dir = $script_dir;
echo "<div style='background: #e8f5e8; padding: 10px; border-left: 4px solid #4CAF50;'>";
echo "<strong>Use este diretório:</strong> <code>$recommended_dir</code><br>";
echo "<strong>Comando para atualizar .htaccess:</strong><br>";
echo "<code>php_value user_ini.filename \"php.ini\"<br>";
echo "php_value user_ini.cache_ttl 300</code>";
echo "</div>";

// Criar configurador automático com diretório correto
echo "<h3>⚙️ CONFIGURADOR AUTOMÁTICO:</h3>";
echo "<div style='background: #e3f2fd; padding: 15px; border-left: 4px solid #2196F3;'>";
echo "<form method='post'>";
echo "<input type='hidden' name='target_dir' value='$recommended_dir'>";
echo "<button type='submit' name='auto_config' style='background: #4CAF50; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;'>🚀 CONFIGURAR AUTOMATICAMENTE</button>";
echo "</form>";
echo "</div>";

// Processar configuração automática
if (isset($_POST['auto_config'])) {
    $target_dir = $_POST['target_dir'];
    
    echo "<h3>🔧 Executando Configuração...</h3>";
    
    // Criar .htaccess
    $htaccess_content = '# .htaccess SIMPLIFICADO - kubonet.com.br/admin  
# Carrega php.ini local da pasta admin
# Apenas segurança e proteção de arquivos

# CONFIGURAR php.ini LOCAL
php_value user_ini.filename "php.ini"
php_value user_ini.cache_ttl 300

# DESABILITAR auto_prepend_file (principal fix)
php_value auto_prepend_file ""
php_admin_value auto_prepend_file ""

# SEGURANÇA: Proteger arquivos sensíveis
<Files ".user.ini">
    Order allow,deny
    Deny from all
</Files>

<Files "*.ini">
    Order allow,deny  
    Deny from all
</Files>

<Files "*.log">
    Order allow,deny
    Deny from all
</Files>

<Files "prepend.php">
    Order allow,deny
    Deny from all
</Files>

<Files "config.php">
    Order allow,deny
    Deny from all
</Files>

# HEADERS DE SEGURANÇA
<IfModule mod_headers.c>
    Header always set X-Content-Type-Options nosniff
    Header always set X-Frame-Options SAMEORIGIN
    Header always set X-XSS-Protection "1; mode=block"
    Header always set Referrer-Policy "strict-origin-when-cross-origin"
</IfModule>

# REWRITE RULES
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^\.user\.ini$ - [F,L]
    RewriteRule ^php\.ini$ - [F,L]
    RewriteRule ^prepend\.php$ - [F,L]
</IfModule>';

    // Criar php.ini
    $phpini_content = '; php.ini LOCAL - Configurações personalizadas
; Este arquivo será carregado pela configuração do .htaccess

; CONFIGURAÇÕES DE MEMÓRIA E TEMPO
memory_limit = 512M
max_execution_time = 300
max_input_time = 300
max_input_vars = 3000

; CONFIGURAÇÕES DE UPLOAD
upload_max_filesize = 100M
post_max_size = 100M
file_uploads = On

; CONFIGURAÇÕES DE ERRO E DEBUG
display_errors = On
log_errors = On
error_reporting = E_ALL & ~E_NOTICE & ~E_DEPRECATED
error_log = ' . $target_dir . '/php_errors.log

; CONFIGURAÇÕES DE SESSÃO
session.save_path = ' . $target_dir . '/sessions
session.gc_maxlifetime = 7200
session.cookie_lifetime = 0

; TIMEZONE
date.timezone = America/Sao_Paulo

; CONFIGURAÇÕES DE SEGURANÇA
expose_php = Off
allow_url_fopen = On
allow_url_include = Off

; DESABILITAR auto_prepend_file (importante!)
auto_prepend_file = ""';

    // Salvar arquivos
    $success = true;
    
    // .htaccess
    if (file_put_contents($target_dir . '/.htaccess', $htaccess_content)) {
        echo "✅ .htaccess criado com sucesso<br>";
    } else {
        echo "❌ Erro ao criar .htaccess<br>";
        $success = false;
    }
    
    // php.ini
    if (file_put_contents($target_dir . '/php.ini', $phpini_content)) {
        echo "✅ php.ini criado com sucesso<br>";
    } else {
        echo "❌ Erro ao criar php.ini<br>";
        $success = false;
    }
    
    // Criar pasta sessions
    $sessions_dir = $target_dir . '/sessions';
    if (!is_dir($sessions_dir)) {
        if (mkdir($sessions_dir, 0755)) {
            echo "✅ Pasta sessions criada com sucesso<br>";
        } else {
            echo "❌ Erro ao criar pasta sessions<br>";
        }
    } else {
        echo "ℹ️ Pasta sessions já existe<br>";
    }
    
    // Limpar arquivos problemáticos
    $files_to_remove = ['.user.ini', 'prepend.php', 'php.ini.bak'];
    foreach ($files_to_remove as $file) {
        $file_path = $target_dir . '/' . $file;
        if (file_exists($file_path)) {
            if (unlink($file_path)) {
                echo "✅ Arquivo $file removido<br>";
            } else {
                echo "❌ Erro ao remover $file<br>";
            }
        }
    }
    
    if ($success) {
        echo "<div style='background: #e8f5e8; padding: 15px; border-left: 4px solid #4CAF50; margin-top: 20px;'>";
        echo "<h4>🎉 CONFIGURAÇÃO CONCLUÍDA!</h4>";
        echo "<strong>Teste agora:</strong> <a href='/admin/info.php' target='_blank'>info.php</a><br>";
        echo "<strong>Diretório configurado:</strong> $target_dir<br>";
        echo "<strong>Você deve ver:</strong> Loaded Configuration File: $target_dir/php.ini";
        echo "</div>";
    }
}
?>