<?php
// cpanel_multiphp_simulator.php - Simula MultiPHP INI Editor para /admin/
// Cria php.ini local que será reconhecido pelo sistema

echo "<h2>🎯 MultiPHP INI Editor SIMULATOR - Pasta /admin/</h2>";

$admin_dir = __DIR__;
$ini_file = $admin_dir . '/php.ini';

// Verificar se já existe php.ini
if (file_exists($ini_file)) {
    echo "<p><strong>✅ php.ini já existe:</strong> $ini_file</p>";
    $current_content = file_get_contents($ini_file);
} else {
    echo "<p><strong>ℹ️ php.ini será criado:</strong> $ini_file</p>";
    $current_content = '';
}

// Processar formulário
if (isset($_POST['save_ini'])) {
    $ini_content = $_POST['ini_content'];
    
    if (file_put_contents($ini_file, $ini_content)) {
        echo "<div style='background: #e8f5e8; padding: 15px; border: 2px solid #4CAF50; margin: 10px 0;'>";
        echo "<h3>🎉 php.ini criado com sucesso!</h3>";
        echo "<strong>Arquivo:</strong> $ini_file<br>";
        echo "<strong>Teste agora:</strong> <a href='info.php' target='_blank'>info.php</a><br>";
        echo "<strong>Esperado:</strong> Loaded Configuration File: $ini_file";
        echo "</div>";
        
        // Recarregar conteúdo
        $current_content = file_get_contents($ini_file);
    } else {
        echo "<div style='background: #ffe6e6; padding: 15px; border: 2px solid #f44336; margin: 10px 0;'>";
        echo "<h3>❌ Erro ao salvar php.ini</h3>";
        echo "Verifique as permissões da pasta admin";
        echo "</div>";
    }
}

// Template padrão se não existe conteúdo
if (empty($current_content)) {
    $current_content = '; php.ini LOCAL - /admin/ - Configurações personalizadas
; Criado via MultiPHP INI Editor Simulator

; CONFIGURAÇÕES DE ARQUIVOS
file_uploads = On
max_execution_time = 600
max_input_time = 600
upload_max_filesize = 400M
post_max_size = 400M
memory_limit = 256M

; CONFIGURAÇÕES DE SEGURANÇA E ACESSO
allow_url_include = On
allow_url_fopen = On

; CONFIGURAÇÕES DE DEBUG E LOGS
display_errors = Off
log_errors = Off

; TIMEZONE
date.timezone = Etc/GMT+3

; CONFIGURAÇÕES DE CHARSET E TAGS
default_charset = utf-8
register_globals = Off
short_open_tag = On
asp_tags = On

; CONFIGURAÇÕES DE OUTPUT
output_buffering = 4096

; DESABILITAR auto_prepend_file (IMPORTANTE!)
auto_prepend_file = ""

; CONFIGURAÇÕES DE SESSÃO
session.save_path = ' . $admin_dir . '/sessions
session.gc_maxlifetime = 7200
session.cookie_lifetime = 0';
}
?>

<style>
.form-container { max-width: 800px; margin: 20px auto; }
.ini-editor { width: 100%; height: 400px; font-family: monospace; font-size: 14px; }
.save-btn { background: #4CAF50; color: white; padding: 12px 24px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
.info-box { background: #e3f2fd; padding: 15px; border-left: 4px solid #2196F3; margin: 20px 0; }
</style>

<div class="form-container">
    <div class="info-box">
        <h4>📋 Como funciona:</h4>
        <ul>
            <li><strong>Diretório alvo:</strong> <?php echo $admin_dir; ?></li>
            <li><strong>Arquivo criado:</strong> php.ini</li>
            <li><strong>Escopo:</strong> Apenas pasta /admin/ e subpastas</li>
            <li><strong>Equivalente:</strong> MultiPHP INI Editor do cPanel</li>
        </ul>
    </div>
    
    <form method="post">
        <h3>📝 Editar php.ini local:</h3>
        <textarea name="ini_content" class="ini-editor" placeholder="Configurações PHP..."><?php echo htmlspecialchars($current_content); ?></textarea>
        <br><br>
        <button type="submit" name="save_ini" class="save-btn">💾 Salvar php.ini</button>
    </form>
    
    <div class="info-box">
        <h4>🔧 Suas configurações personalizadas:</h4>
        <ul>
            <li>memory_limit = 256M</li>
            <li>max_execution_time = 600 (10 minutos)</li>
            <li>upload_max_filesize = 400M</li>
            <li>post_max_size = 400M</li>
            <li>allow_url_include = On</li>
            <li>display_errors = Off</li>
            <li>date.timezone = Etc/GMT+3</li>
            <li>short_open_tag = On</li>
            <li>asp_tags = On</li>
        </ul>
    </div>
    
    <h3>📊 Status atual:</h3>
    <p><strong>Diretório atual:</strong> <?php echo $admin_dir; ?></p>
    <p><strong>php.ini existe:</strong> <?php echo file_exists($ini_file) ? '✅ SIM' : '❌ NÃO'; ?></p>
    <?php if (file_exists($ini_file)): ?>
    <p><strong>Tamanho:</strong> <?php echo filesize($ini_file); ?> bytes</p>
    <p><strong>Última modificação:</strong> <?php echo date('Y-m-d H:i:s', filemtime($ini_file)); ?></p>
    <?php endif; ?>
    
    <h3>🎯 Próximos passos:</h3>
    <ol>
        <li>Clique em "Salvar php.ini" acima</li>
        <li>Aguarde confirmação de sucesso</li>  
        <li>Teste: <a href="info.php">info.php</a></li>
        <li>Verifique se mostra: <code>Loaded Configuration File: <?php echo $ini_file; ?></code></li>
    </ol>
</div>