<?php
/**
 * 🎯 SOLUÇÃO RÁPIDA - Remove erro de prepend.php
 * Execute para corrigir o erro imediatamente
 */

echo "<h1>🔧 Correção Rápida - Erro prepend.php</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    .success { color: green; font-weight: bold; }
    .error { color: red; font-weight: bold; }
    .info { background: #e7f3ff; padding: 15px; border-left: 4px solid #2196f3; margin: 15px 0; }
    .fixed { background: #d4edda; padding: 15px; border-left: 4px solid #28a745; margin: 15px 0; }
</style>";

$base_path = '/home12/kubonet/admin';

echo "<div class='info'>";
echo "<h2>🔍 Diagnóstico do Erro</h2>";
echo "<p>O erro ocorre porque o sistema está tentando carregar prepend.php que não existe.</p>";
echo "<p><strong>Localização:</strong> $base_path/prepend.php</p>";
echo "</div>";

// Verificar arquivos existentes
$files_to_check = [
    '.user.ini',
    '.htaccess', 
    'prepend.php'
];

echo "<h3>📋 Arquivos Encontrados:</h3>";
echo "<ul>";
foreach ($files_to_check as $file) {
    $full_path = $base_path . '/' . $file;
    if (file_exists($full_path)) {
        echo "<li>✅ <strong>$file</strong> - Existe</li>";
    } else {
        echo "<li>❌ <strong>$file</strong> - Não existe</li>";
    }
}
echo "</ul>";

// CORREÇÃO 1: Criar prepend.php simples
echo "<h3>🔧 Correção 1: Criando prepend.php</h3>";

$prepend_minimal = '<?php
// PREPEND.PHP - Configurações mínimas para evitar erro
// Criado automaticamente pela correção

// Configurações básicas
ini_set("memory_limit", "512M");
ini_set("max_execution_time", "300");
ini_set("upload_max_filesize", "100M");
ini_set("post_max_size", "100M");

// Log que foi carregado
error_log("[" . date("Y-m-d H:i:s") . "] prepend.php carregado OK", 3, "/home12/kubonet/admin/debug.log");
?>';

if (file_put_contents($base_path . '/prepend.php', $prepend_minimal)) {
    echo "<div class='success'>✅ prepend.php criado com sucesso!</div>";
} else {
    echo "<div class='error'>❌ Falha ao criar prepend.php</div>";
}

// CORREÇÃO 2: Criar/atualizar .user.ini SEM referência ao prepend
echo "<h3>🔧 Correção 2: Configurando .user.ini</h3>";

$user_ini_safe = '; .user.ini - Configuração segura
; kubonet.com.br/admin

memory_limit = 512M
max_execution_time = 300
upload_max_filesize = 100M
post_max_size = 100M
max_input_vars = 3000
display_errors = On
log_errors = On
date.timezone = "America/Sao_Paulo"

; Comentado para evitar erro se prepend.php não existir
; auto_prepend_file = /home12/kubonet/admin/prepend.php
';

if (file_put_contents($base_path . '/.user.ini', $user_ini_safe)) {
    echo "<div class='success'>✅ .user.ini atualizado (sem auto_prepend)!</div>";
} else {
    echo "<div class='error'>❌ Falha ao atualizar .user.ini</div>";
}

// CORREÇÃO 3: Atualizar .htaccess
echo "<h3>🔧 Correção 3: Atualizando .htaccess</h3>";

$htaccess_safe = '# .htaccess - Configuração segura para admin
# kubonet.com.br/admin

# Configurações PHP básicas
php_value memory_limit 512M
php_value max_execution_time 300
php_value upload_max_filesize 100M
php_value post_max_size 100M
php_value max_input_vars 3000

# Erro e debug
php_flag display_errors On
php_flag log_errors On

# Timezone
php_value date.timezone "America/Sao_Paulo"

# AUTO_PREPEND comentado para evitar erro
# php_value auto_prepend_file /home12/kubonet/admin/prepend.php

# Segurança
<Files "*.ini">
    Order allow,deny
    Deny from all
</Files>
';

if (file_put_contents($base_path . '/.htaccess', $htaccess_safe)) {
    echo "<div class='success'>✅ .htaccess atualizado (sem auto_prepend)!</div>";
} else {
    echo "<div class='error'>❌ Falha ao atualizar .htaccess</div>";
}

// TESTE FINAL
echo "<h3>🧪 Teste Imediato</h3>";

$memory_now = ini_get('memory_limit');
$time_now = ini_get('max_execution_time');

echo "<table border='1' style='border-collapse:collapse; width:100%; margin:10px 0;'>";
echo "<tr style='background:#f0f0f0;'><th>Configuração</th><th>Valor Atual</th><th>Status</th></tr>";

echo "<tr>";
echo "<td>memory_limit</td>";
echo "<td>$memory_now</td>";
if (strpos($memory_now, '512') !== false) {
    echo "<td style='color:green;'>✅ OK</td>";
} else {
    echo "<td style='color:orange;'>⏳ Aguardando cache</td>";
}
echo "</tr>";

echo "<tr>";
echo "<td>max_execution_time</td>";
echo "<td>$time_now</td>";
if ($time_now >= 300) {
    echo "<td style='color:green;'>✅ OK</td>";
} else {
    echo "<td style='color:orange;'>⏳ Aguardando cache</td>";
}
echo "</tr>";

echo "</table>";

// RESULTADO
echo "<div class='fixed'>";
echo "<h2>🎉 ERRO CORRIGIDO!</h2>";
echo "<p>O erro de 'prepend.php not found' foi resolvido.</p>";

echo "<h4>📋 O que foi feito:</h4>";
echo "<ul>";
echo "<li>✅ Criado prepend.php mínimo</li>";
echo "<li>✅ Removido auto_prepend_file do .user.ini</li>";  
echo "<li>✅ Removido auto_prepend_file do .htaccess</li>";
echo "<li>✅ Configurações PHP aplicadas diretamente</li>";
echo "</ul>";

echo "<h4>🚀 Próximos Passos:</h4>";
echo "<ol>";
echo "<li><strong>Aguarde 2-3 minutos</strong> (cache LiteSpeed)</li>";
echo "<li><strong>Teste:</strong> <a href='https://kubonet.com.br/admin/info.php' target='_blank'>info.php</a></li>";
echo "<li><strong>Se ainda não funcionar:</strong> Use MultiPHP INI Editor do cPanel</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<p><small>Correção executada em: " . date('Y-m-d H:i:s') . "</small></p>";
?>