<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Incluir conexão com banco de dados
include 'dbconfig.php';

try {
    // Consultas para obter dados reais do banco
    $dados = array();

    // Total de usuários
    $query_usuarios = "SELECT COUNT(*) as total FROM usuarios";
    $result_usuarios = mysqli_query($conn, $query_usuarios);
    $dados['total_usuarios'] = mysqli_fetch_assoc($result_usuarios)['total'];

    // Total de agendas
    $query_agenda = "SELECT COUNT(*) as total FROM agenda";
    $result_agenda = mysqli_query($conn, $query_agenda);
    $dados['total_agendas'] = mysqli_fetch_assoc($result_agenda)['total'];

    // Agendas por situação
    $query_agenda_situacao = "SELECT situacao, COUNT(*) as total FROM agenda GROUP BY situacao";
    $result_agenda_situacao = mysqli_query($conn, $query_agenda_situacao);
    $dados['agenda_situacoes'] = array();
    while($row = mysqli_fetch_assoc($result_agenda_situacao)) {
        $dados['agenda_situacoes'][] = array(
            'situacao' => $row['situacao'],
            'total' => intval($row['total'])
        );
    }

    // Total de produtos
    $query_produtos = "SELECT COUNT(*) as total FROM produtos";
    $result_produtos = mysqli_query($conn, $query_produtos);
    $dados['total_produtos'] = mysqli_fetch_assoc($result_produtos)['total'];

    // Total de posts do blog
    $query_blog = "SELECT COUNT(*) as total FROM blog";
    $result_blog = mysqli_query($conn, $query_blog);
    $dados['total_posts'] = mysqli_fetch_assoc($result_blog)['total'];

    // Total de anotações
    $query_anotacoes = "SELECT COUNT(*) as total FROM anotacoes";
    $result_anotacoes = mysqli_query($conn, $query_anotacoes);
    $dados['total_anotacoes'] = mysqli_fetch_assoc($result_anotacoes)['total'];

    // Agendas por mês (últimos 6 meses)
    $query_agendas_mes = "SELECT 
        MONTH(STR_TO_DATE(data_agenda, '%d/%m/%Y')) as mes,
        YEAR(STR_TO_DATE(data_agenda, '%d/%m/%Y')) as ano,
        COUNT(*) as total 
        FROM agenda 
        WHERE STR_TO_DATE(data_agenda, '%d/%m/%Y') >= DATE_SUB(NOW(), INTERVAL 6 MONTH)
        GROUP BY YEAR(STR_TO_DATE(data_agenda, '%d/%m/%Y')), MONTH(STR_TO_DATE(data_agenda, '%d/%m/%Y'))
        ORDER BY ano, mes";
    $result_agendas_mes = mysqli_query($conn, $query_agendas_mes);
    $dados['agendas_por_mes'] = array();
    while($row = mysqli_fetch_assoc($result_agendas_mes)) {
        $dados['agendas_por_mes'][] = array(
            'mes' => intval($row['mes']),
            'ano' => intval($row['ano']),
            'total' => intval($row['total'])
        );
    }

    // Agendas por profissional
    $query_agenda_profissional = "SELECT 
        u.nome, 
        COUNT(a.id) as total 
        FROM agenda a 
        LEFT JOIN usuarios u ON a.id_profissional = u.id 
        GROUP BY a.id_profissional, u.nome
        ORDER BY total DESC";
    $result_agenda_profissional = mysqli_query($conn, $query_agenda_profissional);
    $dados['agendas_por_profissional'] = array();
    while($row = mysqli_fetch_assoc($result_agenda_profissional)) {
        $dados['agendas_por_profissional'][] = array(
            'nome' => $row['nome'],
            'total' => intval($row['total'])
        );
    }

    // Produtos por marca
    $query_produtos_marca = "SELECT 
        pm.marca, 
        COUNT(p.id) as total 
        FROM produtos p 
        LEFT JOIN produtos_marcas pm ON p.id_marca = pm.id 
        GROUP BY p.id_marca, pm.marca
        ORDER BY total DESC";
    $result_produtos_marca = mysqli_query($conn, $query_produtos_marca);
    $dados['produtos_por_marca'] = array();
    while($row = mysqli_fetch_assoc($result_produtos_marca)) {
        $dados['produtos_por_marca'][] = array(
            'marca' => $row['marca'],
            'total' => intval($row['total'])
        );
    }

    // Últimas atividades (últimos registros)
    $query_ultimas_atividades = "
        (SELECT 'agenda' as tipo, DATE_FORMAT(STR_TO_DATE(CONCAT(data, ' ', hora), '%d/%m/%Y %H:%i'), '%Y-%m-%d %H:%i:%s') as data_atividade, CONCAT('Nova agenda: ', local) as descricao FROM agenda ORDER BY id DESC LIMIT 3)
        UNION ALL
        (SELECT 'blog' as tipo, data as data_atividade, CONCAT('Post publicado: ', titulo) as descricao FROM blog ORDER BY id DESC LIMIT 2)
        UNION ALL
        (SELECT 'produto' as tipo, NOW() as data_atividade, CONCAT('Produto cadastrado: ', descricao) as descricao FROM produtos ORDER BY id DESC LIMIT 2)
        ORDER BY data_atividade DESC LIMIT 10";
    $result_ultimas_atividades = mysqli_query($conn, $query_ultimas_atividades);
    $dados['ultimas_atividades'] = array();
    while($row = mysqli_fetch_assoc($result_ultimas_atividades)) {
        $dados['ultimas_atividades'][] = array(
            'tipo' => $row['tipo'],
            'data' => $row['data_atividade'],
            'descricao' => $row['descricao']
        );
    }

    // Status de resposta
    $dados['status'] = 'success';
    $dados['timestamp'] = date('Y-m-d H:i:s');

    echo json_encode($dados, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode(array(
        'status' => 'error',
        'message' => 'Erro ao buscar dados: ' . $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ), JSON_UNESCAPED_UNICODE);
} finally {
    if (isset($conn)) {
        mysqli_close($conn);
    }
}
?>